/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.acceleo.query.ast.AstFactory;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.query.runtime.QueryParsing;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEParser;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.core.validation.IConvertType;
import org.eclipse.emf.ecoretools.ale.core.validation.QualifiedNames;
import org.eclipse.emf.ecoretools.ale.core.validation.impl.ConvertType;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.Case;
import org.eclipse.emf.ecoretools.ale.implementation.ConditionalBlock;
import org.eclipse.emf.ecoretools.ale.implementation.ExpressionStatement;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureInsert;
import org.eclipse.emf.ecoretools.ale.implementation.FeaturePut;
import org.eclipse.emf.ecoretools.ale.implementation.FeatureRemove;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationFactory;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.Switch;
import org.eclipse.emf.ecoretools.ale.implementation.VariableAssignment;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.VariableInsert;
import org.eclipse.emf.ecoretools.ale.implementation.VariableRemove;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class AntlrAstToAleBehaviorsFactory {
    public static AntlrAstToAleBehaviorsFactory singleton;
    public static final String PARSER_SOURCE = "http://org/eclipse/emf/ecoretools/ale/parser/metadata";
    public static final String PARSER_EXTENDS_KEY = "extends";
    public static final String PARSER_OPPOSITE_KEY = "opposite";
    public static final String RUNTIME_ALE_NSURI = "http://ale/runtime/";
    public static final String PARSER_ID = "org.eclipse.emf.ecoretools.ale";
    private final IQueryEnvironment qryEnv;
    private final IQueryBuilderEngine builder;
    private final IQueryEvaluationEngine aqlEngine;
    private final ImplementationFactory implemFactory;
    private final EcoreFactory ecoreFactory;
    private final AstFactory aqlFactory;
    private final IConvertType convert;

    public static AntlrAstToAleBehaviorsFactory createSingleton(IQueryEnvironment qryEnv) {
        singleton = new AntlrAstToAleBehaviorsFactory(qryEnv);
        return singleton;
    }

    AntlrAstToAleBehaviorsFactory(IQueryEnvironment qryEnv) {
        this.qryEnv = qryEnv;
        this.builder = QueryParsing.newBuilder((IQueryEnvironment)qryEnv);
        this.aqlEngine = QueryEvaluation.newEngine((IQueryEnvironment)qryEnv);
        this.ecoreFactory = (EcoreFactory)((EPackage)qryEnv.getEPackageProvider().getEPackage("ecore").iterator().next()).getEFactoryInstance();
        this.implemFactory = (ImplementationFactory)((EPackage)qryEnv.getEPackageProvider().getEPackage("implementation").iterator().next()).getEFactoryInstance();
        this.aqlFactory = (AstFactory)((EPackage)qryEnv.getEPackageProvider().getEPackage("ast").iterator().next()).getEFactoryInstance();
        this.convert = new ConvertType((IReadOnlyQueryEnvironment)qryEnv);
    }

    public Method buildMethod(EClass fragment, String name, List<Parameter> params, ALEParser.RTypeContext returnType, Block body, List<String> tags) {
        EOperation operation = this.ecoreFactory.createEOperation();
        operation.setName(name);
        params.stream().forEach(p -> {
            EParameter opParam = this.ecoreFactory.createEParameter();
            opParam.setName(p.getName());
            opParam.setEType(p.getType());
            p.getGenericType().ifPresent(t -> {
                boolean bl = opParam.getEGenericType().getETypeArguments().add(t);
            });
            operation.getEParameters().add((Object)opParam);
        });
        ETypedElement type = this.resolve(returnType);
        operation.setEType(type.getEType());
        operation.setUnique(type.isUnique());
        operation.setLowerBound(type.getLowerBound());
        operation.setUpperBound(type.getUpperBound());
        fragment.getEOperations().add((Object)operation);
        return this.buildMethod(operation, body, tags);
    }

    public Method buildMethod(EOperation operation, Block body, List<String> tags) {
        Method newMethod = this.implemFactory.createMethod();
        newMethod.setOperationRef(operation);
        newMethod.setBody(body);
        newMethod.getTags().addAll(tags);
        if (operation != null) {
            operation.getEType();
        }
        return newMethod;
    }

    public Method buildImplementation(String containingClass, String name, List<Parameter> params, ALEParser.RTypeContext returnType, Block body, List<String> tags) {
        Optional<EOperation> existingOperation = this.resolve(containingClass, name, params.size(), returnType);
        Method method = this.buildMethod(existingOperation.orElse(null), body, tags);
        method.setOverriding(true);
        return method;
    }

    public Parameter buildParameter(ALEParser.RTypeContext type, String name, ALEParser.RVariableContext ctx) {
        ETypedElement typedElement = this.resolve(type);
        if (typedElement.isMany()) {
            EGenericType genericType = EcoreFactory.eINSTANCE.createEGenericType();
            genericType.setEClassifier(typedElement.getEType());
            return new Parameter(name, (EClassifier)EcorePackage.eINSTANCE.getEEList(), genericType, ctx);
        }
        return new Parameter(name, typedElement.getEType(), typedElement.getEGenericType(), ctx);
    }

    public Attribute buildAttribute(EClass fragment, String name, ALEParser.RExpressionContext exp, ALEParser.RTypeContext type, int lowerBound, int upperBound, boolean isContainment, boolean isUnique, String opposite, ParsedFile<ModelUnit> parseRes) {
        EReference feature;
        Attribute attribute = this.implemFactory.createAttribute();
        ETypedElement featureType = this.resolve(type);
        if (featureType.getEType() instanceof EClass || isContainment) {
            feature = this.ecoreFactory.createEReference();
            feature.setContainment(isContainment);
        } else {
            feature = this.ecoreFactory.createEAttribute();
        }
        feature.setName(name);
        isUnique = isUnique ? isUnique : featureType.isUnique();
        upperBound = upperBound != 1 ? upperBound : featureType.getUpperBound();
        lowerBound = lowerBound != 0 ? lowerBound : featureType.getLowerBound();
        feature.setUnique(isUnique);
        feature.setEType(featureType.getEType());
        feature.setLowerBound(lowerBound);
        feature.setUpperBound(upperBound);
        attribute.setFeatureRef((EStructuralFeature)feature);
        if (exp != null) {
            attribute.setInitialValue(this.parseExp(exp, parseRes));
        }
        if (opposite != null) {
            EAnnotation annot = this.ecoreFactory.createEAnnotation();
            annot.setSource(PARSER_SOURCE);
            annot.getDetails().put((Object)PARSER_OPPOSITE_KEY, (Object)opposite);
            attribute.getEAnnotations().add((Object)annot);
        }
        fragment.getEStructuralFeatures().add((Object)feature);
        return attribute;
    }

    public VariableDeclaration buildVariableDecl(String name, ALEParser.RExpressionContext exp, ALEParser.RTypeContext type, ParsedFile<ModelUnit> parseRes) {
        VariableDeclaration varDecl = this.implemFactory.createVariableDeclaration();
        varDecl.setName(name);
        if (exp != null) {
            varDecl.setInitialValue(this.parseExp(exp, parseRes));
        }
        ETypedElement declaredType = this.resolve(type);
        varDecl.setType(declaredType);
        return varDecl;
    }

    public VariableAssignment buildVariableAssignement(String name, ALEParser.RExpressionContext exp, ParsedFile<ModelUnit> parseRes) {
        VariableAssignment varAssign = this.implemFactory.createVariableAssignment();
        varAssign.setName(name);
        varAssign.setValue(this.parseExp(exp, parseRes));
        return varAssign;
    }

    public If buildIf(List<ConditionalBlock> cBlocks, Block elseBlock, ParsedFile<ModelUnit> parseRes) {
        If ifStmt = this.implemFactory.createIf();
        ifStmt.getBlocks().addAll(cBlocks);
        ifStmt.setElse(elseBlock);
        return ifStmt;
    }

    public ConditionalBlock buildConditionalBlock(ALEParser.RExpressionContext condition, Block block, ParsedFile<ModelUnit> parseRes) {
        ConditionalBlock cBlock = this.implemFactory.createConditionalBlock();
        cBlock.setCondition(this.parseExp(condition, parseRes));
        cBlock.setBlock(block);
        return cBlock;
    }

    public Block buildBlock(List<Statement> statements) {
        Block block = this.implemFactory.createBlock();
        block.getStatements().addAll(statements);
        return block;
    }

    public ExpressionStatement buildExpressionStatement(ALEParser.RExpressionContext value, ParsedFile<ModelUnit> parseRes) {
        ExpressionStatement exp = this.implemFactory.createExpressionStatement();
        exp.setExpression(this.parseExp(value, parseRes));
        return exp;
    }

    public ForEach buildForEach(String variable, ALEParser.RExpressionContext expression, Block body, ParsedFile<ModelUnit> parseRes) {
        ForEach loop = this.implemFactory.createForEach();
        loop.setVariable(variable);
        loop.setCollectionExpression(this.parseExp(expression, parseRes));
        loop.setBody(body);
        return loop;
    }

    public ForEach buildForEach(String variable, SequenceInExtensionLiteral expression, Block body) {
        ForEach loop = this.implemFactory.createForEach();
        loop.setVariable(variable);
        loop.setCollectionExpression((Expression)expression);
        loop.setBody(body);
        return loop;
    }

    public While buildWhile(ALEParser.RExpressionContext expression, Block body, ParsedFile<ModelUnit> parseRes) {
        While loop = this.implemFactory.createWhile();
        loop.setCondition(this.parseExp(expression, parseRes));
        loop.setBody(body);
        return loop;
    }

    public VariableInsert buildVariableInsert(String name, ALEParser.RExpressionContext exp, ParsedFile<ModelUnit> parseRes) {
        VariableInsert varInsert = this.implemFactory.createVariableInsert();
        varInsert.setName(name);
        varInsert.setValue(this.parseExp(exp, parseRes));
        return varInsert;
    }

    public VariableRemove buildVariableRemove(String name, ALEParser.RExpressionContext exp, ParsedFile<ModelUnit> parseRes) {
        VariableRemove varRemove = this.implemFactory.createVariableRemove();
        varRemove.setName(name);
        varRemove.setValue(this.parseExp(exp, parseRes));
        return varRemove;
    }

    public FeatureAssignment buildFeatureAssign(ALEParser.ExpressionContext target, String feature, ALEParser.RExpressionContext valueExp, ParsedFile<ModelUnit> parseRes) {
        FeatureAssignment featSetting = this.implemFactory.createFeatureAssignment();
        featSetting.setTarget(this.parseAQL(target, parseRes));
        featSetting.setTargetFeature(feature);
        featSetting.setValue(this.parseExp(valueExp, parseRes));
        return featSetting;
    }

    public FeatureInsert buildFeatureInsert(ALEParser.ExpressionContext target, String feature, ALEParser.ExpressionContext valueExp, ParsedFile<ModelUnit> parseRes) {
        FeatureInsert featSetting = this.implemFactory.createFeatureInsert();
        featSetting.setTarget(this.parseAQL(target, parseRes));
        featSetting.setTargetFeature(feature);
        featSetting.setValue(this.parseAQL(valueExp, parseRes));
        return featSetting;
    }

    public FeatureRemove buildFeatureRemove(ALEParser.ExpressionContext target, String feature, ALEParser.ExpressionContext valueExp, ParsedFile<ModelUnit> parseRes) {
        FeatureRemove featSetting = this.implemFactory.createFeatureRemove();
        featSetting.setTarget(this.parseAQL(target, parseRes));
        featSetting.setTargetFeature(feature);
        featSetting.setValue(this.parseAQL(valueExp, parseRes));
        return featSetting;
    }

    public FeaturePut buildFeaturePut(ALEParser.ExpressionContext target, String feature, ALEParser.ExpressionContext keyExp, ALEParser.ExpressionContext valueExp, ParsedFile<ModelUnit> parseRes) {
        FeaturePut featSetting = this.implemFactory.createFeaturePut();
        featSetting.setTarget(this.parseAQL(target, parseRes));
        featSetting.setTargetFeature(feature);
        featSetting.setKey(this.parseAQL(keyExp, parseRes));
        featSetting.setValue(this.parseAQL(valueExp, parseRes));
        return featSetting;
    }

    public ExtendedClass buildExtendedClass(String baseCls, List<Attribute> attributes, List<Method> operations, List<String> extendedCls) {
        ExtendedClass cls = this.implemFactory.createExtendedClass();
        EClassifier resolvedType = this.resolve(baseCls);
        if (resolvedType instanceof EClass) {
            cls.setBaseClass((EClass)resolvedType);
        }
        cls.getMethods().addAll(operations);
        cls.getAttributes().addAll(attributes);
        cls.setName(baseCls);
        extendedCls.stream().forEach(xtd -> {
            EAnnotation annot = this.ecoreFactory.createEAnnotation();
            annot.setSource(PARSER_SOURCE);
            annot.getDetails().put((Object)PARSER_EXTENDS_KEY, xtd);
            cls.getEAnnotations().add((Object)annot);
        });
        return cls;
    }

    public RuntimeClass buildRuntimeClass(String name, List<Attribute> attributes, List<Method> operations) {
        RuntimeClass cls = this.implemFactory.createRuntimeClass();
        cls.setName(name);
        cls.getMethods().addAll(operations);
        cls.getAttributes().addAll(attributes);
        return cls;
    }

    public SequenceInExtensionLiteral buildIntSequence(String left, String right) {
        SequenceInExtensionLiteral seq = this.aqlFactory.createSequenceInExtensionLiteral();
        try {
            int min = Integer.parseInt(left);
            int max = Integer.parseInt(right);
            if (min <= max) {
                int i = min;
                while (i <= max) {
                    IntegerLiteral item = this.aqlFactory.createIntegerLiteral();
                    item.setValue(i);
                    seq.getValues().add((Object)item);
                    ++i;
                }
            } else {
                int i = min;
                while (i >= max) {
                    IntegerLiteral item = this.aqlFactory.createIntegerLiteral();
                    item.setValue(i);
                    seq.getValues().add((Object)item);
                    --i;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return seq;
    }

    public EPackage buildEPackage(String qualifiedName) {
        EClass ePkgClass = EcorePackage.eINSTANCE.getEPackage();
        EPackage newPkg = (EPackage)EcoreUtil.create((EClass)ePkgClass);
        String[] segments = qualifiedName.split("\\.");
        newPkg.setName(segments[0]);
        newPkg.setNsPrefix(segments[0]);
        newPkg.setNsURI(RUNTIME_ALE_NSURI + segments[0]);
        int i = 1;
        EPackage parent = newPkg;
        while (i < segments.length) {
            String segment = segments[i];
            EPackage subPkg = (EPackage)EcoreUtil.create((EClass)ePkgClass);
            subPkg.setName(segment);
            parent.getESubpackages().add((Object)subPkg);
            subPkg.setNsPrefix(segment);
            subPkg.setNsURI(String.valueOf(parent.getNsURI()) + "/" + segment);
            parent = subPkg;
            ++i;
        }
        return parent;
    }

    public EClass buildEClass(String name) {
        EClass eClsClass = EcorePackage.eINSTANCE.getEClass();
        EClass cls = (EClass)EcoreUtil.create((EClass)eClsClass);
        cls.setName(name);
        return cls;
    }

    public void updateEClass(EClass cls, RuntimeClass clsDef) {
        clsDef.getAttributes().stream().forEach(attr -> {
            EStructuralFeature featureCopy = (EStructuralFeature)EcoreUtil.copy((EObject)attr.getFeatureRef());
            cls.getEStructuralFeatures().add((Object)featureCopy);
            attr.setFeatureRef(featureCopy);
        });
        clsDef.getMethods().stream().forEach(mtd -> {
            if (mtd.getOperationRef() != null) {
                EOperation newOp = (EOperation)EcoreUtil.copy((EObject)mtd.getOperationRef());
                cls.getEOperations().add((Object)newOp);
                mtd.setOperationRef(newOp);
            }
        });
    }

    public Optional<EOperation> resolve(String className, String methodName, int nbArgs, ALEParser.RTypeContext returnType) {
        EClassifier type = this.resolve(returnType).getEType();
        String packageName = null;
        boolean isFullyQualifiedName = className.contains(".");
        if (isFullyQualifiedName) {
            packageName = className.substring(0, className.lastIndexOf(46)).replace(".", "::");
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        String finalPackageName = packageName;
        String finalClassName = className;
        return this.qryEnv.getEPackageProvider().getEClassifiers().stream().filter(cls -> cls instanceof EClass).map(EClass.class::cast).filter(cls -> cls.getName().equals(finalClassName)).filter(cls -> finalPackageName == null ? true : finalPackageName.equals(QualifiedNames.getQualifiedName(cls.getEPackage()))).flatMap(cls -> cls.getEAllOperations().stream()).filter(op -> op.getName().equals(methodName) && op.getEParameters().size() == nbArgs && op.getEType() == type).findFirst();
    }

    public EClassifier resolve(String typeName) {
        Optional<EClassifier> candidate;
        String className = typeName.replaceAll("::", ".");
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex != -1 && lastDotIndex < className.length()) {
            String simpleName = className.substring(lastDotIndex + 1);
            Collection clsCandidates = this.qryEnv.getEPackageProvider().getTypes(simpleName);
            Optional<EClassifier> foundCls = clsCandidates.stream().filter(c -> AntlrAstToAleBehaviorsFactory.getQualifiedName(c).equals(className)).findFirst();
            if (foundCls.isPresent()) {
                return foundCls.get();
            }
        }
        if ((candidate = this.qryEnv.getEPackageProvider().getEClassifiers().stream().filter(cls -> !cls.getEPackage().getName().equals("implementation")).filter(cls -> cls.getName().equals(className)).findFirst()).isPresent()) {
            return candidate.get();
        }
        switch (className) {
            case "String": {
                return EcorePackage.eINSTANCE.getEString();
            }
            case "boolean": {
                return EcorePackage.eINSTANCE.getEBoolean();
            }
            case "byte": {
                return EcorePackage.eINSTANCE.getEByte();
            }
            case "char": {
                return EcorePackage.eINSTANCE.getEChar();
            }
            case "short": {
                return EcorePackage.eINSTANCE.getEShort();
            }
            case "int": {
                return EcorePackage.eINSTANCE.getEInt();
            }
            case "long": {
                return EcorePackage.eINSTANCE.getELong();
            }
            case "float": {
                return EcorePackage.eINSTANCE.getEFloat();
            }
            case "double": {
                return EcorePackage.eINSTANCE.getEDouble();
            }
            case "Double": {
                return EcorePackage.eINSTANCE.getEDouble();
            }
            case "void": {
                return ImplementationPackage.eINSTANCE.getVoidEClassifier();
            }
        }
        return ImplementationPackage.eINSTANCE.getUnresolvedEClassifier();
    }

    public ETypedElement resolve(ALEParser.RTypeContext type) {
        ALEParser.TypeLiteralContext typeLit = type.typeLiteral();
        if (typeLit != null) {
            IQueryBuilderEngine.AstResult astResult = this.builder.build(type.getText());
            EvaluationResult evaluationResult = this.aqlEngine.eval(astResult, (Map)Maps.newHashMap());
            Object result = evaluationResult.getResult();
            if (astResult.getAst() instanceof CollectionTypeLiteral) {
                CollectionTypeLiteral aqlCollection = (CollectionTypeLiteral)astResult.getAst();
                boolean isUnique = Set.class.equals(aqlCollection.getValue());
                EClassifier classifier = this.convert.toEMF(aqlCollection.getElementType()).orElse((EClassifier)ImplementationPackage.eINSTANCE.getUnresolvedEClassifier());
                return AntlrAstToAleBehaviorsFactory.createRawType(classifier, isUnique, 0, -1);
            }
            if (result instanceof EClassifier) {
                return AntlrAstToAleBehaviorsFactory.createRawType((EClassifier)result, false, 0, 1);
            }
            if (result instanceof Class) {
                EClassifier classifier = this.convert.toEMF((Class)result);
                return AntlrAstToAleBehaviorsFactory.createRawType(classifier, false, 0, 1);
            }
        }
        return AntlrAstToAleBehaviorsFactory.createRawType(this.resolve(type.getText()), false, 0, 1);
    }

    private static ETypedElement createRawType(EClassifier classifier, boolean isUnique, int lowerBound, int upperBound) {
        EAttribute element = EcoreFactory.eINSTANCE.createEAttribute();
        element.setEType(classifier);
        element.setUnique(isUnique);
        element.setLowerBound(lowerBound);
        element.setUpperBound(upperBound);
        return element;
    }

    public static String getQualifiedName(EClassifier cls) {
        ArrayList<String> fullName = new ArrayList<String>();
        fullName.add(cls.getName());
        EPackage current = cls.getEPackage();
        fullName.add(current.getName());
        while (current.getESuperPackage() != null) {
            current = current.getESuperPackage();
            fullName.add(current.getName());
        }
        return String.join((CharSequence)".", Lists.reverse(fullName));
    }

    public Expression parseExp(ALEParser.RExpressionContext ctx, ParsedFile<ModelUnit> parseRes) {
        if (ctx.rSwitch() != null) {
            return this.parseSwitch(ctx.rSwitch(), parseRes);
        }
        return this.parseAQL(ctx.expression(), parseRes);
    }

    public Expression parseSwitch(ALEParser.RSwitchContext ctx, ParsedFile<ModelUnit> parseRes) {
        Switch switchExp = this.implemFactory.createSwitch();
        ALEParser.RExpressionContext paramVal = ctx.paramVal;
        List<ALEParser.RCaseContext> cases = ctx.cases;
        ALEParser.RExpressionContext defaultExp = ctx.other;
        switchExp.setParam(this.parseExp(paramVal, parseRes));
        switchExp.setDefault(this.parseExp(defaultExp, parseRes));
        cases.forEach(caseCtx -> {
            Case newCase = this.implemFactory.createCase();
            if (caseCtx.guard != null) {
                newCase.setGuard(this.resolve(caseCtx.guard).getEType());
            }
            if (caseCtx.match != null) {
                newCase.setMatch(this.parseExp(caseCtx.match, parseRes));
            }
            newCase.setValue(this.parseExp(caseCtx.value, parseRes));
            switchExp.getCases().add((Object)newCase);
        });
        if (ctx.paramName != null) {
            String paramName = ctx.paramName.getText();
            Let let = this.aqlFactory.createLet();
            Binding binding = this.aqlFactory.createBinding();
            binding.setName(paramName);
            binding.setValue(switchExp.getParam());
            let.getBindings().add((Object)binding);
            let.setBody((Expression)switchExp);
            IQueryBuilderEngine.AstResult astRes = this.builder.build(paramName);
            Expression param = astRes.getAst();
            switchExp.setParam(param);
            return let;
        }
        return switchExp;
    }

    public Expression parseAQL(ALEParser.ExpressionContext ctx, ParsedFile<ModelUnit> parseRes) {
        String text = AntlrAstToAleBehaviorsFactory.safeGetText(ctx);
        IQueryBuilderEngine.AstResult astRes = this.builder.build(text);
        Expression res = astRes.getAst();
        parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
        parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
        List<Integer> lines = IntStream.rangeClosed(ctx.start.getLine(), ctx.stop.getLine()).boxed().collect(Collectors.toList());
        parseRes.setLines(res, lines);
        int startOffset = ctx.start.getStartIndex();
        TreeIterator allSubExp = res.eAllContents();
        allSubExp.forEachRemaining(subExp -> {
            if (subExp instanceof Expression) {
                int relativeStart = astRes.getStartPosition((Expression)subExp);
                int relativeEnd = astRes.getEndPosition((Expression)subExp);
                if (relativeStart != -1 && relativeEnd != -1) {
                    parseRes.getStartPositions().put(subExp, relativeStart + startOffset);
                    parseRes.getEndPositions().put(subExp, relativeEnd + startOffset);
                    parseRes.setLines(subExp, lines);
                }
            }
        });
        return res;
    }

    public static String safeGetText(ALEParser.ExpressionContext exp) {
        Interval interval = new Interval(exp.start.getStartIndex(), exp.stop.getStopIndex());
        return exp.start.getInputStream().getText(interval);
    }

    public static class Parameter {
        private String name;
        private EClassifier type;
        private EGenericType genericType;
        ALEParser.RVariableContext ctx;

        public Parameter(String name, EClassifier type, ALEParser.RVariableContext ctx) {
            this(name, type, null, ctx);
        }

        public Parameter(String name, EClassifier type, EGenericType genericType, ALEParser.RVariableContext ctx) {
            this.name = name;
            this.type = type;
            this.genericType = genericType;
            this.ctx = ctx;
        }

        public String getName() {
            return this.name;
        }

        public EClassifier getType() {
            return this.type;
        }

        public Optional<EGenericType> getGenericType() {
            return Optional.ofNullable(this.genericType);
        }

        public ALEParser.RVariableContext getCtx() {
            return this.ctx;
        }
    }
}

