/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.sequential.javaengine;

import fr.inria.diverse.k3.al.annotationprocessor.Step;
import fr.inria.diverse.k3.al.annotationprocessor.stepmanager.IStepManager;
import fr.inria.diverse.k3.al.annotationprocessor.stepmanager.StepCommand;
import fr.inria.diverse.k3.al.annotationprocessor.stepmanager.StepManagerRegistry;
import fr.inria.diverse.melange.adapters.EObjectAdapter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gemoc.execution.sequential.javaengine.Activator;
import org.eclipse.gemoc.executionframework.engine.commons.GenericModelExecutionContext;
import org.eclipse.gemoc.executionframework.engine.commons.K3DslHelper;
import org.eclipse.gemoc.executionframework.engine.commons.sequential.ISequentialRunConfiguration;
import org.eclipse.gemoc.executionframework.engine.core.AbstractCommandBasedSequentialExecutionEngine;
import org.eclipse.gemoc.executionframework.engine.core.EngineStoppedException;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.osgi.framework.Bundle;

public class PlainK3ExecutionEngine
extends AbstractCommandBasedSequentialExecutionEngine<GenericModelExecutionContext<ISequentialRunConfiguration>, ISequentialRunConfiguration>
implements IStepManager {
    private Method initializeMethod;
    private List<Object> initializeMethodParameters;
    private Method entryPointMethod;
    private List<Object> entryPointMethodParameters;
    private Class<?> entryPointClass;

    public String engineKindName() {
        return "GEMOC Kermeta Sequential Engine";
    }

    protected void prepareEntryPoint(GenericModelExecutionContext<ISequentialRunConfiguration> executionContext) {
        String entryPoint = ((ISequentialRunConfiguration)executionContext.getRunConfiguration()).getExecutionEntryPoint();
        String mainModelElementURI = ((ISequentialRunConfiguration)executionContext.getRunConfiguration()).getModelEntryPoint();
        int startName = "public static void ".length();
        int endName = entryPoint.lastIndexOf("(");
        String methodFullName = entryPoint.substring(startName, endName);
        String aspectClassName = methodFullName.substring(0, methodFullName.lastIndexOf("."));
        String methodName = methodFullName.substring(methodFullName.lastIndexOf(".") + 1);
        Bundle bundle = this.findBundle(executionContext, aspectClassName);
        if (bundle == null) {
            throw new RuntimeException("Could not find bundle for language \"" + ((ISequentialRunConfiguration)executionContext.getRunConfiguration()).getLanguageName() + "\"");
        }
        try {
            this.entryPointClass = bundle.loadClass(aspectClassName);
        }
        catch (ClassNotFoundException e) {
            String bundleName = (String)bundle.getHeaders().get("Bundle-Name");
            e.printStackTrace();
            throw new RuntimeException("Could not find class " + ((ISequentialRunConfiguration)executionContext.getRunConfiguration()).getExecutionEntryPoint() + " in bundle " + bundleName + ".");
        }
        this.entryPointMethodParameters = new ArrayList<Object>();
        EObject root = executionContext.getResourceModel().getEObject(mainModelElementURI);
        if (root instanceof EObjectAdapter) {
            this.entryPointMethodParameters.add(((EObjectAdapter)root).getAdaptee());
        } else {
            this.entryPointMethodParameters.add(root);
        }
        try {
            this.entryPointMethod = K3DslHelper.findMethod(this.entryPointClass, (EObject)root, (String)methodName);
        }
        catch (Exception e) {
            String msg = "There is no \"" + methodName + "\" method in " + this.entryPointClass.getName() + " with first parameter able to handle " + this.entryPointMethodParameters.get(0).toString();
            msg = String.valueOf(msg) + " from " + ((EObject)this.entryPointMethodParameters.get(0)).eClass().getEPackage().getNsURI();
            Activator.error(msg, e);
            throw new RuntimeException("Could not find method main with correct parameters.");
        }
    }

    protected void prepareInitializeModel(GenericModelExecutionContext<ISequentialRunConfiguration> executionContext) {
        String modelInitializationMethodQName = ((ISequentialRunConfiguration)executionContext.getRunConfiguration()).getModelInitializationMethod();
        if (!modelInitializationMethodQName.isEmpty()) {
            Class[] modelInitializationParamType;
            String modelInitializationMethodName = modelInitializationMethodQName.substring(modelInitializationMethodQName.lastIndexOf(".") + 1);
            boolean isListArgs = false;
            boolean isEListArgs = false;
            boolean isFound = false;
            try {
                modelInitializationParamType = new Class[]{this.entryPointMethodParameters.get(0).getClass().getInterfaces()[0], String[].class};
                this.initializeMethod = this.entryPointClass.getMethod(modelInitializationMethodName, modelInitializationParamType);
                isListArgs = false;
                isFound = true;
            }
            catch (Exception exception) {}
            if (!isFound) {
                try {
                    modelInitializationParamType = new Class[]{this.entryPointMethodParameters.get(0).getClass().getInterfaces()[0], List.class};
                    this.initializeMethod = this.entryPointClass.getMethod(modelInitializationMethodName, modelInitializationParamType);
                    isListArgs = true;
                    isFound = true;
                }
                catch (Exception exception) {}
            }
            if (!isFound) {
                try {
                    modelInitializationParamType = new Class[]{this.entryPointMethodParameters.get(0).getClass().getInterfaces()[0], EList.class};
                    this.initializeMethod = this.entryPointClass.getMethod(modelInitializationMethodName, modelInitializationParamType);
                    isEListArgs = true;
                }
                catch (Exception e) {
                    String msg = "There is no \"" + modelInitializationMethodName + "\" method in " + this.entryPointClass.getName() + " with first parameter able to handle " + this.entryPointMethodParameters.get(0).toString();
                    msg = String.valueOf(msg) + " and String[] or List<String> or EList<String> args as second parameter";
                    msg = String.valueOf(msg) + " from " + ((EObject)this.entryPointMethodParameters.get(0)).eClass().getEPackage().getNsURI();
                    Activator.error(msg, e);
                    throw new RuntimeException("Could not find method " + modelInitializationMethodName + " with correct parameters.");
                }
            }
            boolean finalIsListArgs = isListArgs;
            boolean finalIsEListArgs = isEListArgs;
            this.initializeMethodParameters = new ArrayList<Object>();
            this.initializeMethodParameters.add(this.entryPointMethodParameters.get(0));
            if (finalIsListArgs) {
                ArrayList<String> modelInitializationListParameters = new ArrayList<String>();
                String[] stringArray = ((ISequentialRunConfiguration)executionContext.getRunConfiguration()).getModelInitializationArguments().split("\\r?\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    modelInitializationListParameters.add(s);
                    ++n2;
                }
                this.initializeMethodParameters.add(modelInitializationListParameters);
            } else if (finalIsEListArgs) {
                BasicEList modelInitializationListParameters = new BasicEList();
                String[] stringArray = ((ISequentialRunConfiguration)executionContext.getRunConfiguration()).getModelInitializationArguments().split("\\r?\\n");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String s = stringArray[n3];
                    modelInitializationListParameters.add((Object)s);
                    ++n3;
                }
                this.initializeMethodParameters.add(modelInitializationListParameters);
            } else {
                this.initializeMethodParameters.add(((ISequentialRunConfiguration)executionContext.getRunConfiguration()).getModelInitializationArguments().split("\\r?\\n"));
            }
        }
    }

    private void callInitializeModel() {
        try {
            this.initializeMethod.invoke(null, this.initializeMethodParameters.toArray());
        }
        catch (EngineStoppedException stopExeception) {
            throw stopExeception;
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof EngineStoppedException) {
                throw (EngineStoppedException)ite.getCause();
            }
            throw new RuntimeException(ite);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initializeModel() {
        if (this.initializeMethod != null) {
            StepManagerRegistry.getInstance().registerManager((IStepManager)this);
            try {
                boolean isStepMethod = this.initializeMethod.isAnnotationPresent(Step.class);
                if (!isStepMethod) {
                    StepCommand command = new StepCommand(){

                        public void execute() {
                            PlainK3ExecutionEngine.this.callInitializeModel();
                        }
                    };
                    PlainK3ExecutionEngine stepManager = this;
                    stepManager.executeStep(this.entryPointMethodParameters.get(0), this.initializeMethodParameters.toArray(), command, this.entryPointClass.getName(), this.initializeMethod.getName());
                } else {
                    this.callInitializeModel();
                }
            }
            finally {
                StepManagerRegistry.getInstance().unregisterManager((IStepManager)this);
            }
        }
    }

    protected void executeEntryPoint() {
        StepManagerRegistry.getInstance().registerManager((IStepManager)this);
        try {
            try {
                this.entryPointMethod.invoke(null, this.entryPointMethodParameters.get(0));
            }
            catch (EngineStoppedException stopExeception) {
                throw stopExeception;
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof EngineStoppedException) {
                    throw (EngineStoppedException)ite.getCause();
                }
                throw new RuntimeException(ite);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            StepManagerRegistry.getInstance().unregisterManager((IStepManager)this);
        }
    }

    public void executeStep(Object caller, StepCommand command, String className, String methodName) {
        this.executeStep(caller, new Object[0], command, className, methodName);
    }

    public void executeStep(Object caller, Object[] parameters, final StepCommand command, String className, String methodName) {
        this.executeOperation(caller, parameters, className, methodName, new Callable<List<Object>>(){

            @Override
            public List<Object> call() throws Exception {
                command.execute();
                return command.getResult();
            }
        });
    }

    public boolean canHandle(Object caller) {
        if (caller instanceof EObject) {
            EObject eObj = (EObject)caller;
            TransactionalEditingDomain editingDomain = PlainK3ExecutionEngine.getEditingDomain(eObj);
            return editingDomain == this.editingDomain;
        }
        return false;
    }

    private Bundle findBundle(GenericModelExecutionContext<ISequentialRunConfiguration> executionContext, String aspectClassName) {
        IType mainIType = this.getITypeMainByWorkspaceScope(aspectClassName);
        Bundle bundle = null;
        String bundleName = null;
        if (mainIType != null) {
            IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)mainIType.getPackageFragment().getParent();
            bundleName = packageFragmentRoot.getPath().removeLastSegments(1).lastSegment().toString();
            if (bundleName != null) {
                bundle = Platform.getBundle((String)bundleName);
            }
        } else {
            bundle = ((GenericModelExecutionContext)this._executionContext).getDslBundle();
        }
        return bundle;
    }

    private IType getITypeMainByWorkspaceScope(String className) {
        SearchPattern pattern = SearchPattern.createPattern((String)className, (int)5, (int)0, (int)0);
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        final ArrayList binaryType = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                binaryType.add((IType)match.getElement());
            }
        };
        SearchEngine engine = new SearchEngine();
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        }
        catch (CoreException e1) {
            throw new RuntimeException("Error while searching the bundle: " + e1.getMessage());
        }
        return binaryType.isEmpty() ? null : (IType)binaryType.get(0);
    }

    private static TransactionalEditingDomain getEditingDomain(EObject o) {
        return PlainK3ExecutionEngine.getEditingDomain(o.eResource().getResourceSet());
    }

    private static InternalTransactionalEditingDomain getEditingDomain(ResourceSet rs) {
        TransactionalEditingDomain edomain = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(rs);
        if (edomain instanceof InternalTransactionalEditingDomain) {
            return (InternalTransactionalEditingDomain)edomain;
        }
        return null;
    }

    public static Resource loadModel(URI modelURI) {
        Resource resource = null;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resource = resourceSet.createResource(modelURI);
        try {
            resource.load(null);
        }
        catch (IOException iOException) {}
        return resource;
    }
}

