/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.field;

import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.Database;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.EmptyString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IString;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IDestructableField;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.IField;

public class FieldString
implements IDestructableField,
IField {
    public static final int RECORD_SIZE = 4;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private int offset;

    public IString get(Nd nd, long address) {
        Database db = nd.getDB();
        long namerec = db.getRecPtr(address + (long)this.offset);
        if (namerec == 0L) {
            return EmptyString.create();
        }
        return db.getString(namerec);
    }

    public void put(Nd nd, long address, char[] newString) {
        if (newString == null) {
            newString = EMPTY_CHAR_ARRAY;
        }
        Database db = nd.getDB();
        IString name = this.get(nd, address);
        if (name.compare(newString, true) != 0) {
            name.delete();
            if (newString != null && newString.length > 0) {
                db.putRecPtr(address + (long)this.offset, db.newString(newString).getRecord());
            } else {
                db.putRecPtr(address + (long)this.offset, 0L);
            }
        }
    }

    public void put(Nd nd, long address, String newString) {
        this.put(nd, address, newString.toCharArray());
    }

    @Override
    public void destruct(Nd nd, long address) {
        this.get(nd, address).delete();
        nd.getDB().putRecPtr(address + (long)this.offset, 0L);
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getRecordSize() {
        return 4;
    }
}

