/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.multidimensional.timeline.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.embed.swt.FXCanvas;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gemoc.addon.multidimensional.timeline.Activator;
import org.eclipse.gemoc.addon.multidimensional.timeline.views.MultidimensionalTimelineRenderer;
import org.eclipse.gemoc.executionframework.debugger.AbstractGemocDebugger;
import org.eclipse.gemoc.executionframework.engine.ui.launcher.AbstractGemocLauncher;
import org.eclipse.gemoc.executionframework.ui.views.engine.EngineSelectionDependentViewPart;
import org.eclipse.gemoc.executionframework.ui.views.engine.actions.AbstractEngineAction;
import org.eclipse.gemoc.trace.commons.model.launchconfiguration.LaunchConfiguration;
import org.eclipse.gemoc.trace.commons.model.trace.Dimension;
import org.eclipse.gemoc.trace.commons.model.trace.State;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;
import org.eclipse.gemoc.trace.commons.model.trace.Value;
import org.eclipse.gemoc.trace.gemoc.api.IMultiDimensionalTraceAddon;
import org.eclipse.gemoc.trace.gemoc.api.ITraceExtractor;
import org.eclipse.gemoc.trace.gemoc.traceaddon.AbstractTraceAddon;
import org.eclipse.gemoc.xdsmlframework.api.core.EngineStatus;
import org.eclipse.gemoc.xdsmlframework.api.core.ExecutionMode;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;

public class MultidimensionalTimelineViewPart
extends EngineSelectionDependentViewPart {
    public static final String ID = "org.eclipse.gemoc.addon.multidimensional.timeline.views.timeline.MultidimensionalTimeLineView";
    private FXCanvas fxCanvas;
    private MultidimensionalTimelineRenderer timelineRenderer;
    private IMultiDimensionalTraceAddon<Step<?>, State<?, ?>, TracedObject<?>, Dimension<?>, Value<?>> traceAddon;
    private final List<EObject> statesToBreakTo = new ArrayList<EObject>();
    private AbstractGemocDebugger debugger = null;
    private IExecutionEngine engine = null;
    private State<?, ?> breakAtVectorState = null;
    private int breakAtStateIndex = -1;

    public List<EObject> getStatesToBreakTo() {
        return Collections.unmodifiableList(this.statesToBreakTo);
    }

    public void dispose() {
        super.dispose();
        this.timelineRenderer.setTraceExplorer(null);
        this.timelineRenderer.setTraceExtractor(null);
    }

    public void createPartControl(Composite parent) {
        this.fxCanvas = new FXCanvas(parent, 0);
        this.timelineRenderer = new MultidimensionalTimelineRenderer();
        Scene scene = new Scene((Parent)this.timelineRenderer);
        this.fxCanvas.setScene(scene);
        parent.getShell().addListener(11, e -> this.timelineRenderer.refresh());
        this.buildMenu(parent.getShell());
        final Supplier<Integer> getLastClickedState = this.timelineRenderer.getLastClickedStateSupplier();
        Menu menu = new Menu((Control)this.fxCanvas);
        MenuItem launchAndBreakAtStateMenuItem = new MenuItem(menu, 0);
        launchAndBreakAtStateMenuItem.setText("Relaunch and break at this state");
        launchAndBreakAtStateMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MultidimensionalTimelineViewPart.this.breakAtStateIndex = (Integer)getLastClickedState.get();
                if (MultidimensionalTimelineViewPart.this.debugger != null && !MultidimensionalTimelineViewPart.this.debugger.isTerminated()) {
                    MultidimensionalTimelineViewPart.this.debugger.terminate();
                }
                if (MultidimensionalTimelineViewPart.this.engine != null) {
                    MultidimensionalTimelineViewPart.this.engine.stop();
                }
                MultidimensionalTimelineViewPart.this.launchConfigFromTrace();
            }
        });
        MenuItem launchAndBreakAtVectorMenuItem = new MenuItem(menu, 0);
        launchAndBreakAtVectorMenuItem.setText("Relaunch and break at this value vector");
        launchAndBreakAtVectorMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                State state = MultidimensionalTimelineViewPart.this.traceAddon.getTraceExtractor().getState(((Integer)getLastClickedState.get()).intValue());
                MultidimensionalTimelineViewPart.this.breakAtVectorState = state;
                if (MultidimensionalTimelineViewPart.this.debugger != null && !MultidimensionalTimelineViewPart.this.debugger.isTerminated()) {
                    MultidimensionalTimelineViewPart.this.debugger.terminate();
                }
                if (MultidimensionalTimelineViewPart.this.engine != null) {
                    MultidimensionalTimelineViewPart.this.engine.stop();
                }
                MultidimensionalTimelineViewPart.this.launchConfigFromTrace();
            }
        });
        menu.addListener(22, event -> menu.setVisible(true));
        Consumer<List<Boolean>> displayMenu = l -> {
            int i = 0;
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                boolean b = (Boolean)iterator.next();
                menu.getItem(i).setEnabled(b);
                ++i;
            }
            Event event = new Event();
            event.type = 22;
            event.button = 0x100000;
            menu.notifyListeners(22, event);
        };
        this.timelineRenderer.setMenuDisplayer(displayMenu);
    }

    private void buildMenu(final Shell shell) {
        this.addActionToToolbar((Action)new AbstractEngineAction(1){
            private FileDialog saveAsDialog;

            protected void init() {
                super.init();
                this.setText("Save Trace");
                this.setToolTipText("Save Trace");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.multidimensional.timeline", (String)"icons/save.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
                this.saveAsDialog = new FileDialog(shell, 8192);
                this.saveAsDialog.setFilterNames(new String[]{"Trace Files", "All Files (*.*)"});
                this.saveAsDialog.setFilterExtensions(new String[]{"*.trace", "*.*"});
            }

            public void engineSelectionChanged(IExecutionEngine engine) {
            }

            public void run() {
                this.saveAsDialog.setText("Save As");
                String filePath = this.saveAsDialog.open();
                URI uri = URI.createFileURI((String)filePath);
                MultidimensionalTimelineViewPart.this.traceAddon.getTraceConstructor().save(uri);
            }
        });
        this.addActionToToolbar((Action)new AbstractEngineAction(1){

            protected void init() {
                super.init();
                this.setText("Remove Trace");
                this.setToolTipText("Remove Trace");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.multidimensional.timeline", (String)"icons/remove.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
            }

            public void engineSelectionChanged(IExecutionEngine engine) {
            }

            public void run() {
                MultidimensionalTimelineViewPart.this.traceAddon = null;
                MultidimensionalTimelineViewPart.this.timelineRenderer.setTraceExtractor(null);
                MultidimensionalTimelineViewPart.this.timelineRenderer.setTraceExplorer(null);
            }
        });
        this.addActionToToolbar((Action)new AbstractEngineAction(1){
            private FileDialog fileDialog;

            protected void init() {
                super.init();
                this.setText("Open Trace");
                this.setToolTipText("Open Trace");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.multidimensional.timeline", (String)"icons/jload_obj.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
                this.fileDialog = new FileDialog(shell, 4096);
                this.fileDialog.setFilterExtensions(new String[]{"*.trace"});
            }

            public void engineSelectionChanged(IExecutionEngine engine) {
            }

            public void run() {
                this.fileDialog.setText("Open Trace");
                String filePath = this.fileDialog.open();
                if (filePath != null && !filePath.equals("")) {
                    Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
                    Map m = reg.getExtensionToFactoryMap();
                    m.put("trace", new XMIResourceFactoryImpl());
                    ResourceSetImpl resSet = new ResourceSetImpl();
                    URI filePath1URI = URI.createFileURI((String)filePath);
                    Resource traceResource = resSet.getResource(filePath1URI, true);
                    EcoreUtil.resolveAll((Resource)traceResource);
                    AbstractTraceAddon newTraceAddon = null;
                    try {
                        IExtensionRegistry extReg = Platform.getExtensionRegistry();
                        IExtensionPoint ep = extReg.getExtensionPoint("org.eclipse.gemoc.gemoc_language_workbench.engine_addon");
                        IExtension[] extensions = ep.getExtensions();
                        int i = 0;
                        while (i < extensions.length && newTraceAddon == null) {
                            IExtension ext = extensions[i];
                            IConfigurationElement[] confElements = ext.getConfigurationElements();
                            int j = 0;
                            while (j < confElements.length) {
                                AbstractTraceAddon obj_cast;
                                Object obj;
                                IConfigurationElement confElement = confElements[j];
                                String attr = confElement.getAttribute("Class");
                                if (attr != null && (obj = confElement.createExecutableExtension("Class")) instanceof AbstractTraceAddon && (obj_cast = (AbstractTraceAddon)obj).isAddonForTrace((EObject)traceResource.getContents().get(0))) {
                                    newTraceAddon = obj_cast;
                                    break;
                                }
                                ++j;
                            }
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    if (newTraceAddon != null) {
                        MultidimensionalTimelineViewPart.this.traceAddon = newTraceAddon;
                        newTraceAddon.load(traceResource);
                        MultidimensionalTimelineViewPart.this.timelineRenderer.setTraceExtractor(MultidimensionalTimelineViewPart.this.traceAddon.getTraceExtractor());
                        MultidimensionalTimelineViewPart.this.timelineRenderer.setTraceExplorer(MultidimensionalTimelineViewPart.this.traceAddon.getTraceExplorer());
                    }
                }
            }
        });
        this.addActionToToolbar((Action)new AbstractEngineAction(2){

            protected void init() {
                super.init();
                this.setText("Scroll Lock");
                this.setToolTipText("Scroll Lock");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.multidimensional.timeline", (String)"icons/lock_co.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
            }

            public void engineSelectionChanged(IExecutionEngine engine) {
            }

            public void run() {
                MultidimensionalTimelineViewPart.this.timelineRenderer.setScrollLock(this.isChecked());
            }
        });
        this.addActionToToolbar((Action)new AbstractEngineAction(2){

            protected void init() {
                super.init();
                this.setText("State Coloration");
                this.setToolTipText("State Coloration");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.multidimensional.timeline", (String)"icons/state_coloration.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
            }

            public void engineSelectionChanged(IExecutionEngine engine) {
            }

            public void run() {
                MultidimensionalTimelineViewPart.this.timelineRenderer.setStateColoration(this.isChecked());
            }
        });
        this.addActionToToolbar((Action)new AbstractEngineAction(1){
            private InputDialog dialog;

            protected void init() {
                super.init();
                this.setText("Jump to state");
                this.setToolTipText("Jump To State");
                ImageDescriptor id = Activator.imageDescriptorFromPlugin((String)"org.eclipse.gemoc.addon.multidimensional.timeline", (String)"icons/runtoline_co.gif");
                this.setImageDescriptor(id);
                this.setEnabled(true);
                this.dialog = new InputDialog(shell, "Jump to state", "Enter the desired state", "0", s -> {
                    ITraceExtractor extractor = MultidimensionalTimelineViewPart.this.traceAddon.getTraceExtractor();
                    if (extractor == null) {
                        return "Not trace currently loaded";
                    }
                    try {
                        int i = Integer.parseInt(s);
                        if (i > -1 && i < extractor.getStatesTraceLength()) {
                            return null;
                        }
                        return "Not a valid state";
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "Not a valid state";
                    }
                });
            }

            public void engineSelectionChanged(IExecutionEngine engine) {
            }

            public void run() {
                this.dialog.open();
                if (this.dialog.getReturnCode() == 0) {
                    int state = Integer.parseInt(this.dialog.getValue());
                    MultidimensionalTimelineViewPart.this.timelineRenderer.getJumpConsumer().accept(state);
                }
            }
        });
    }

    private void addActionToToolbar(Action action) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)action);
    }

    public void setFocus() {
        if (this.fxCanvas != null) {
            this.fxCanvas.setFocus();
        }
    }

    private boolean canDisplayTimeline(IExecutionEngine engine) {
        if (engine.getExecutionContext().getExecutionMode().equals((Object)ExecutionMode.Run) && engine.getRunningStatus().equals((Object)EngineStatus.RunStatus.Stopped)) {
            return true;
        }
        return engine.getExecutionContext().getExecutionMode().equals((Object)ExecutionMode.Animation);
    }

    public void engineSelectionChanged(IExecutionEngine engine) {
        if (engine != null) {
            Set traceAddons;
            this.engine = engine;
            if (this.canDisplayTimeline(engine) && !(traceAddons = engine.getAddonsTypedBy(IMultiDimensionalTraceAddon.class)).isEmpty()) {
                final IMultiDimensionalTraceAddon traceAddon = (IMultiDimensionalTraceAddon)traceAddons.iterator().next();
                final ITraceExtractor extractor = traceAddon.getTraceExtractor();
                Set debuggers = engine.getAddonsTypedBy(AbstractGemocDebugger.class);
                if (!debuggers.isEmpty()) {
                    BiPredicate<IExecutionEngine, Step<?>> predicate;
                    this.debugger = (AbstractGemocDebugger)debuggers.stream().findFirst().get();
                    if (this.breakAtVectorState != null) {
                        predicate = new BiPredicate<IExecutionEngine, Step<?>>(){
                            final State<?, ?> baseState;
                            {
                                this.baseState = MultidimensionalTimelineViewPart.this.breakAtVectorState;
                            }

                            @Override
                            public boolean test(IExecutionEngine executionEngine, Step<?> step) {
                                ITraceExtractor traceExtractor = traceAddon.getTraceExtractor();
                                int lastStateIndex = traceExtractor.getStatesTraceLength() - 1;
                                State state = traceExtractor.getState(lastStateIndex);
                                return traceExtractor.compareStates(this.baseState, state, true);
                            }
                        };
                        this.debugger.addPredicateBreak((BiPredicate)predicate);
                        this.breakAtVectorState = null;
                    }
                    if (this.breakAtStateIndex != -1) {
                        predicate = new BiPredicate<IExecutionEngine, Step<?>>(){
                            final int stateToBreakTo;
                            {
                                this.stateToBreakTo = MultidimensionalTimelineViewPart.this.breakAtStateIndex;
                            }

                            @Override
                            public boolean test(IExecutionEngine executionEngine, Step<?> step) {
                                int stateToBreakTo;
                                int traceLength = extractor.getStatesTraceLength();
                                boolean result = traceLength == (stateToBreakTo = this.stateToBreakTo) + 1;
                                return result;
                            }
                        };
                        this.debugger.addPredicateBreak((BiPredicate)predicate);
                        this.breakAtStateIndex = -1;
                    }
                }
                this.traceAddon = traceAddon;
                this.timelineRenderer.setTraceExtractor(traceAddon.getTraceExtractor());
                this.timelineRenderer.setTraceExplorer(traceAddon.getTraceExplorer());
            }
        }
    }

    private void launchConfigFromTrace() {
        LaunchConfiguration launchConfiguration = this.traceAddon.getTraceExtractor().getLaunchConfiguration();
        String launchConfigurationType = launchConfiguration.getType();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.debug.core.launchConfigurationTypes");
        Optional<IConfigurationElement> optElt = Arrays.asList(elements).stream().filter(e -> e.getAttribute("id").equals(launchConfigurationType)).findFirst();
        if (optElt.isPresent()) {
            IConfigurationElement elt = optElt.get();
            try {
                Object obj = elt.createExecutableExtension("delegate");
                AbstractGemocLauncher launcher = (AbstractGemocLauncher)obj;
                Map parameters = launcher.parseLaunchConfiguration(launchConfiguration);
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                String launchName = manager.generateLaunchConfigurationName((String)parameters.get("GEMOC_LAUNCH_SELECTED_LANGUAGE"));
                ILaunchConfigurationType type = manager.getLaunchConfigurationType(launchConfigurationType);
                try {
                    ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, launchName);
                    workingCopy.setAttributes(parameters);
                    workingCopy.launch("debug", null, false, true);
                }
                catch (CoreException e2) {
                    Activator.error(e2.getMessage(), e2);
                }
            }
            catch (CoreException e1) {
                Activator.error(e1.getMessage(), e1);
            }
        }
    }
}

