/**
 * generated by Xtext 2.10.0
 */
package org.eclipse.gemoc.validation;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.DslPackage;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.validation.AbstractDslValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * This class contains custom validation rules.
 * 
 * See https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#validation
 */
@SuppressWarnings("all")
public class DslValidator extends AbstractDslValidator {
  public final static String MISSING_NAME = "missingName";
  
  public final static String DUPLICATEKEY = "duplicateKey";
  
  @Check
  public void checkDSLHasName(final Dsl dsl) {
    String _name = dsl.getName();
    boolean _isEmpty = _name.isEmpty();
    if (_isEmpty) {
      this.error("Missing an entry \"name\"", 
        DslPackage.Literals.DSL__NAME, 
        DslValidator.MISSING_NAME);
    }
  }
  
  @Check
  public void checkDuplicateKeys(final Entry entry) {
    EObject _eContainer = entry.eContainer();
    final Dsl dsl = ((Dsl) _eContainer);
    EList<Entry> _entries = dsl.getEntries();
    final Function1<Entry, Boolean> _function = new Function1<Entry, Boolean>() {
      @Override
      public Boolean apply(final Entry e) {
        String _key = e.getKey();
        String _key_1 = entry.getKey();
        return Boolean.valueOf(Objects.equal(_key, _key_1));
      }
    };
    Iterable<Entry> _filter = IterableExtensions.<Entry>filter(_entries, _function);
    final Function1<Entry, Boolean> _function_1 = new Function1<Entry, Boolean>() {
      @Override
      public Boolean apply(final Entry e) {
        return Boolean.valueOf((e == entry));
      }
    };
    boolean _forall = IterableExtensions.<Entry>forall(_filter, _function_1);
    boolean _not = (!_forall);
    if (_not) {
      String _key = entry.getKey();
      String _plus = ("Duplicate key \"" + _key);
      String _plus_1 = (_plus + "\"");
      this.error(_plus_1, 
        DslPackage.Literals.ENTRY__KEY, 
        DslValidator.DUPLICATEKEY);
    }
  }
}
