/**
 * Copyright (c) 2016 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package org.eclipse.gemoc.executionframework.debugger.ui;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

@SuppressWarnings("all")
public class MutableFieldNameProvider extends DefaultDeclarativeQualifiedNameProvider {
  public QualifiedName qualifiedName(final MutableField e) {
    EObject _eObject = e.geteObject();
    QualifiedName _fullyQualifiedName = this.getFullyQualifiedName(_eObject);
    List<String> qnameSegments = _fullyQualifiedName.getSegments();
    EStructuralFeature _mutableProperty = e.getMutableProperty();
    String _name = _mutableProperty.getName();
    qnameSegments.add(_name);
    return QualifiedName.create(qnameSegments);
  }
}
