/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.event.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.gemoc.executionframework.event.manager.EventInstance;
import org.eclipse.gemoc.executionframework.event.manager.IBehavioralAPI;
import org.eclipse.gemoc.executionframework.event.manager.IEventManager;
import org.eclipse.gemoc.executionframework.event.manager.IEventManagerListener;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;

public class EventManager
implements IEventManager {
    private final Queue<EventInstance> eventQueue = new ConcurrentLinkedQueue<EventInstance>();
    private boolean canManageEvents = true;
    private boolean waitForEvents = false;
    private Thread t = null;
    private IBehavioralAPI api;
    private List<IEventManagerListener> listeners = new ArrayList<IEventManagerListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueEvent(EventInstance input) {
        this.eventQueue.add(input);
        if (this.t != null) {
            Thread thread = this.t;
            synchronized (thread) {
                this.t.notify();
            }
            this.t = null;
        }
    }

    @Override
    public boolean canSendEvent(EventInstance event) {
        return this.api == null ? false : this.api.canSendEvent(event);
    }

    @Override
    public void addListener(IEventManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IEventManagerListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processEvents() {
        if (this.api != null && this.canManageEvents) {
            this.canManageEvents = false;
            if (this.waitForEvents && this.eventQueue.isEmpty()) {
                Thread thread = this.t = Thread.currentThread();
                synchronized (thread) {
                    try {
                        this.t.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.waitForEvents = false;
            }
            EventInstance event = this.eventQueue.poll();
            while (event != null) {
                this.api.dispatchEvent(event);
                event = this.eventQueue.poll();
            }
            this.canManageEvents = true;
        }
    }

    @Override
    public void waitForEvents() {
        this.waitForEvents = true;
    }

    public void engineAboutToStart(IExecutionEngine engine) {
        Set apis = engine.getAddonsTypedBy(IBehavioralAPI.class);
        if (!apis.isEmpty()) {
            this.api = (IBehavioralAPI)apis.iterator().next();
        }
    }
}

