/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.test.lib;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipFile;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.junit4.ui.util.IResourcesSetupUtil;
import org.eclipse.xtext.junit4.ui.util.JavaProjectSetupUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WorkspaceTestHelper {
    public static final String CMD_PROJECT_CLEAN = "org.eclipse.ui.project.cleanAction";
    public static final int SWTBotPreferencesTIMEOUT_4_GEMOC = 8000;
    private IProject deployProjectResult = null;
    private static boolean closed = false;

    public void init() {
        Display _default = Display.getDefault();
        _default.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbench _workbench = PlatformUI.getWorkbench();
                    IWorkbench _workbench_1 = PlatformUI.getWorkbench();
                    IWorkbenchWindow _activeWorkbenchWindow = _workbench_1.getActiveWorkbenchWindow();
                    _workbench.showPerspective("org.eclipse.gemoc.xdsmlframework.ide.ui.xdsml.perspective", _activeWorkbenchWindow);
                    WorkspaceTestHelper.this.closeWelcomePage();
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        });
    }

    public IProject getProject(String projectName) {
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = _workspace.getRoot();
        return _root.getProject(projectName);
    }

    public boolean projectExists(String projectName) {
        IProject _project = this.getProject(projectName);
        return _project.exists();
    }

    public IProject deployProject(final String projectName, final String zipLocation) {
        this.deployProjectResult = null;
        final ArrayList thrownException = CollectionLiterals.newArrayList((Object[])new Throwable[0]);
        Display _default = Display.getDefault();
        Runnable _function = new Runnable(){

            @Override
            public void run() {
                try {
                    IProject newProject = JavaProjectSetupUtil.createSimpleProject((String)projectName);
                    ZipFile zip = new ZipFile(zipLocation);
                    ZipLeveledStructureProvider structureProvider = new ZipLeveledStructureProvider(zip);
                    IOverwriteQuery queryOverwrite = new IOverwriteQuery(){

                        public String queryOverwrite(String file) {
                            return "ALL";
                        }
                    };
                    IProject _project = newProject.getProject();
                    IPath _fullPath = _project.getFullPath();
                    Object _root = structureProvider.getRoot();
                    ImportOperation _importOperation = new ImportOperation(_fullPath, _root, (IImportStructureProvider)structureProvider, queryOverwrite);
                    NullProgressMonitor _nullProgressMonitor = new NullProgressMonitor();
                    _importOperation.run((IProgressMonitor)_nullProgressMonitor);
                    zip.close();
                    IProject _project_1 = newProject.getProject();
                    WorkspaceTestHelper.this.deployProjectResult = _project_1;
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        thrownException.add(e);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        };
        _default.syncExec(_function);
        Functions.Function1<Throwable, Boolean> _function_1 = new Functions.Function1<Throwable, Boolean>(){

            public Boolean apply(Throwable e) {
                try {
                    throw new Exception(e);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        IterableExtensions.forall((Iterable)thrownException, (Functions.Function1)_function_1);
        return this.deployProjectResult;
    }

    public void closeWelcomePage() {
        boolean _tripleNotEquals;
        IWorkbench _workbench = PlatformUI.getWorkbench();
        IIntroManager _introManager = _workbench.getIntroManager();
        IIntroPart _intro = _introManager.getIntro();
        boolean bl = _tripleNotEquals = _intro != null;
        if (_tripleNotEquals) {
            IWorkbench _workbench_1 = PlatformUI.getWorkbench();
            IIntroManager _introManager_1 = _workbench_1.getIntroManager();
            IWorkbench _workbench_2 = PlatformUI.getWorkbench();
            IIntroManager _introManager_2 = _workbench_2.getIntroManager();
            IIntroPart _intro_1 = _introManager_2.getIntro();
            _introManager_1.closeIntro(_intro_1);
        }
    }

    public void assertNoMarkers() {
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = _workspace.getRoot();
        IProject[] _projects = _root.getProjects();
        Consumer<IProject> _function = new Consumer<IProject>(){

            @Override
            public void accept(IProject project) {
                try {
                    IMarker[] _findMarkers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    Consumer<IMarker> _function = new Consumer<IMarker>(){

                        @Override
                        public void accept(IMarker m) {
                            try {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append("Found marker ");
                                Object _attribute = m.getAttribute("message");
                                _builder.append(_attribute, "");
                                _builder.append(" (");
                                Object _attribute_1 = m.getAttribute("severity");
                                _builder.append(_attribute_1, "");
                                _builder.append(")");
                                InputOutput.println((Object)_builder.toString());
                                Object _attribute_2 = m.getAttribute("message");
                                String _plus = "Unexpected marker: " + _attribute_2;
                                String _plus_1 = String.valueOf(_plus) + " on ";
                                IResource _resource = m.getResource();
                                IPath _fullPath = _resource.getFullPath();
                                String _plus_2 = String.valueOf(_plus_1) + _fullPath;
                                Object _attribute_3 = m.getAttribute("severity");
                                boolean _equals = Objects.equal((Object)_attribute_3, (Object)2);
                                Assert.assertFalse((String)_plus_2, (boolean)_equals);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    ((List)Conversions.doWrapArray((Object)_findMarkers)).forEach(_function);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        ((List)Conversions.doWrapArray((Object)_projects)).forEach(_function);
    }

    public void assertNoMarkers(final String filename) {
        try {
            IWorkspace _workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot _root = _workspace.getRoot();
            Path _path = new Path(filename);
            IFile mlgFile = _root.getFile((IPath)_path);
            IMarker[] _findMarkers = mlgFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            Consumer<IMarker> _function = new Consumer<IMarker>(){

                @Override
                public void accept(IMarker it) {
                    try {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("Found marker ");
                        Object _attribute = it.getAttribute("message");
                        _builder.append(_attribute, "");
                        _builder.append(" (");
                        Object _attribute_1 = it.getAttribute("severity");
                        _builder.append(_attribute_1, "");
                        _builder.append(")");
                        InputOutput.println((Object)_builder.toString());
                        Object _attribute_2 = it.getAttribute("message");
                        String _plus = "Unexpected marker: " + _attribute_2;
                        String _plus_1 = String.valueOf(_plus) + " on file ";
                        String _plus_2 = String.valueOf(_plus_1) + filename;
                        Object _attribute_3 = it.getAttribute("severity");
                        boolean _equals = Objects.equal((Object)_attribute_3, (Object)2);
                        Assert.assertFalse((String)_plus_2, (boolean)_equals);
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                }
            };
            ((List)Conversions.doWrapArray((Object)_findMarkers)).forEach(_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void assertFileExists(String filename) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = ws.getRoot();
        Path _path = new Path(filename);
        IFile _file = _root.getFile((IPath)_path);
        boolean _exists = _file.exists();
        Assert.assertTrue((String)("Cannot find file " + filename), (boolean)_exists);
    }

    public void assertFileDontExists(String filename) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = ws.getRoot();
        Path _path = new Path(filename);
        IFile _file = _root.getFile((IPath)_path);
        boolean _exists = _file.exists();
        Assert.assertFalse((String)("Found file " + filename), (boolean)_exists);
    }

    public void assertFolderExists(String foldername) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = ws.getRoot();
        Path _path = new Path(foldername);
        IFolder _folder = _root.getFolder((IPath)_path);
        boolean _exists = _folder.exists();
        Assert.assertTrue((String)("Cannot find file " + foldername), (boolean)_exists);
    }

    public void assertProjectExists(String project) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = ws.getRoot();
        IProject _project = _root.getProject(project);
        boolean _exists = _project.exists();
        Assert.assertTrue((String)("Cannot find project " + project), (boolean)_exists);
    }

    public void assertProjectDoesntExists(String project) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = ws.getRoot();
        IProject _project = _root.getProject(project);
        boolean _exists = _project.exists();
        Assert.assertFalse((String)("Can find project " + project), (boolean)_exists);
    }

    public void assertContains(String baseMessage, String searchedString, List<String> list) {
        boolean _contains = list.contains(searchedString);
        Assert.assertTrue((String)(String.valueOf(baseMessage) + " " + searchedString), (boolean)_contains);
    }

    public String runMainClass(IProject project, String mainClass) {
        try {
            boolean _not;
            String outputFileName = "output.txt";
            DebugPlugin _default = DebugPlugin.getDefault();
            ILaunchManager manager = _default.getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
            ILaunchConfigurationWorkingCopy newLaunchConfig = type.newInstance((IContainer)project, "RunMainTransfo");
            String _name = project.getName();
            newLaunchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, _name);
            newLaunchConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, mainClass);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("${workspace_loc:/");
            String _name_1 = project.getName();
            _builder.append(_name_1, "");
            _builder.append("/");
            _builder.append("output.txt", "");
            _builder.append("}");
            newLaunchConfig.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", _builder.toString());
            newLaunchConfig.doSave();
            IFile outputFile = project.getFile("output.txt");
            boolean _exists = outputFile.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                byte[] _bytes = "".getBytes();
                ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
                outputFile.create((InputStream)_byteArrayInputStream, true, null);
            }
            ILaunch launch = newLaunchConfig.launch("run", null);
            long TIMEOUT = 300000L;
            long startTime = System.currentTimeMillis();
            while (!launch.isTerminated() && System.currentTimeMillis() < startTime + 300000L) {
                try {
                    Thread.sleep(50L);
                }
                catch (Throwable _t) {
                    if (_t instanceof InterruptedException) {
                        InterruptedException interruptedException = (InterruptedException)_t;
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            outputFile.refreshLocal(1, null);
            InputStream bi = outputFile.getContents();
            int _available = bi.available();
            byte[] buffer = new byte[_available];
            bi.read(buffer);
            String out = new String(buffer);
            return out;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void debug() {
        IWorkspace _workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot _root = _workspace.getRoot();
        IProject[] _projects = _root.getProjects();
        Consumer<IProject> _function = new Consumer<IProject>(){

            @Override
            public void accept(IProject project) {
                try {
                    String _name = project.getName();
                    String _plus = "Error markers: " + _name;
                    InputOutput.println((Object)_plus);
                    IMarker[] _findMarkers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    Consumer<IMarker> _function = new Consumer<IMarker>(){

                        @Override
                        public void accept(IMarker marker) {
                            try {
                                IResource _resource = marker.getResource();
                                String _name = _resource.getName();
                                String _plus = "   Resource: " + _name;
                                InputOutput.println((Object)_plus);
                                Object _attribute = marker.getAttribute("location");
                                String _plus_1 = "   Location: " + _attribute;
                                InputOutput.println((Object)_plus_1);
                                Object _attribute_1 = marker.getAttribute("message");
                                String _plus_2 = "   Message: " + _attribute_1;
                                String _plus_3 = String.valueOf(_plus_2) + "\n";
                                InputOutput.println((Object)_plus_3);
                            }
                            catch (Throwable _e) {
                                throw Exceptions.sneakyThrow((Throwable)_e);
                            }
                        }
                    };
                    ((List)Conversions.doWrapArray((Object)_findMarkers)).forEach(_function);
                    InputOutput.println((Object)"\n");
                    String _name_1 = project.getName();
                    String _plus_1 = "Classpath: " + _name_1;
                    InputOutput.println((Object)_plus_1);
                    IJavaProject jProject = JavaCore.create((IProject)project);
                    final StringBuffer cp = new StringBuffer();
                    IClasspathEntry[] _resolvedClasspath = jProject.getResolvedClasspath(false);
                    Consumer<IClasspathEntry> _function_1 = new Consumer<IClasspathEntry>(){

                        @Override
                        public void accept(IClasspathEntry entry) {
                            IPath _path = entry.getPath();
                            String _string = _path.toString();
                            String _plus = " " + _string;
                            String _plus_1 = String.valueOf(_plus) + "\n";
                            cp.append(_plus_1);
                        }
                    };
                    ((List)Conversions.doWrapArray((Object)_resolvedClasspath)).forEach(_function_1);
                    String str = cp.toString();
                    InputOutput.println((Object)str);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        ((List)Conversions.doWrapArray((Object)_projects)).forEach(_function);
    }

    public void setTargetPlatform() throws Exception {
        ITargetPlatformService tpService = TargetPlatformService.getDefault();
        ITargetDefinition targetDef = tpService.newTarget();
        targetDef.setName("Tycho platform");
        Bundle _bundle = Platform.getBundle((String)"org.eclipse.core.runtime");
        BundleContext _bundleContext = _bundle.getBundleContext();
        Bundle[] bundles = _bundleContext.getBundles();
        ArrayList<ITargetLocation> bundleContainers = new ArrayList<ITargetLocation>();
        HashSet<File> dirs = new HashSet<File>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _not;
            Bundle bundle = bundleArray[n2];
            EquinoxBundle bundleImpl = (EquinoxBundle)bundle;
            Module _module = bundleImpl.getModule();
            ModuleRevision _currentRevision = _module.getCurrentRevision();
            Object _revisionInfo = _currentRevision.getRevisionInfo();
            BundleInfo.Generation generation = (BundleInfo.Generation)_revisionInfo;
            BundleFile _bundleFile = generation.getBundleFile();
            File file = _bundleFile.getBaseFile();
            File folder = file.getParentFile();
            boolean _contains = dirs.contains(folder);
            boolean bl = _not = !_contains;
            if (_not) {
                dirs.add(folder);
                String _absolutePath = folder.getAbsolutePath();
                ITargetLocation _newDirectoryLocation = tpService.newDirectoryLocation(_absolutePath);
                bundleContainers.add(_newDirectoryLocation);
            }
            ++n2;
        }
        ITargetLocation[] bundleContainersArray = (ITargetLocation[])Conversions.unwrapArray(bundleContainers, ITargetLocation.class);
        targetDef.setTargetLocations(bundleContainersArray);
        String _oSArch = Platform.getOSArch();
        targetDef.setArch(_oSArch);
        String _oS = Platform.getOS();
        targetDef.setOS(_oS);
        String _wS = Platform.getWS();
        targetDef.setWS(_wS);
        String _nL = Platform.getNL();
        targetDef.setNL(_nL);
        tpService.saveTargetDefinition(targetDef);
        LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(targetDef);
        job.schedule();
        job.join();
    }

    public static void invokeCommandOnSelectedFile(String commandId, String file) {
        try {
            boolean _not;
            IHandlerService _service_1;
            ICommandService _service;
            IWorkspace ws = ResourcesPlugin.getWorkspace();
            IWorkbench wb = PlatformUI.getWorkbench();
            ICommandService commandService = _service = (ICommandService)wb.getService(ICommandService.class);
            IHandlerService handlerService = _service_1 = (IHandlerService)wb.getService(IHandlerService.class);
            Command command = commandService.getCommand(commandId);
            ExecutionEvent executionEvent = handlerService.createExecutionEvent(command, null);
            Object _applicationContext = executionEvent.getApplicationContext();
            IEvaluationContext context = (IEvaluationContext)_applicationContext;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)file);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not) {
                IWorkspaceRoot _root = ws.getRoot();
                Path _path = new Path(file);
                IFile iFile = _root.getFile((IPath)_path);
                IEvaluationContext _parent = context.getParent();
                StructuredSelection _structuredSelection = new StructuredSelection((Object)iFile);
                _parent.addVariable("activeMenuSelection", (Object)_structuredSelection);
            }
            command.executeWithChecks(executionEvent);
            IResourcesSetupUtil.reallyWaitForAutoBuild();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public ClassLoader createClassLoader(IJavaProject project) {
        try {
            String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
            ArrayList<URL> urlList = new ArrayList<URL>();
            int i = 0;
            while (i < classPathEntries.length) {
                String entry = classPathEntries[i];
                Path path = new Path(entry);
                File _file = path.toFile();
                URI _uRI = _file.toURI();
                URL url = _uRI.toURL();
                urlList.add(url);
                ++i;
            }
            Class<?> _class = project.getClass();
            ClassLoader parentClassLoader = _class.getClassLoader();
            return new URLClassLoader((URL[])Conversions.unwrapArray(urlList, URL.class), parentClassLoader);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void waitFileExistOrAssert(String fileName, int retry, long sleep) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, retry, true);
        for (Integer i : _doubleDotLessThan) {
            Path _path;
            IWorkspaceRoot _root = ws.getRoot();
            IFile _file = _root.getFile((IPath)(_path = new Path(fileName)));
            boolean _exists = _file.exists();
            if (_exists) {
                return;
            }
            try {
                Thread.sleep(sleep);
            }
            catch (Throwable _t) {
                if (_t instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)_t;
                    continue;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        this.assertFileExists(fileName);
    }

    public static void reallyWaitForJobs(int retry) {
        try {
            IntegerRange _upTo = new IntegerRange(0, retry);
            for (Integer i : _upTo) {
                WorkspaceTestHelper.waitForJobs();
                Thread.sleep(100L);
            }
            WorkspaceTestHelper.waitForJobs();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void waitForJobs() {
        while (!Job.getJobManager().isIdle()) {
            WorkspaceTestHelper.delay(100L);
        }
    }

    public static void delay(long waitTimeMillis) {
        boolean _notEquals;
        Display display = Display.getCurrent();
        IWorkbench _workbench = PlatformUI.getWorkbench();
        _workbench.addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
                closed = true;
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
            }
        });
        boolean bl = _notEquals = !Objects.equal((Object)display, null);
        if (_notEquals) {
            long _currentTimeMillis = System.currentTimeMillis();
            long endTimeMillis = _currentTimeMillis + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis && !closed) {
                boolean _not;
                boolean _readAndDispatch = display.readAndDispatch();
                boolean bl2 = _not = !_readAndDispatch;
                if (!_not) continue;
                display.sleep();
            }
            display.update();
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (Throwable _t) {
                if (_t instanceof InterruptedException) {
                    InterruptedException interruptedException = (InterruptedException)_t;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    static /* synthetic */ boolean access$1() {
        return closed;
    }
}

