/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    int labelHandle;
    int imageHandle;
    int pageHandle;
    int provider;
    Control control;
    TabFolder parent;
    String toolTipText;

    public TabItem(TabFolder parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(index);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int index) {
        this.parent.createItem(this, index);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int height;
        this.checkWidget();
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, allocation);
        int x = allocation.x;
        int y = allocation.y;
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int n = height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            x = this.parent.getClientWidth() - width - x;
        }
        return new Rectangle(x, y, width, height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    int gtk_enter_notify_event(int widget, int event) {
        this.parent.gtk_enter_notify_event(widget, event);
        return 0;
    }

    @Override
    int gtk_mnemonic_activate(int widget, int arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
    }

    @Override
    void register() {
        super.register();
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    @Override
    void release(boolean destroy) {
        if (OS.GTK3 && this.control != null && !this.control.isDisposed()) {
            this.control.release(destroy);
        }
        super.release(destroy);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.pageHandle = 0;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        int index = this.parent.indexOf(this);
        if (index == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    public void setControl(Control control) {
        int selectionIndex;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (control != null && OS.GTK3) {
            OS.gtk_widget_reparent(control.topHandle(), this.pageHandle);
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != (selectionIndex = this.parent.getSelectionIndex()) && newControl != null) {
            Control selectedControl;
            if (selectionIndex != -1 && (selectedControl = this.parent.getItem(selectionIndex).getControl()) == newControl) {
                return;
            }
            newControl.setVisible(false);
            return;
        }
        if (newControl != null) {
            newControl.setBoundsInPixels(this.parent.getClientAreaInPixels());
            newControl.setVisible(true);
        }
        if (oldControl != null && newControl != null && oldControl != newControl) {
            oldControl.setVisible(false);
        }
    }

    void setFontDescription(int font) {
        this.setFontDescription(this.labelHandle, font);
        this.setFontDescription(this.imageHandle, font);
    }

    void setForegroundColor(GdkColor color) {
        if (OS.GTK_VERSION >= OS.VERSION(3, 16, 0)) {
            GdkRGBA rgba = null;
            if (color != null) {
                rgba = this.display.toGdkRGBA(color);
            }
            this.setForegroundColor(this.labelHandle, rgba);
            this.setForegroundColor(this.imageHandle, rgba);
        } else {
            this.setForegroundColor(this.labelHandle, color, false);
            this.setForegroundColor(this.imageHandle, color, false);
        }
    }

    void setForegroundColor(int handle, GdkRGBA rgba) {
        String css;
        GdkRGBA toSet = new GdkRGBA();
        if (rgba != null) {
            toSet = rgba;
        } else {
            GdkColor defaultForeground = this.display.COLOR_WIDGET_FOREGROUND;
            toSet = this.display.toGdkRGBA(defaultForeground);
        }
        int context = OS.gtk_widget_get_style_context(handle);
        String color = this.display.gtk_rgba_to_css_string(toSet);
        this.parent.cssForeground = css = "* {color: " + color + ";}";
        this.gtk_css_provider_load_from_css(context, css);
    }

    void gtk_css_provider_load_from_css(int context, String css) {
        if (this.provider == 0) {
            this.provider = OS.gtk_css_provider_new();
            OS.gtk_style_context_add_provider(context, this.provider, 600);
            OS.g_object_unref(this.provider);
        }
        OS.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(css, true), -1, null);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            } else {
                imageList.put(imageIndex, image);
            }
            int pixbuf = imageList.getPixbuf(imageIndex);
            this.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    @Override
    void setOrientation(boolean create) {
        if ((this.parent.style & 0x4000000) != 0 || !create) {
            int dir;
            int n = dir = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0) {
                OS.gtk_widget_set_direction(this.handle, dir);
            }
            if (this.labelHandle != 0) {
                OS.gtk_widget_set_direction(this.labelHandle, dir);
            }
            if (this.imageHandle != 0) {
                OS.gtk_widget_set_direction(this.imageHandle, dir);
            }
            if (this.pageHandle != 0) {
                OS.gtk_widget_set_direction(this.pageHandle, dir);
            }
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(chars, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (string.length() != 0) {
            OS.gtk_widget_show(this.labelHandle);
        } else {
            OS.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Shell shell = this.parent._getShell();
        shell.setToolTipText(this.handle, string);
        this.toolTipText = string;
    }
}

