/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

class AssertArrayEquals {
    private AssertArrayEquals() {
    }

    static void assertArrayEquals(boolean[] expected, boolean[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> null);
    }

    static void assertArrayEquals(boolean[] expected, boolean[] actual, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> message);
    }

    static void assertArrayEquals(boolean[] expected, boolean[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(char[] expected, char[] actual, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> message);
    }

    static void assertArrayEquals(char[] expected, char[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> null);
    }

    static void assertArrayEquals(char[] expected, char[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(byte[] expected, byte[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> null);
    }

    static void assertArrayEquals(byte[] expected, byte[] actual, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> message);
    }

    static void assertArrayEquals(byte[] expected, byte[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(short[] expected, short[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> null);
    }

    static void assertArrayEquals(short[] expected, short[] actual, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> message);
    }

    static void assertArrayEquals(short[] expected, short[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(int[] expected, int[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> null);
    }

    static void assertArrayEquals(int[] expected, int[] actual, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> message);
    }

    static void assertArrayEquals(int[] expected, int[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(long[] expected, long[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> null);
    }

    static void assertArrayEquals(long[] expected, long[] actual, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> message);
    }

    static void assertArrayEquals(long[] expected, long[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(float[] expected, float[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> null);
    }

    static void assertArrayEquals(float[] expected, float[] actual, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> message);
    }

    static void assertArrayEquals(float[] expected, float[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(float[] expected, float[] actual, float delta) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, () -> null);
    }

    static void assertArrayEquals(float[] expected, float[] actual, float delta, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, () -> message);
    }

    static void assertArrayEquals(float[] expected, float[] actual, float delta, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, null, messageSupplier);
    }

    static void assertArrayEquals(double[] expected, double[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> null);
    }

    static void assertArrayEquals(double[] expected, double[] actual, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> message);
    }

    static void assertArrayEquals(double[] expected, double[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, null, messageSupplier);
    }

    static void assertArrayEquals(double[] expected, double[] actual, double delta) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, () -> null);
    }

    static void assertArrayEquals(double[] expected, double[] actual, double delta, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, () -> message);
    }

    static void assertArrayEquals(double[] expected, double[] actual, double delta, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, null, messageSupplier);
    }

    static void assertArrayEquals(Object[] expected, Object[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> null);
    }

    static void assertArrayEquals(Object[] expected, Object[] actual, String message) {
        AssertArrayEquals.assertArrayEquals(expected, actual, () -> message);
    }

    static void assertArrayEquals(Object[] expected, Object[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, new ArrayDeque<Integer>(), messageSupplier);
    }

    private static void assertArrayEquals(boolean[] expected, boolean[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i], actual[i], AssertArrayEquals.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(char[] expected, char[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            AssertArrayEquals.failArraysNotEqual(Character.valueOf(expected[i]), Character.valueOf(actual[i]), AssertArrayEquals.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(byte[] expected, byte[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i], actual[i], AssertArrayEquals.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(short[] expected, short[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i], actual[i], AssertArrayEquals.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(int[] expected, int[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i], actual[i], AssertArrayEquals.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(long[] expected, long[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i], actual[i], AssertArrayEquals.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(float[] expected, float[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (AssertionUtils.floatsAreEqual(expected[i], actual[i])) continue;
            AssertArrayEquals.failArraysNotEqual(Float.valueOf(expected[i]), Float.valueOf(actual[i]), AssertArrayEquals.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(float[] expected, float[] actual, float delta, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        AssertionUtils.assertValidDelta(delta);
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (AssertionUtils.floatsAreEqual(expected[i], actual[i], delta)) continue;
            AssertArrayEquals.failArraysNotEqual(Float.valueOf(expected[i]), Float.valueOf(actual[i]), AssertArrayEquals.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(double[] expected, double[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (AssertionUtils.doublesAreEqual(expected[i], actual[i])) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i], actual[i], AssertArrayEquals.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(double[] expected, double[] actual, double delta, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        AssertionUtils.assertValidDelta(delta);
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            if (AssertionUtils.doublesAreEqual(expected[i], actual[i], delta)) continue;
            AssertArrayEquals.failArraysNotEqual(expected[i], actual[i], AssertArrayEquals.nullSafeIndexes(indexes, i), messageSupplier);
        }
    }

    private static void assertArrayEquals(Object[] expected, Object[] actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == actual) {
            return;
        }
        AssertArrayEquals.assertArraysNotNull(expected, actual, indexes, messageSupplier);
        AssertArrayEquals.assertArraysHaveSameLength(expected.length, actual.length, indexes, messageSupplier);
        for (int i = 0; i < expected.length; ++i) {
            Object expectedElement = expected[i];
            Object actualElement = actual[i];
            if (expectedElement == actualElement) continue;
            indexes.addLast(i);
            AssertArrayEquals.assertArrayElementsEqual(expectedElement, actualElement, indexes, messageSupplier);
            indexes.removeLast();
        }
    }

    private static void assertArrayElementsEqual(Object expected, Object actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected instanceof Object[] && actual instanceof Object[]) {
            AssertArrayEquals.assertArrayEquals((Object[])expected, (Object[])actual, indexes, messageSupplier);
        } else if (expected instanceof byte[] && actual instanceof byte[]) {
            AssertArrayEquals.assertArrayEquals((byte[])expected, (byte[])actual, indexes, messageSupplier);
        } else if (expected instanceof short[] && actual instanceof short[]) {
            AssertArrayEquals.assertArrayEquals((short[])expected, (short[])actual, indexes, messageSupplier);
        } else if (expected instanceof int[] && actual instanceof int[]) {
            AssertArrayEquals.assertArrayEquals((int[])expected, (int[])actual, indexes, messageSupplier);
        } else if (expected instanceof long[] && actual instanceof long[]) {
            AssertArrayEquals.assertArrayEquals((long[])expected, (long[])actual, indexes, messageSupplier);
        } else if (expected instanceof char[] && actual instanceof char[]) {
            AssertArrayEquals.assertArrayEquals((char[])expected, (char[])actual, indexes, messageSupplier);
        } else if (expected instanceof float[] && actual instanceof float[]) {
            AssertArrayEquals.assertArrayEquals((float[])expected, (float[])actual, indexes, messageSupplier);
        } else if (expected instanceof double[] && actual instanceof double[]) {
            AssertArrayEquals.assertArrayEquals((double[])expected, (double[])actual, indexes, messageSupplier);
        } else if (expected instanceof boolean[] && actual instanceof boolean[]) {
            AssertArrayEquals.assertArrayEquals((boolean[])expected, (boolean[])actual, indexes, messageSupplier);
        } else if (!Objects.equals(expected, actual)) {
            if (expected == null && ReflectionUtils.isArray((Object)actual)) {
                AssertArrayEquals.failExpectedArrayIsNull(indexes, messageSupplier);
            } else if (ReflectionUtils.isArray((Object)expected) && actual == null) {
                AssertArrayEquals.failActualArrayIsNull(indexes, messageSupplier);
            } else {
                AssertArrayEquals.failArraysNotEqual(expected, actual, indexes, messageSupplier);
            }
        }
    }

    private static void assertArraysNotNull(Object expected, Object actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected == null) {
            AssertArrayEquals.failExpectedArrayIsNull(indexes, messageSupplier);
        }
        if (actual == null) {
            AssertArrayEquals.failActualArrayIsNull(indexes, messageSupplier);
        }
    }

    private static void failExpectedArrayIsNull(Deque<Integer> indexes, Supplier<String> messageSupplier) {
        AssertionUtils.fail(AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + "expected array was <null>" + AssertionUtils.formatIndexes(indexes));
    }

    private static void failActualArrayIsNull(Deque<Integer> indexes, Supplier<String> messageSupplier) {
        AssertionUtils.fail(AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + "actual array was <null>" + AssertionUtils.formatIndexes(indexes));
    }

    private static void assertArraysHaveSameLength(int expected, int actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        if (expected != actual) {
            String prefix = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier));
            String message = "array lengths differ" + AssertionUtils.formatIndexes(indexes) + ", expected: <" + expected + "> but was: <" + actual + ">";
            AssertionUtils.fail(prefix + message);
        }
    }

    private static void failArraysNotEqual(Object expected, Object actual, Deque<Integer> indexes, Supplier<String> messageSupplier) {
        String prefix = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier));
        String message = "array contents differ" + AssertionUtils.formatIndexes(indexes) + ", " + AssertionUtils.formatValues(expected, actual);
        AssertionUtils.fail(prefix + message);
    }

    private static Deque<Integer> nullSafeIndexes(Deque<Integer> indexes, int newIndex) {
        ArrayDeque<Integer> result = indexes != null ? indexes : new ArrayDeque<Integer>();
        result.addLast(newIndex);
        return result;
    }
}

