/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.power.behavior;

import fr.inria.aoste.timesquare.backend.manager.datastructure.Entity;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockBehaviorEntity;
import fr.inria.aoste.timesquare.backend.manager.utils.EventEnumeratorPair;
import fr.inria.aoste.timesquare.backend.manager.utils.Filter;
import fr.inria.aoste.timesquare.backend.manager.utils.IFilter;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.ConfigurationHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.DeleteHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.PersistentOptions;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationBehavior;
import fr.inria.aoste.timesquare.backend.power.behavior.ClockPowerBehavior;
import fr.inria.aoste.timesquare.backend.power.behavior.Couple;
import fr.inria.aoste.timesquare.backend.power.behavior.PowerConfiguration;
import fr.inria.aoste.timesquare.backend.power.behavior.PowerHelper;
import fr.inria.aoste.timesquare.backend.power.behavior.PowerPersitenceOption;
import fr.inria.aoste.timesquare.backend.power.view.IPowerView;
import fr.inria.aoste.timesquare.backend.power.view.PowerView;
import fr.inria.aoste.timesquare.launcher.core.inter.CCSLInfo;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolverForBackend;
import fr.inria.aoste.timesquare.launcher.debug.model.output.ReportMessage;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.trace.ModelElementReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class PowerBehaviorManager
extends BehaviorManager {
    private List<Couple> lstCouples = new ArrayList<Couple>();
    private List<ClockPowerBehavior> behaviorList = new ArrayList<ClockPowerBehavior>();
    private PowerHelper power = new PowerHelper();
    private HashMap<PowerPersitenceOption, ClockPowerBehavior> mapoc = new HashMap();
    IPowerView powerView = null;

    public List<Couple> getLstCouples() {
        return this.lstCouples;
    }

    public String getPluginName() {
        return "Power Computation";
    }

    public void clear() {
        this.behaviorList.clear();
    }

    public void deleteEntity(Entity entity, DeleteHelper deletehelper) {
        if (entity != null && this.behaviorList.remove(entity.getBehavior())) {
            for (ClockBehaviorEntity cbe : deletehelper.getClockBehaviorEntity()) {
                if (cbe.getBehavior() != entity.getBehavior()) continue;
                deletehelper.deleteEntity(cbe);
            }
        }
    }

    public boolean isActivable(ReportMessage rm, CCSLInfo ccslhelper) {
        block4: {
            try {
                if (ccslhelper.haveClockWithReferenceTo(UMLPackage.eINSTANCE.getElement())) break block4;
                rm.setMessage("0 Clock have reference to UML ");
                return false;
            }
            catch (Throwable e) {
                e.printStackTrace();
                rm.setMessage("Throw :" + e.getMessage());
                return false;
            }
        }
        ArrayList lst = Filter.sublist((Iterable)ccslhelper.getListofClock(), (IFilter)Filter.FILTER_REFERENCED_OBJECT);
        this.lstCouples = Filter.createPairClockModelElementReference((EventEnumeratorPair)EventEnumeratorPair.StartFinish, (Iterable)lst, (Filter.ICreatePairClockModelElementReference)new CoupleCreator());
        if (this.lstCouples.isEmpty()) {
            rm.setMessage("0 couple start/stop find ");
            return false;
        }
        return true;
    }

    public void manageBehavior(ConfigurationHelper helper) {
        this.power.setConfigurationHelper(helper);
    }

    private void addbehavior(ClockPowerBehavior behavior) {
        this.behaviorList.add(behavior);
        behavior.setPowerHelper(this.power);
    }

    public ClockPowerBehavior redoClockBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        if (persistentOptions instanceof PowerPersitenceOption) {
            PowerPersitenceOption po = (PowerPersitenceOption)persistentOptions;
            ClockPowerBehavior behavior = this.mapoc.get(po);
            if (behavior == null) {
                Couple c = null;
                for (Couple cp : this.lstCouples) {
                    if (!AdapterRegistry.getAdapter((EObject)cp.eo).getUID((EObject)cp.eo).equals(po.streo) || !AdapterRegistry.getAdapter((EObject)cp.getSource()).getUID((EObject)cp.getSource()).equals(po.startid) || !AdapterRegistry.getAdapter((EObject)cp.getDestination()).getUID((EObject)cp.getDestination()).equals(po.stopid)) continue;
                    c = cp;
                    break;
                }
                if (c != null) {
                    po.c = c;
                    behavior = new ClockPowerBehavior(po);
                    this.mapoc.put(po, behavior);
                    this.addbehavior(behavior);
                }
            }
            return behavior;
        }
        return null;
    }

    public void addBehavior(Couple cbehavior) {
        if (this._helper != null && cbehavior != null) {
            for (ClockPowerBehavior b : this.behaviorList) {
                if (!b.options.c.equals((Object)cbehavior)) continue;
                return;
            }
            PowerPersitenceOption options = new PowerPersitenceOption(cbehavior);
            ClockPowerBehavior behavior = new ClockPowerBehavior(options);
            this.addbehavior(behavior);
            ClockEntity cestart = this._helper.getClock((EObject)cbehavior.getSource());
            ClockEntity cestop = this._helper.getClock((EObject)cbehavior.getDestination());
            this._helper.addBehavior(cestart, this._helper.getTicksState(), this.getPluginName(), (ClockBehavior)behavior, (PersistentOptions)options);
            this._helper.addBehavior(cestop, this._helper.getTicksState(), this.getPluginName(), (ClockBehavior)behavior, (PersistentOptions)options);
        }
    }

    public RelationBehavior redoRelationBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        return null;
    }

    public ClockBehavior redoAssertBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        return null;
    }

    public void beforeExecution(ConfigurationHelper helper, IPath folderin, String namefilein, ISolverForBackend solver) {
        this.powerView = PowerView.getCourant();
        this.power.setConfigurationHelper(helper);
        if (this.powerView != null) {
            this.powerView.clear();
            for (ClockPowerBehavior cbp : this.behaviorList) {
                cbp.setPowerData(this.powerView.createPowerData(cbp.options.c.eo.getName()));
            }
        }
    }

    public void end(ConfigurationHelper helper) {
        for (ClockPowerBehavior cpb : this.behaviorList) {
            cpb.dispRapport();
        }
        this.power = null;
        if (this.mapoc != null) {
            this.mapoc.clear();
        }
        this.mapoc = null;
    }

    public void aNewStep(int step) {
        if (this.powerView != null) {
            this.powerView.updatexRuler(step);
        }
        for (ClockPowerBehavior cpb : this.behaviorList) {
            cpb.step(step);
        }
    }

    public PowerConfiguration getConfigurator(ConfigurationHelper configurationHelper) {
        return new PowerConfiguration(configurationHelper, this);
    }

    public class CoupleCreator
    implements Filter.ICreatePairClockModelElementReference<Couple> {
        public Couple create(ModelElementReference src, ModelElementReference dst) {
            List lSrc = AdapterRegistry.getAdapter((EObject)src).fillWithReferencedElements((EObject)src, null);
            List lDst = AdapterRegistry.getAdapter((EObject)dst).fillWithReferencedElements((EObject)dst, null);
            for (EObject eo : lSrc) {
                for (EObject eo2 : lDst) {
                    if (eo2 != eo || !(eo2 instanceof NamedElement)) continue;
                    Couple c = new Couple(src, dst, (NamedElement)eo);
                    return c;
                }
            }
            return null;
        }
    }
}

