/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.launch;

import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.solver.CCSLKernelSolver;
import fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.SolverClock;
import fr.inria.aoste.timesquare.ccslkernel.solver.relation.SolverRelation;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolver;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolverForBackend;
import fr.inria.aoste.timesquare.launcher.select.ConstraintEnable;
import fr.inria.aoste.timesquare.trace.util.ReferenceNameBuilder;
import fr.inria.aoste.timesquare.utils.timedsystem.TimedSystem;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class CCSLKernelSolverWrapper
implements ISolver,
ISolverForBackend {
    private CCSLKernelSolver solver;
    private Exception exception;
    List<ModelElementReference> constraints = null;

    public CCSLKernelSolver getSolver() {
        return this.solver;
    }

    public CCSLKernelSolverWrapper() {
        this.solver = new CCSLKernelSolver();
    }

    public CCSLKernelSolverWrapper(CCSLKernelSolver existingSolver) {
        this.solver = existingSolver;
    }

    public void setListReference(List<Reference> lrf) {
        this.solver.setTraceReferences(lrf);
        lrf.addAll(this.getClockList());
        lrf.addAll(this.getConstraint());
        lrf.addAll(this.getAssertList());
    }

    public LogicalStep solveNextSimulationStep(TimedSystem ts) {
        try {
            return this.solver.doOneSimulationStep();
        }
        catch (SimulationException e) {
            this.exception = e;
            return null;
        }
    }

    public void endSimulation() {
        this.solver.endSimulation();
    }

    public List<LogicalStep> computeAndGetPossibleLogicalSteps() throws SimulationException {
        return this.solver.computeAndGetPossibleLogicalSteps();
    }

    public void constructBDD() throws SimulationException {
        this.solver.constructBDD();
    }

    public List<LogicalStep> getAllPossibleSteps() throws SimulationException {
        return this.solver.getAllPossibleSteps();
    }

    public void clearBDD() throws SimulationException {
        this.solver.clearBDD();
    }

    public List<LogicalStep> updatePossibleLogicalSteps() throws SimulationException {
        return this.solver.updatePossibleLogicalSteps();
    }

    public int proposeLogicalStepByIndex() {
        return this.solver.proposeLogicalStepByIndex();
    }

    public LogicalStep applyLogicalStepByIndex(int chosenLogicalStep) throws SimulationException {
        return this.solver.applyLogicalStepByIndex(chosenLogicalStep);
    }

    public Throwable getException() {
        return this.exception;
    }

    public void endSimulationStep() {
    }

    public ResourceSet getResourceSet() {
        return this.solver.getResourceSet();
    }

    public void start() throws Throwable {
        this.solver.initSimulation();
    }

    public ArrayList<ModelElementReference> getClockList() {
        ArrayList<ModelElementReference> ls = new ArrayList<ModelElementReference>();
        for (RuntimeClock c : this.solver.getAllDiscreteClocks()) {
            ls.add(((SolverClock)c).traceReference);
        }
        return ls;
    }

    public ArrayList<ModelElementReference> getAssertList() {
        ArrayList<ModelElementReference> res = new ArrayList<ModelElementReference>();
        for (SolverRelation rel : this.solver.assertions) {
            res.add(rel.getTraceReference());
        }
        return res;
    }

    public List<ModelElementReference> getConstraint() {
        if (this.constraints == null) {
            this.constraints = new ArrayList<ModelElementReference>();
            for (InstantiatedElement element : this.solver.getUnfoldModel().getInstantiationTree().lookupInstances(null)) {
                SolverClock iClock;
                if (element.isKernelRelation() && !element.isAssertion()) {
                    SolverRelation rel = (SolverRelation)this.solver.getConcreteInstantiationTree().lookupInstance(element.getInstantiationPath());
                    if (rel == null) continue;
                    this.constraints.add(rel.getTraceReference());
                    continue;
                }
                if (element.isKernelExpression()) {
                    iClock = (SolverClock)this.solver.getClockInstantiationTree().lookupInstance(element.getInstantiationPath());
                    if (iClock != null) {
                        this.constraints.add(iClock.traceReference);
                        continue;
                    }
                    throw new NullPointerException("Null implicitClock for Kernel Expression");
                }
                if (!element.isExpression() || element.isConditional()) continue;
                iClock = (SolverClock)this.solver.getClockInstantiationTree().lookupInstance(element.getInstantiationPath());
                if (iClock != null) {
                    this.constraints.add(iClock.traceReference);
                    continue;
                }
                throw new NullPointerException("Null implicitClock for Expression");
            }
        }
        return this.constraints;
    }

    public ArrayList<ConstraintEnable> getSelectableModel() {
        return new ArrayList<ConstraintEnable>();
    }

    public boolean revertForceClockEffect() throws SimulationException {
        this.solver.revertForceClockEffect();
        return true;
    }

    public void forceClockPresence(ModelElementReference mer) {
        String qualifiedName = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)mer, (String)"::");
        SolverClock clockToForce = this.solver.findClockByPath(qualifiedName);
        this.solver.forceClockPresence(clockToForce);
    }

    public void forceClockAbsence(ModelElementReference mer) {
        String qualifiedName = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)mer, (String)"::");
        SolverClock clockToForce = this.solver.findClockByPath(qualifiedName);
        this.solver.forceClockAbscence(clockToForce);
    }
}

