/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.core;

import fr.inria.aoste.timesquare.launcher.core.PropertySimulation;
import fr.inria.aoste.timesquare.launcher.debug.model.output.OutputSetupOption;
import fr.inria.aoste.timesquare.launcher.extensionpoint.IOutputOption;
import fr.inria.aoste.timesquare.launcher.extensionpoint.IOutputTrace;
import fr.inria.aoste.timesquare.launcher.extensionpoint.OutputControler;
import fr.inria.aoste.timesquare.launcher.extensionpoint.OutputControlerFactory;
import fr.inria.aoste.timesquare.utils.extensionpoint.ExtensionPointManager;
import fr.inria.aoste.timesquare.utils.extensionpoint.IExtensionManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;

public class OutputManager
implements IExtensionManager {
    private static OutputManager _default = null;
    private List<String> listkey = new ArrayList<String>();
    private HashMap<String, OutputControler> hashAttribut = new HashMap();

    public static synchronized OutputManager getDefault() {
        if (_default == null) {
            _default = new OutputManager();
        }
        return _default;
    }

    private OutputManager() {
        ExtensionPointManager.findAllExtensions((IExtensionManager)this);
    }

    public final String getExtensionPointName() {
        return "fr.inria.aoste.timesquare.launcher.core.outputformat";
    }

    public final String getPluginName() {
        return "fr.inria.aoste.timesquare.launcher.core";
    }

    private void initExtensionOutputFormat(IConfigurationElement ice) throws Throwable {
        System.out.println("icename : OutputFormat");
        AttributOutput ao = new AttributOutput(ice);
        ao.outputtrace = ExtensionPointManager.getPointExtensionClass((IConfigurationElement)ice, (String)"outputTrace", IOutputTrace.CLASS);
        ao.outputtrace.newInstance();
        ao.ui = ExtensionPointManager.getPointExtensionClass((IConfigurationElement)ice, (String)"optionUI", OutputSetupOption.CLASS);
        ao.ui.newInstance();
        ao.option = ExtensionPointManager.getPointExtensionClass((IConfigurationElement)ice, (String)"optionData", IOutputOption.CLASS);
        IOutputOption iot = (IOutputOption)ao.option.newInstance();
        if (!PropertySimulation.isOutput(iot.getSupportPropertySimulation())) {
            throw new Exception("Output have Input Property");
        }
        this.listkey.add(ao.getKey());
        this.hashAttribut.put(ao.getKey(), ao);
        System.out.println("  <OutputManager>: Ok :" + ao.getName() + " " + ao.getKey() + " ");
    }

    private void initExtensionOutputController(IConfigurationElement ice) throws Throwable {
        OutputControler[] oct;
        System.out.println("icename : OutputController");
        Class cocf = ExtensionPointManager.getPointExtensionClass((IConfigurationElement)ice, (String)"controler", OutputControlerFactory.CLASS);
        String name = ice.getAttribute("name");
        if (name == null) {
            name = "";
        }
        String keybase = String.valueOf(ExtensionPointManager.getPluginName((IConfigurationElement)ice)) + "@" + name;
        OutputControlerFactory ocf = (OutputControlerFactory)cocf.newInstance();
        OutputControler[] outputControlerArray = oct = ocf.create(keybase);
        int n = oct.length;
        int n2 = 0;
        while (n2 < n) {
            OutputControler oc = outputControlerArray[n2];
            String key = oc.getKey();
            if (key.startsWith(keybase)) {
                this.listkey.add(key);
                this.hashAttribut.put(key, oc);
            }
            ++n2;
        }
    }

    public void initExtension(IConfigurationElement ice) throws Throwable {
        String id = ice.getName();
        if ("OutputController".equals(id)) {
            this.initExtensionOutputController(ice);
            return;
        }
        if ("OutputFormat".equals(id)) {
            this.initExtensionOutputFormat(ice);
        }
    }

    public List<String> getListkey() {
        return Collections.unmodifiableList(this.listkey);
    }

    public List<String> getListkey(Class<?> c) {
        ArrayList<String> lst = new ArrayList<String>();
        for (String s : this.listkey) {
            OutputControler oc = this.hashAttribut.get(s);
            if (!oc.isCompatibleTo(c)) continue;
            lst.add(s);
        }
        return lst;
    }

    public String getkey(Class<?> c) {
        List<String> lst = this.getListkey(c);
        if (lst.size() == 1) {
            return lst.get(0);
        }
        return null;
    }

    public IOutputTrace getTraceforKey(String s) {
        try {
            OutputControler ao = this.hashAttribut.get(s);
            if (ao == null) {
            }
            return ao.newOutputtrace();
        }
        finally {
            return null;
        }
    }

    public IOutputOption getOptionforKey(String s) {
        try {
            OutputControler ao = this.hashAttribut.get(s);
            if (ao == null) {
            }
            IOutputOption io = ao.newOption();
            return io;
        }
        finally {
            return null;
        }
    }

    public OutputSetupOption getUIforKey(String s) {
        try {
            OutputControler ao = this.hashAttribut.get(s);
            if (ao == null) {
            }
            return ao.newUi();
        }
        finally {
            return null;
        }
    }

    private static class AttributOutput
    extends OutputControler {
        private Class<? extends IOutputTrace> outputtrace;
        private Class<? extends IOutputOption> option;
        private Class<? extends OutputSetupOption> ui;

        public AttributOutput(IConfigurationElement ice) {
            super(ice.getAttribute("name"), ice.getAttribute("id"));
        }

        @Override
        public IOutputTrace newOutputtrace() {
            try {
                return this.outputtrace.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public IOutputOption newOption() {
            try {
                return this.option.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public OutputSetupOption newUi() {
            try {
                return this.ui.newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean isCompatibleTo(Class<?> c) {
            if (this.outputtrace.isAssignableFrom(c)) {
                return true;
            }
            if (this.option.isAssignableFrom(c)) {
                return true;
            }
            return this.ui.isAssignableFrom(c);
        }
    }
}

