/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model.output;

import fr.inria.aoste.timesquare.launcher.core.console.ConsoleSimulation;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolverForBackend;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.InitOutputData;
import fr.inria.aoste.timesquare.launcher.extensionpoint.IOutputTrace;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.relation.IOutputTraceList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Display;

public class OutputTraceList
implements IOutputTraceList {
    private ArrayList<IOutputTrace> listoutput = new ArrayList();
    private ConsoleSimulation cs = null;
    private static ISolverForBackend _solver = null;
    private List<EObject> relation = null;

    public OutputTraceList(ISolverForBackend commonSolver) {
        _solver = commonSolver;
    }

    public final synchronized void setCs(ConsoleSimulation cs) {
        this.cs = cs;
        cs.printSimulationMessageln("Output....");
    }

    public synchronized void add(IOutputTrace iot) {
        this.listoutput.add(iot);
    }

    public synchronized void aFinalStep(int step) {
        for (IOutputTrace iot : this.listoutput) {
            try {
                iot.aFinalStep(step);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void aNewStep(LogicalStep step, boolean timed) {
        Thread[] threadarray = new Thread[this.listoutput.size()];
        int i = 0;
        for (IOutputTrace iot : this.listoutput) {
            threadarray[i] = new ThreadNewStep(iot, step, this.cs, timed, this.relation);
            threadarray[i].start();
            ++i;
        }
        Thread[] threadArray = threadarray;
        int n = threadarray.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            try {
                if (t != null) {
                    t.join();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++n2;
        }
        i = 0;
        while (i < threadarray.length) {
            threadarray[i] = null;
            ++i;
        }
        Thread.yield();
    }

    public synchronized void aStep(LogicalStep step, boolean timed) {
        Thread[] threadarray = new Thread[this.listoutput.size()];
        int i = 0;
        for (IOutputTrace iot : this.listoutput) {
            threadarray[i] = new ThreadStep(iot, step, timed);
            threadarray[i].start();
            ++i;
        }
        Thread.yield();
        Thread[] threadArray = threadarray;
        int n = threadarray.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            try {
                if (t != null) {
                    t.join();
                }
                t = null;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++n2;
        }
        i = 0;
        while (i < threadarray.length) {
            threadarray[i] = null;
            ++i;
        }
    }

    public synchronized void killTimer() {
        for (IOutputTrace iot : this.listoutput) {
            iot.killTimer();
        }
    }

    public synchronized void init(InitOutputData iod) {
        for (IOutputTrace iot : this.listoutput) {
            System.out.println("Init " + iot.getName());
            RunnableInit rs = new RunnableInit(iot, iod);
            Display.getDefault().syncExec((Runnable)rs);
            rs.getThrowable();
        }
        Thread.yield();
    }

    public synchronized void clearRelation() {
        this.relation = Collections.emptyList();
    }

    public synchronized void aNewRelation(List<EObject> _relation) {
        this.relation = _relation;
    }

    private static class RunnableInit
    implements Runnable {
        private IOutputTrace iot;
        private InitOutputData iod = null;
        private Throwable t = null;

        private RunnableInit(IOutputTrace iotin, InitOutputData iodin) {
            this.iot = iotin;
            this.iod = iodin;
        }

        @Override
        public void run() {
            try {
                this.iot.initAndOutputFile(this.iod, _solver);
            }
            catch (Throwable e) {
                this.t = e;
                e.printStackTrace();
            }
        }

        public final Throwable getThrowable() {
            return this.t;
        }
    }

    private static class ThreadNewStep
    extends Thread {
        private IOutputTrace iot;
        private LogicalStep aStep;
        private boolean b;
        private ConsoleSimulation cs = null;
        private List<EObject> relation;

        private ThreadNewStep(IOutputTrace iotin, LogicalStep step, ConsoleSimulation csin, boolean bin, List<EObject> relation) {
            super("Thread New Step Output " + iotin.getName());
            this.iot = iotin;
            this.aStep = step;
            this.b = bin;
            this.cs = csin;
            this.relation = relation;
        }

        @Override
        public void run() {
            long time1 = System.currentTimeMillis();
            this.iot.aNewStep_And_Relation(this.aStep, this.b, this.relation);
            long time2 = System.currentTimeMillis();
            if (this.cs != null) {
                this.cs.printSimulationMessageln("Timing Output (" + this.iot.getName() + ") :" + (time2 - time1) + " ms ");
            }
        }
    }

    private static class ThreadStep
    extends Thread {
        private IOutputTrace iot;
        private LogicalStep aStep;
        private boolean b;

        private ThreadStep(IOutputTrace iotin, LogicalStep step, boolean bin) {
            super("Thread Step Output " + iotin.getName());
            this.iot = iotin;
            this.aStep = step;
            this.b = bin;
        }

        @Override
        public void run() {
            this.iot.aStep(this.aStep, this.b);
        }
    }
}

