/*
 * Decompiled with CFR 0.152.
 */
package fr.kairos.timesquare.xccsltolc;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.DiscreteClockType;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.Block;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.BindableEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Binding;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Expression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Inf;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Intersection;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Sup;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Union;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.UpTo;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.Wait;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.impl.WaitImpl;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelExpression.util.KernelExpressionSwitch;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.Coincidence;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.Exclusion;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.NonStrictPrecedence;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.Precedence;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.SubClock;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.KernelRelation.util.KernelRelationSwitch;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.impl.ExpressionImpl;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.util.CCSLModelSwitch;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.util.TimeModelSwitch;
import fr.kairos.timesquare.ccsl.IConstraint;
import fr.kairos.timesquare.ccsl.ISpecification;
import fr.kairos.timesquare.ccsl.adapters.GenericToSimple;
import fr.kairos.timesquare.ccsl.simple.Definition;
import fr.kairos.timesquare.ccsl.simple.Relation;
import org.eclipse.emf.ecore.EObject;

public class XCCSLtoLC
extends CCSLModelSwitch<Object> {
    private InternalTimeModel internalTM = new InternalTimeModel();
    private InternalKernelExpression internalKernelE = new InternalKernelExpression();
    private InternalKerneRelation internalKernelR = new InternalKerneRelation();
    private ISpecification spec;
    private Expression currentExpression;
    private fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Relation currentRelation;

    public XCCSLtoLC(ISpecification spec) {
        this.spec = spec;
    }

    public Boolean caseBlock(Block object) {
        for (Element e : object.getElements()) {
            this.internalTM.doSwitch((EObject)e);
        }
        for (fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Relation r : object.getRelations()) {
            this.caseRelation(r);
        }
        for (Element e : object.getExpressions()) {
            this.caseExpression((Expression)e);
        }
        return Boolean.TRUE;
    }

    public Object caseClockConstraintSystem(ClockConstraintSystem object) {
        return this.doSwitch((EObject)object.getSuperBlock());
    }

    public Boolean defaultCase(EObject object) {
        System.out.println("Ignoring:" + object);
        return Boolean.TRUE;
    }

    private Boolean caseExpression(Expression expression) {
        ExpressionDeclaration decl = expression.getType();
        this.currentExpression = expression;
        Definition d = (Definition)this.internalKernelE.doSwitch((EObject)decl);
        if (d != null) {
            this.spec.add((IConstraint)d);
        }
        return Boolean.TRUE;
    }

    private Boolean caseRelation(fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Relation relation) {
        RelationDeclaration decl = relation.getType();
        this.currentRelation = relation;
        Relation r = (Relation)this.internalKernelR.doSwitch((EObject)decl);
        if (r != null) {
            this.spec.add((IConstraint)r);
        }
        return Boolean.TRUE;
    }

    class InternalKerneRelation
    extends KernelRelationSwitch<Relation> {
        InternalKerneRelation() {
        }

        public Relation caseCoincidence(Coincidence object) {
            return (Relation)super.caseCoincidence(object);
        }

        private String getLeft() {
            return ((Binding)XCCSLtoLC.this.currentRelation.getBindings().get(0)).getBindable().getName();
        }

        private String getRight() {
            return ((Binding)XCCSLtoLC.this.currentRelation.getBindings().get(1)).getBindable().getName();
        }

        public Relation caseNonStrictPrecedence(NonStrictPrecedence object) {
            return new Relation(GenericToSimple.CAUSALITY, this.getLeft(), this.getRight());
        }

        public Relation casePrecedence(Precedence object) {
            return new Relation(GenericToSimple.PRECEDENCE, this.getLeft(), this.getRight());
        }

        public Relation caseSubClock(SubClock object) {
            return new Relation(GenericToSimple.SUBCLOCK, this.getLeft(), this.getRight());
        }

        public Relation caseExclusion(Exclusion object) {
            return new Relation(GenericToSimple.EXCLUSION, this.getLeft(), this.getRight());
        }

        public Relation caseRelationDeclaration(RelationDeclaration object) {
            if (object.getName().equals("Alternates")) {
                return new Relation(GenericToSimple.ALTERNATION, this.getLeft(), this.getRight());
            }
            return null;
        }

        public Relation defaultCase(EObject object) {
            Relation r;
            if (object instanceof RelationDeclaration && (r = this.caseRelationDeclaration((RelationDeclaration)object)) != null) {
                return r;
            }
            System.out.println("Ignoring relation " + object);
            return null;
        }
    }

    class InternalKernelExpression
    extends KernelExpressionSwitch<Definition> {
        InternalKernelExpression() {
        }

        private BindableEntity get(Expression e, String bindingName) {
            for (Binding b : e.getBindings()) {
                if (!b.getAbstract().getName().equals(bindingName)) continue;
                return b.getBindable();
            }
            return null;
        }

        private BindableEntity get(String bindingName) {
            return this.get(XCCSLtoLC.this.currentExpression, bindingName);
        }

        private String[] extractClocks() {
            String[] clocks = new String[XCCSLtoLC.this.currentExpression.getBindings().size()];
            int i = 0;
            for (Binding b : XCCSLtoLC.this.currentExpression.getBindings()) {
                if (b.getAbstract().getType() instanceof DiscreteClockType) {
                    clocks[i] = b.getBindable().getName();
                    ++i;
                    continue;
                }
                System.out.println(b.getAbstract().getType());
            }
            return clocks;
        }

        public Definition caseInf(Inf object) {
            return new Definition(XCCSLtoLC.this.currentExpression.getName(), "Inf", this.extractClocks());
        }

        public Definition caseIntersection(Intersection object) {
            return new Definition(XCCSLtoLC.this.currentExpression.getName(), "Intersection", this.extractClocks());
        }

        public Definition caseSup(Sup object) {
            return new Definition(XCCSLtoLC.this.currentExpression.getName(), "Sup", this.extractClocks());
        }

        public Definition caseUnion(Union object) {
            return new Definition(XCCSLtoLC.this.currentExpression.getName(), "Union", this.extractClocks());
        }

        public Definition caseExpressionDeclaration(ExpressionDeclaration object) {
            if (object.getName().equals("Minus")) {
                return new Definition(XCCSLtoLC.this.currentExpression.getName(), "Minus", this.extractClocks());
            }
            if (object.getName().equals("SampledOn")) {
                return new Definition(XCCSLtoLC.this.currentExpression.getName(), "DelayFor", new String[]{this.get("SampledOnSampledClock").getName(), this.get("SampledOnTrigger").getName()});
            }
            if (object.getName().equals("DelayFor")) {
                String clockToDelay = this.get("DelayForClockToDelay").getName();
                String clockForCounting = this.get("DelayForClockForCounting").getName();
                int value = ((IntegerElement)this.get("DelayForDelay")).getValue();
                if (clockToDelay.equals(clockForCounting)) {
                    return new Definition(XCCSLtoLC.this.currentExpression.getName(), "DelayFor", new String[]{clockToDelay}).set("from", value);
                }
                return new Definition(XCCSLtoLC.this.currentExpression.getName(), "DelayFor", new String[]{clockToDelay, clockForCounting}).set("from", value);
            }
            if (object.getName().equals("Periodic")) {
                int period = ((IntegerElement)this.get("PeriodicPeriod")).getValue();
                int from = ((IntegerElement)this.get("PeriodicOffset")).getValue();
                return new Definition(XCCSLtoLC.this.currentExpression.getName(), "Periodic", new String[]{this.get("PeriodicBaseClock").getName()}).set("period", period).set("from", from);
            }
            return null;
        }

        public Definition caseUpTo(UpTo object) {
            ExpressionImpl e;
            ExpressionDeclaration decl;
            String toFollow = this.get("ClockToFollow").getName();
            BindableEntity entity = this.get("KillerCLock");
            if (entity instanceof ExpressionImpl && (decl = (e = (ExpressionImpl)entity).getType()) instanceof WaitImpl) {
                int upto = ((IntegerElement)this.get((Expression)e, "WaitingValue")).getValue();
                return new Definition(XCCSLtoLC.this.currentExpression.getName(), "Periodic", new String[]{toFollow}).set("upto", upto);
            }
            return (Definition)super.caseUpTo(object);
        }

        public Definition caseWait(Wait object) {
            int value = ((IntegerElement)this.get("WaitingValue")).getValue();
            return new Definition(XCCSLtoLC.this.currentExpression.getName(), "Periodic", new String[]{this.get("WaitingClock").getName()}).set("from", value).set("upto", value);
        }

        public Definition defaultCase(EObject object) {
            Definition d;
            if (object instanceof ExpressionDeclaration && (d = this.caseExpressionDeclaration((ExpressionDeclaration)object)) != null) {
                return d;
            }
            System.err.println("Ignoring " + object);
            return null;
        }
    }

    class InternalTimeModel
    extends TimeModelSwitch<Boolean> {
        InternalTimeModel() {
        }

        public Boolean caseClock(Clock object) {
            XCCSLtoLC.this.spec.addClock(object.getName());
            return Boolean.TRUE;
        }

        public Boolean defaultCase(EObject object) {
            System.out.println("Ignoring:" + object);
            return Boolean.TRUE;
        }
    }
}

