/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.CompressingDataOutputStream;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.PatternNodeVisitor;

public class AnnotationPatternList
extends PatternNode {
    private AnnotationTypePattern[] typePatterns;
    int ellipsisCount = 0;
    public static final AnnotationPatternList EMPTY = new AnnotationPatternList(new AnnotationTypePattern[0]);
    public static final AnnotationPatternList ANY = new AnnotationPatternList(new AnnotationTypePattern[]{AnnotationTypePattern.ELLIPSIS});

    public AnnotationPatternList() {
        this.typePatterns = new AnnotationTypePattern[0];
        this.ellipsisCount = 0;
    }

    public AnnotationPatternList(AnnotationTypePattern[] arguments) {
        this.typePatterns = arguments;
        int i = 0;
        while (i < arguments.length) {
            if (arguments[i] == AnnotationTypePattern.ELLIPSIS) {
                ++this.ellipsisCount;
            }
            ++i;
        }
    }

    public AnnotationPatternList(List<AnnotationTypePattern> l) {
        this(l.toArray(new AnnotationTypePattern[l.size()]));
    }

    protected AnnotationTypePattern[] getAnnotationPatterns() {
        return this.typePatterns;
    }

    public AnnotationPatternList parameterizeWith(Map<String, UnresolvedType> typeVariableMap, World w) {
        AnnotationTypePattern[] parameterizedPatterns = new AnnotationTypePattern[this.typePatterns.length];
        int i = 0;
        while (i < parameterizedPatterns.length) {
            parameterizedPatterns[i] = this.typePatterns[i].parameterizeWith(typeVariableMap, w);
            ++i;
        }
        AnnotationPatternList ret = new AnnotationPatternList(parameterizedPatterns);
        ret.copyLocationFrom(this);
        return ret;
    }

    public void resolve(World inWorld) {
        int i = 0;
        while (i < this.typePatterns.length) {
            this.typePatterns[i].resolve(inWorld);
            ++i;
        }
    }

    public FuzzyBoolean matches(ResolvedType[] someArgs) {
        int numArgsMatchedByEllipsis = someArgs.length + this.ellipsisCount - this.typePatterns.length;
        if (numArgsMatchedByEllipsis < 0) {
            return FuzzyBoolean.NO;
        }
        if (numArgsMatchedByEllipsis > 0 && this.ellipsisCount == 0) {
            return FuzzyBoolean.NO;
        }
        FuzzyBoolean ret = FuzzyBoolean.YES;
        int argsIndex = 0;
        int i = 0;
        while (i < this.typePatterns.length) {
            if (this.typePatterns[i] == AnnotationTypePattern.ELLIPSIS) {
                argsIndex += numArgsMatchedByEllipsis;
            } else if (this.typePatterns[i] == AnnotationTypePattern.ANY) {
                ++argsIndex;
            } else {
                if (someArgs[argsIndex].isPrimitiveType()) {
                    return FuzzyBoolean.NO;
                }
                ExactAnnotationTypePattern ap = (ExactAnnotationTypePattern)this.typePatterns[i];
                FuzzyBoolean matches = ap.matchesRuntimeType(someArgs[argsIndex]);
                if (matches == FuzzyBoolean.NO) {
                    return FuzzyBoolean.MAYBE;
                }
                ++argsIndex;
                ret = ret.and(matches);
            }
            ++i;
        }
        return ret;
    }

    public int size() {
        return this.typePatterns.length;
    }

    public AnnotationTypePattern get(int index) {
        return this.typePatterns[index];
    }

    public AnnotationPatternList resolveBindings(IScope scope, Bindings bindings, boolean allowBinding) {
        int i = 0;
        while (i < this.typePatterns.length) {
            AnnotationTypePattern p = this.typePatterns[i];
            if (p != null) {
                this.typePatterns[i] = this.typePatterns[i].resolveBindings(scope, bindings, allowBinding);
            }
            ++i;
        }
        return this;
    }

    public AnnotationPatternList resolveReferences(IntMap bindings) {
        int len = this.typePatterns.length;
        AnnotationTypePattern[] ret = new AnnotationTypePattern[len];
        int i = 0;
        while (i < len) {
            ret[i] = this.typePatterns[i].remapAdviceFormals(bindings);
            ++i;
        }
        return new AnnotationPatternList(ret);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int i = 0;
        int len = this.typePatterns.length;
        while (i < len) {
            AnnotationTypePattern type = this.typePatterns[i];
            if (i > 0) {
                buf.append(", ");
            }
            if (type == AnnotationTypePattern.ELLIPSIS) {
                buf.append("..");
            } else {
                String annPatt = type.toString();
                buf.append(annPatt.startsWith("@") ? annPatt.substring(1) : annPatt);
            }
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AnnotationPatternList)) {
            return false;
        }
        AnnotationPatternList o = (AnnotationPatternList)other;
        int len = o.typePatterns.length;
        if (len != this.typePatterns.length) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (!this.typePatterns[i].equals(o.typePatterns[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 41;
        int i = 0;
        int len = this.typePatterns.length;
        while (i < len) {
            result = 37 * result + this.typePatterns[i].hashCode();
            ++i;
        }
        return result;
    }

    public static AnnotationPatternList read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        int len = s.readShort();
        AnnotationTypePattern[] arguments = new AnnotationTypePattern[len];
        int i = 0;
        while (i < len) {
            arguments[i] = AnnotationTypePattern.read(s, context);
            ++i;
        }
        AnnotationPatternList ret = new AnnotationPatternList(arguments);
        ret.readLocation(context, s);
        return ret;
    }

    @Override
    public void write(CompressingDataOutputStream s) throws IOException {
        s.writeShort(this.typePatterns.length);
        int i = 0;
        while (i < this.typePatterns.length) {
            this.typePatterns[i].write(s);
            ++i;
        }
        this.writeLocation(s);
    }

    @Override
    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public Object traverse(PatternNodeVisitor visitor, Object data) {
        Object ret = this.accept(visitor, data);
        int i = 0;
        while (i < this.typePatterns.length) {
            this.typePatterns[i].traverse(visitor, ret);
            ++i;
        }
        return ret;
    }
}

