/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.ui.filters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.contribution.xref.internal.ui.text.XRefMessages;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class CustomFilterDialog {
    private static List populatingList;
    private static List checkedList;
    private static List defaultCheckedList;
    private static String dialogTitle;
    private static String dialogMessage;
    private static Shell parentShell;

    public static List showDialog(Shell shell, List items, List checkedItems, List defaultItems, String dlogTitle, String dlogMessage) {
        if (!(CustomFilterDialog.isListOfStrings(items) && CustomFilterDialog.isListOfStrings(checkedItems) && CustomFilterDialog.isListOfStrings(defaultItems) && checkedItems.size() <= items.size() && defaultItems.size() <= items.size())) {
            return new ArrayList();
        }
        parentShell = shell;
        populatingList = items;
        checkedList = checkedItems;
        defaultCheckedList = defaultItems;
        dialogTitle = dlogTitle;
        dialogMessage = dlogMessage;
        FilterDialog dialog = new FilterDialog(parentShell, populatingList, checkedList, defaultCheckedList, dialogTitle, dialogMessage);
        if (dialog.open() == 0) {
            checkedItems = dialog.getCheckedList();
        }
        return checkedItems;
    }

    private static boolean isListOfStrings(List listToCheck) {
        Iterator iter = listToCheck.iterator();
        while (iter.hasNext()) {
            Object itemToCheck = iter.next();
            if (itemToCheck instanceof String) continue;
            return false;
        }
        return true;
    }

    static class FilterDialog
    extends SelectionDialog {
        private CheckboxTableViewer fCheckBoxList;
        private static List populatingList;
        private static List checkedList;
        private static List defaultCheckedList;
        private static String dialogTitle;
        private static String dialogMessage;

        public FilterDialog(Shell shell, List items, List checkedItems, List defaultItems, String dlogTitle, String dlogMessage) {
            super(shell);
            populatingList = items;
            checkedList = checkedItems;
            defaultCheckedList = defaultItems;
            dialogTitle = dlogTitle;
            dialogMessage = dlogMessage;
            parentShell = shell;
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        protected void configureShell(Shell shell) {
            this.setTitle(dialogTitle);
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.jdt.ui.open_custom_filters_dialog_context");
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setFont(parent.getFont());
            Composite group = composite;
            if (populatingList.size() > 0) {
                this.createCheckBoxList(group);
            }
            FilterDialog.applyDialogFont((Control)parent);
            return parent;
        }

        private void createCheckBoxList(Composite parent) {
            Label info = new Label(parent, 16384);
            info.setText(dialogMessage);
            this.fCheckBoxList = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
            GridData data = new GridData(1808);
            int rowsToShow = Math.max(Math.min(populatingList.size(), 12), 6);
            data.heightHint = this.fCheckBoxList.getTable().getItemHeight() * rowsToShow;
            this.fCheckBoxList.getTable().setLayoutData((Object)data);
            this.fCheckBoxList.setLabelProvider((IBaseLabelProvider)this.createLabelPrivder());
            this.fCheckBoxList.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fCheckBoxList.setInput((Object)populatingList);
            this.setInitialSelections(checkedList.toArray());
            List initialSelection = this.getInitialElementSelections();
            if (initialSelection != null && !initialSelection.isEmpty()) {
                this.checkInitialSelections();
            }
            this.addSelectionButtons(parent);
        }

        private void addSelectionButtons(Composite composite) {
            Composite buttonComposite = new Composite(composite, 131072);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            buttonComposite.setLayout((Layout)layout);
            GridData data = new GridData(640);
            data.grabExcessHorizontalSpace = true;
            composite.setData((Object)data);
            String label = XRefMessages.CustomFilterDialog_SelectAllButton_label;
            Button selectButton = this.createButton(buttonComposite, 18, label, false);
            SWTUtil.setButtonDimensionHint((Button)selectButton);
            SelectionAdapter listener = new SelectionAdapter(this){
                final /* synthetic */ FilterDialog this$1;
                {
                    this.this$1 = filterDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    FilterDialog.access$0(this.this$1).setAllChecked(true);
                }
            };
            selectButton.addSelectionListener((SelectionListener)listener);
            label = XRefMessages.CustomFilterDialog_DeselectAllButton_label;
            Button deselectButton = this.createButton(buttonComposite, 19, label, false);
            SWTUtil.setButtonDimensionHint((Button)deselectButton);
            listener = new SelectionAdapter(this){
                final /* synthetic */ FilterDialog this$1;
                {
                    this.this$1 = filterDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    FilterDialog.access$0(this.this$1).setAllChecked(false);
                }
            };
            deselectButton.addSelectionListener((SelectionListener)listener);
            label = XRefMessages.CustomFilterDialog_RestoreDefaultsButton_label;
            Button restoreDefaultsButton = this.createButton(buttonComposite, 19, label, false);
            SWTUtil.setButtonDimensionHint((Button)restoreDefaultsButton);
            listener = new SelectionAdapter(this){
                final /* synthetic */ FilterDialog this$1;
                {
                    this.this$1 = filterDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    FilterDialog.access$0(this.this$1).setAllChecked(false);
                    Iterator<E> defaultItemsInCheckboxDialog = FilterDialog.access$1().iterator();
                    while (defaultItemsInCheckboxDialog.hasNext()) {
                        String nextItemToCheck = (String)defaultItemsInCheckboxDialog.next();
                        if (!FilterDialog.access$2().contains(nextItemToCheck)) continue;
                        FilterDialog.access$0(this.this$1).setChecked((Object)nextItemToCheck, true);
                    }
                }
            };
            restoreDefaultsButton.addSelectionListener((SelectionListener)listener);
        }

        private void checkInitialSelections() {
            Iterator itemsInCheckboxDialog = checkedList.iterator();
            while (itemsInCheckboxDialog.hasNext()) {
                String nextItemToCheck = (String)itemsInCheckboxDialog.next();
                if (!populatingList.contains(nextItemToCheck)) continue;
                this.fCheckBoxList.setChecked((Object)nextItemToCheck, true);
            }
        }

        protected void okPressed() {
            checkedList.clear();
            if (this.fCheckBoxList != null) {
                Object[] newlyChecked = this.fCheckBoxList.getCheckedElements();
                int i = 0;
                while (i < newlyChecked.length) {
                    checkedList.add(newlyChecked[i]);
                    ++i;
                }
            }
            super.okPressed();
        }

        public List getCheckedList() {
            return checkedList;
        }

        private ILabelProvider createLabelPrivder() {
            return new LabelProvider(this){
                final /* synthetic */ FilterDialog this$1;
                {
                    this.this$1 = filterDialog;
                }

                public Image getImage(Object element) {
                    return null;
                }

                public String getText(Object element) {
                    if (element instanceof String) {
                        return (String)element;
                    }
                    return null;
                }
            };
        }

        static /* synthetic */ CheckboxTableViewer access$0(FilterDialog filterDialog) {
            return filterDialog.fCheckBoxList;
        }

        static /* synthetic */ List access$1() {
            return defaultCheckedList;
        }

        static /* synthetic */ List access$2() {
            return populatingList;
        }
    }
}

