/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.parser.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEBaseVisitor;
import org.eclipse.emf.ecoretools.ale.core.parser.ALEParser;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ModelBuilder;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.implementation.Assignment;
import org.eclipse.emf.ecoretools.ale.implementation.Attribute;
import org.eclipse.emf.ecoretools.ale.implementation.Block;
import org.eclipse.emf.ecoretools.ale.implementation.ConditionalBlock;
import org.eclipse.emf.ecoretools.ale.implementation.ExpressionStatement;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.ForEach;
import org.eclipse.emf.ecoretools.ale.implementation.If;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationFactory;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.emf.ecoretools.ale.implementation.Statement;
import org.eclipse.emf.ecoretools.ale.implementation.VariableDeclaration;
import org.eclipse.emf.ecoretools.ale.implementation.While;

public class AstVisitors {
    public static boolean isQualified(String name) {
        return name.contains(".");
    }

    public static String aliasToRealName(String qname, Map<String, String> importedBehaviors) {
        if (AstVisitors.isQualified(qname)) {
            CharSequence[] segments = qname.split("\\.");
            String importSeg = importedBehaviors.get(segments[0]);
            if (importSeg != null) {
                segments[0] = importSeg;
            }
            return String.join((CharSequence)".", segments);
        }
        return qname;
    }

    public static ParseResult<ModelUnit> visit(ALEParser.RRootContext rootCtx) {
        ParseResult<ModelUnit> result = new ParseResult<ModelUnit>();
        result.setDiagnostic((Diagnostic)new BasicDiagnostic());
        ModelUnit root = (ModelUnit)new ModelUnitVisitor(result).visit((ParseTree)rootCtx);
        result.setRoot(root);
        return result;
    }

    public static List<EClass> preVisit(ALEParser.RRootContext ctx) {
        return ctx.rClass().stream().map(c -> c.rNewClass()).filter(c -> c != null).map(cls -> {
            EClass eClsClass = EcorePackage.eINSTANCE.getEClass();
            EClass res = (EClass)EcoreUtil.create((EClass)eClsClass);
            res.setName(cls.name.getText());
            return res;
        }).collect(Collectors.toList());
    }

    static class AttributeVisitor
    extends ALEBaseVisitor<Attribute> {
        ParseResult<ModelUnit> parseRes;
        EClass fragment;

        public AttributeVisitor(ParseResult<ModelUnit> parseRes, EClass fragment) {
            this.parseRes = parseRes;
            this.fragment = fragment;
        }

        @Override
        public Attribute visitRAttribute(ALEParser.RAttributeContext ctx) {
            ALEParser.RExpressionContext initialValue = ctx.rExpression();
            ALEParser.RTypeContext type = ctx.type;
            String name = ctx.Ident().getText();
            boolean isUnique = false;
            boolean isContainment = false;
            if (ctx.modifier != null) {
                if (ctx.modifier.getText().equals("contains")) {
                    isContainment = true;
                    isUnique = true;
                } else if (ctx.modifier.getText().equals("unique")) {
                    isUnique = true;
                }
            }
            int lowerBound = 0;
            int upperBound = 1;
            if (ctx.bounds != null) {
                lowerBound = Integer.decode(ctx.bounds.Integer().get(0).getText());
                if (ctx.bounds.Integer().size() > 1) {
                    upperBound = Integer.decode(ctx.bounds.Integer().get(1).getText());
                } else if (ctx.bounds.MultOp() != null && ctx.bounds.MultOp().getText().equals("*")) {
                    upperBound = -1;
                }
            }
            String opposite = null;
            if (ctx.opposite != null) {
                opposite = ctx.opposite.Ident().getText();
            }
            Attribute res = ModelBuilder.singleton.buildAttribute(this.fragment, name, initialValue, type, lowerBound, upperBound, isContainment, isUnique, opposite, this.parseRes);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }
    }

    public static class BlockVisitor
    extends ALEBaseVisitor<Block> {
        ParseResult<ModelUnit> parseRes;

        public BlockVisitor(ParseResult<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        @Override
        public Block visitRBlock(ALEParser.RBlockContext ctx) {
            StatementVisitor subVisitor = new StatementVisitor(this.parseRes);
            ctx.rStatement();
            List<Statement> body = ctx.rStatement().stream().map(s -> (Statement)subVisitor.visit((ParseTree)s)).filter(elem -> elem != null).collect(Collectors.toList());
            Block res = ModelBuilder.singleton.buildBlock(body);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }
    }

    static class ModelUnitVisitor
    extends ALEBaseVisitor<ModelUnit> {
        ParseResult<ModelUnit> parseRes;

        public ModelUnitVisitor(ParseResult<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        @Override
        public ModelUnit visitRRoot(ALEParser.RRootContext ctx) {
            ImplementationFactory factory = (ImplementationFactory)ImplementationPackage.eINSTANCE.getEFactoryInstance();
            ModelUnit res = factory.createModelUnit();
            res.setName(ctx.rQualified().getText());
            HashMap<String, String> importedBehaviors = new HashMap<String, String>();
            ctx.rImport().stream().forEach(imp -> {
                String string = importedBehaviors.put(imp.Ident().getText(), imp.rQualified().getText());
            });
            OpenClassVisitor subVisitor1 = new OpenClassVisitor(this.parseRes, importedBehaviors);
            res.getClassExtensions().addAll((Collection)ctx.rClass().stream().map(c -> c.rOpenClass()).filter(c -> c != null).map(cls -> (ExtendedClass)subVisitor1.visit((ParseTree)cls)).collect(Collectors.toList()));
            NewClassVisitor subVisitor2 = new NewClassVisitor(this.parseRes);
            res.getClassDefinitions().addAll((Collection)ctx.rClass().stream().map(c -> c.rNewClass()).filter(c -> c != null).map(cls -> (RuntimeClass)subVisitor2.visit((ParseTree)cls)).collect(Collectors.toList()));
            ServiceVisitor serviceVisitor = new ServiceVisitor();
            res.getServices().addAll((Collection)ctx.rService().stream().map(srv -> (String)serviceVisitor.visit((ParseTree)srv)).collect(Collectors.toList()));
            if (this.parseRes.getRoot() != null) {
                this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
                this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            }
            return res;
        }
    }

    static class NewClassVisitor
    extends ALEBaseVisitor<RuntimeClass> {
        ParseResult<ModelUnit> parseRes;

        public NewClassVisitor(ParseResult<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        @Override
        public RuntimeClass visitRNewClass(ALEParser.RNewClassContext ctx) {
            String name = ctx.name.getText();
            EClass fragment = ModelBuilder.singleton.buildEClass(name);
            AttributeVisitor subVisitor1 = new AttributeVisitor(this.parseRes, fragment);
            List<Attribute> attributes = ctx.rAttribute().stream().map(attr -> subVisitor1.visitRAttribute((ALEParser.RAttributeContext)((Object)attr))).collect(Collectors.toList());
            OpVisitor subVisitor2 = new OpVisitor(this.parseRes, fragment);
            List<Method> operations = ctx.rOperation().stream().map(op -> (Method)subVisitor2.visit((ParseTree)op)).filter(op -> op instanceof Method).map(op -> op).collect(Collectors.toList());
            RuntimeClass res = ModelBuilder.singleton.buildRuntimeClass(name, attributes, operations);
            res.setFragment(fragment);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }
    }

    static class OpVisitor
    extends ALEBaseVisitor<Method> {
        ParseResult<ModelUnit> parseRes;
        EClass fragment;

        public OpVisitor(ParseResult<ModelUnit> parseRes, EClass fragment) {
            this.parseRes = parseRes;
            this.fragment = fragment;
        }

        @Override
        public Method visitROperation(ALEParser.ROperationContext ctx) {
            String keyword = ctx.children.stream().filter(c -> c instanceof TerminalNode).findFirst().get().getText();
            ALEParser.RTypeContext returnType = ctx.type;
            String operationName = ctx.name.getText();
            ArrayList<ModelBuilder.Parameter> parameters = new ArrayList();
            if (ctx.rParameters() != null) {
                parameters = (List)new ParamVisitor(this.parseRes).visit((ParseTree)ctx.rParameters());
            }
            Block body = (Block)new BlockVisitor(this.parseRes).visit((ParseTree)ctx.rBlock());
            String className = ctx.parent.getChild(1).getText();
            RuleContext parent = ctx.parent;
            if (parent instanceof ALEParser.RNewClassContext) {
                className = ((ALEParser.RNewClassContext)parent).name.getText();
            } else if (parent instanceof ALEParser.ROpenClassContext) {
                className = ((ALEParser.ROpenClassContext)parent).name.getText();
            }
            List<String> tags = ctx.rTag().stream().map(t -> t.Ident().getText()).collect(Collectors.toList());
            Method res = null;
            res = keyword.equals("def") ? ModelBuilder.singleton.buildMethod(this.fragment, operationName, parameters, returnType, body, tags) : (keyword.equals("override") ? ModelBuilder.singleton.buildImplementation(className, operationName, parameters, returnType, body, tags) : ModelBuilder.singleton.buildMethod(this.fragment, operationName, parameters, returnType, body, tags));
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }
    }

    static class OpenClassVisitor
    extends ALEBaseVisitor<ExtendedClass> {
        ParseResult<ModelUnit> parseRes;
        Map<String, String> importedBehaviors;

        public OpenClassVisitor(ParseResult<ModelUnit> parseRes, Map<String, String> importedBehaviors) {
            this.parseRes = parseRes;
            this.importedBehaviors = importedBehaviors;
        }

        @Override
        public ExtendedClass visitROpenClass(ALEParser.ROpenClassContext ctx) {
            String name = ctx.name.getText();
            EClass fragment = null;
            if (!ctx.rAttribute().isEmpty() || !ctx.rOperation().isEmpty()) {
                fragment = ModelBuilder.singleton.buildEClass(name);
            }
            AttributeVisitor subVisitor1 = new AttributeVisitor(this.parseRes, fragment);
            List<Attribute> attributes = ctx.rAttribute().stream().map(attr -> subVisitor1.visitRAttribute((ALEParser.RAttributeContext)((Object)attr))).collect(Collectors.toList());
            OpVisitor subVisitor2 = new OpVisitor(this.parseRes, fragment);
            List<Method> operations = ctx.rOperation().stream().map(op -> (Method)subVisitor2.visit((ParseTree)op)).filter(elem -> elem != null).collect(Collectors.toList());
            List<String> extended = ctx.rQualified().stream().skip(1L).map(q -> AstVisitors.aliasToRealName(q.getText(), this.importedBehaviors)).collect(Collectors.toList());
            ExtendedClass res = ModelBuilder.singleton.buildExtendedClass(name, attributes, operations, extended);
            res.setFragment(fragment);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }
    }

    static class ParamVisitor
    extends ALEBaseVisitor<List<ModelBuilder.Parameter>> {
        ParseResult<ModelUnit> parseRes;

        public ParamVisitor(ParseResult<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        @Override
        public List<ModelBuilder.Parameter> visitRParameters(ALEParser.RParametersContext ctx) {
            VarVisitor subVisitor = new VarVisitor(this.parseRes);
            List<ModelBuilder.Parameter> res = ctx.rVariable().stream().map(var -> (ModelBuilder.Parameter)subVisitor.visit((ParseTree)var)).collect(Collectors.toList());
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }
    }

    static class ServiceVisitor
    extends ALEBaseVisitor<String> {
        ServiceVisitor() {
        }

        @Override
        public String visitRService(ALEParser.RServiceContext ctx) {
            String rawText = ctx.getText();
            rawText = rawText.replaceFirst("use", "");
            rawText = rawText.replaceFirst(";", "");
            rawText.replaceAll("\\t\\r\\n", "");
            return rawText;
        }
    }

    static class StatementVisitor
    extends ALEBaseVisitor<Statement> {
        ParseResult<ModelUnit> parseRes;

        public StatementVisitor(ParseResult<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        public Statement visitErrorNode(ErrorNode node) {
            return null;
        }

        @Override
        public Statement visitRVarDecl(ALEParser.RVarDeclContext ctx) {
            ALEParser.RTypeContext typeName = ctx.type;
            String name = ctx.Ident().getText();
            ALEParser.RExpressionContext initialValue = ctx.rExpression();
            VariableDeclaration res = ModelBuilder.singleton.buildVariableDecl(name, initialValue, typeName, this.parseRes);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }

        @Override
        public Statement visitRAssign(ALEParser.RAssignContext ctx) {
            ALEParser.ExpressionContext left = ctx.expression();
            ALEParser.RExpressionContext value = ctx.rExpression();
            Assignment res = null;
            if (left instanceof ALEParser.VarRefContext) {
                ALEParser.VarRefContext varRef = (ALEParser.VarRefContext)left;
                res = ModelBuilder.singleton.buildVariableAssignement(varRef.Ident().getText(), value, this.parseRes);
            } else if (left instanceof ALEParser.NavContext) {
                ALEParser.NavContext navCtx = (ALEParser.NavContext)left;
                ALEParser.NavigationSegmentContext navSegment = navCtx.navigationSegment();
                if (navSegment instanceof ALEParser.FeatureContext) {
                    ALEParser.FeatureContext featCtx = (ALEParser.FeatureContext)navSegment;
                    String feature = featCtx.Ident().getText();
                    ALEParser.ExpressionContext target = navCtx.expression();
                    res = ModelBuilder.singleton.buildFeatureAssign(target, feature, value, this.parseRes);
                }
            } else {
                res = ModelBuilder.singleton.buildVariableAssignement(left.getText(), value, this.parseRes);
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }

        @Override
        public Statement visitRInsert(ALEParser.RInsertContext ctx) {
            ALEParser.ExpressionContext left = ctx.expression();
            ALEParser.RExpressionContext value = ctx.rExpression();
            Assignment res = null;
            if (left instanceof ALEParser.NavContext) {
                ALEParser.NavContext navCtx = (ALEParser.NavContext)left;
                ALEParser.NavigationSegmentContext navSegment = navCtx.navigationSegment();
                if (navSegment instanceof ALEParser.FeatureContext) {
                    ALEParser.FeatureContext featCtx = (ALEParser.FeatureContext)navSegment;
                    String feature = featCtx.Ident().getText();
                    ALEParser.ExpressionContext target = navCtx.expression();
                    res = ModelBuilder.singleton.buildFeatureInsert(target, feature, value.expression(), this.parseRes);
                }
            } else if (left instanceof ALEParser.VarRefContext) {
                ALEParser.VarRefContext varRef = (ALEParser.VarRefContext)left;
                res = ModelBuilder.singleton.buildVariableInsert(varRef.Ident().getText(), value, this.parseRes);
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }

        @Override
        public Statement visitRRemove(ALEParser.RRemoveContext ctx) {
            ALEParser.ExpressionContext left = ctx.expression();
            ALEParser.RExpressionContext value = ctx.rExpression();
            Assignment res = null;
            if (left instanceof ALEParser.NavContext) {
                ALEParser.NavContext navCtx = (ALEParser.NavContext)left;
                ALEParser.NavigationSegmentContext navSegment = navCtx.navigationSegment();
                if (navSegment instanceof ALEParser.FeatureContext) {
                    ALEParser.FeatureContext featCtx = (ALEParser.FeatureContext)navSegment;
                    String feature = featCtx.Ident().getText();
                    ALEParser.ExpressionContext target = navCtx.expression();
                    res = ModelBuilder.singleton.buildFeatureRemove(target, feature, value.expression(), this.parseRes);
                }
            } else if (left instanceof ALEParser.VarRefContext) {
                ALEParser.VarRefContext varRef = (ALEParser.VarRefContext)left;
                res = ModelBuilder.singleton.buildVariableRemove(varRef.Ident().getText(), value, this.parseRes);
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }

        @Override
        public Statement visitRIf(ALEParser.RIfContext ctx) {
            ALEParser.RExpressionContext cond = ctx.rExpression();
            Block then = (Block)new BlockVisitor(this.parseRes).visit((ParseTree)ctx.rBlock().get(0));
            ConditionalBlock cBlock = ModelBuilder.singleton.buildConditionalBlock(cond, then, this.parseRes);
            If res = null;
            if (ctx.nestedIf != null) {
                res = (If)this.visitRIf(ctx.nestedIf);
                res.getBlocks().add(0, (Object)cBlock);
            } else {
                Block elseB = null;
                if (ctx.rBlock().size() > 1) {
                    elseB = (Block)new BlockVisitor(this.parseRes).visit((ParseTree)ctx.rBlock().get(1));
                }
                res = ModelBuilder.singleton.buildIf(Arrays.asList(cBlock), elseB, this.parseRes);
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }

        @Override
        public Statement visitRForEach(ALEParser.RForEachContext ctx) {
            ForEach res = null;
            Block body = (Block)new BlockVisitor(this.parseRes).visit((ParseTree)ctx.rBlock());
            ALEParser.RExpressionContext collectionExp = ctx.rCollection().rExpression();
            if (collectionExp == null) {
                String left = ctx.rCollection().Integer().get(0).getText();
                String right = ctx.rCollection().Integer().get(1).getText();
                SequenceInExtensionLiteral intSeq = ModelBuilder.singleton.buildIntSequence(left, right);
                res = ModelBuilder.singleton.buildForEach(ctx.Ident().getText(), intSeq, body);
            } else {
                res = ModelBuilder.singleton.buildForEach(ctx.Ident().getText(), collectionExp, body, this.parseRes);
            }
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }

        @Override
        public Statement visitRWhile(ALEParser.RWhileContext ctx) {
            Block body = (Block)new BlockVisitor(this.parseRes).visit((ParseTree)ctx.rBlock());
            While res = ModelBuilder.singleton.buildWhile(ctx.rExpression(), body, this.parseRes);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }

        @Override
        public Statement visitRExpressionStmt(ALEParser.RExpressionStmtContext ctx) {
            ExpressionStatement res = ModelBuilder.singleton.buildExpressionStatement(ctx.rExpression(), this.parseRes);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }
    }

    static class VarVisitor
    extends ALEBaseVisitor<ModelBuilder.Parameter> {
        ParseResult<ModelUnit> parseRes;

        public VarVisitor(ParseResult<ModelUnit> parseRes) {
            this.parseRes = parseRes;
        }

        @Override
        public ModelBuilder.Parameter visitRVariable(ALEParser.RVariableContext ctx) {
            ALEParser.RTypeContext type = ctx.type;
            String name = ctx.Ident().getText();
            ModelBuilder.Parameter res = ModelBuilder.singleton.buildParameter(type, name);
            this.parseRes.getStartPositions().put(res, ctx.start.getStartIndex());
            this.parseRes.getEndPositions().put(res, ctx.stop.getStopIndex());
            return res;
        }
    }
}

