/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecoretools.ale.ALEInterpreter;
import org.eclipse.emf.ecoretools.ale.core.parser.Dsl;
import org.eclipse.emf.ecoretools.ale.ide.WorkbenchDsl;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterWithDiagnostic;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class RunModelAction {
    public static void launch(Shell shell, IResource dslFile) {
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(shell, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle("Resource Selection");
        dialog.open();
        Object[] selected = dialog.getResult();
        if (selected != null && selected.length == 1 && selected[0] instanceof IResource) {
            RunModelAction.launch(dslFile, (IResource)selected[0]);
        }
    }

    public static void launch(final IResource dslFile, IResource modelFile) {
        String dslProject = dslFile.getProject().getName();
        final String modelLocation = modelFile.getLocationURI().toString();
        String modelProject = modelFile.getProject().getName();
        HashSet<String> projects = new HashSet<String>();
        HashSet plugins = new HashSet();
        projects.add(dslProject);
        projects.add(modelProject);
        final ALEInterpreter interpreter = new ALEInterpreter();
        interpreter.javaExtensions.updateScope(plugins, projects);
        interpreter.javaExtensions.reloadIfNeeded();
        Job evalJob = new Job("AQL Eval"){

            protected IStatus run(IProgressMonitor monitor) {
                MessageConsole console = RunModelAction.findConsole("ALE Console");
                PrintStream oldOut = System.out;
                System.setOut(new PrintStream((OutputStream)console.newMessageStream()));
                System.out.println("\nRun " + dslFile.getName());
                System.out.println("------------");
                Thread execThread = new Thread("Aql eval thread"){

                    @Override
                    public void run() {
                        try {
                            IInterpreterWithDiagnostic.IEvaluationResult result = interpreter.eval(modelLocation, new ArrayList(), (Dsl)new WorkbenchDsl(dslFile.getLocationURI().getPath().toString()));
                            interpreter.getLogger().diagnosticForHuman();
                            if (result.getDiagnostic().getMessage() != null) {
                                System.out.println(result.getDiagnostic().getMessage());
                            }
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        this.stop();
                    }
                };
                execThread.start();
                while (execThread.isAlive()) {
                    if (monitor.isCanceled()) {
                        execThread.stop();
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (execThread.isAlive()) {
                    execThread.stop();
                }
                System.setOut(oldOut);
                return Status.OK_STATUS;
            }
        };
        evalJob.schedule();
    }

    private static MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }
}

