/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.registration.builder;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecoretools.registration.EcoreRegisteringHelper;
import org.eclipse.emf.ecoretools.registration.Messages;
import org.eclipse.emf.ecoretools.registration.exceptions.NotValidEPackageURIException;
import org.eclipse.emf.ecoretools.registration.view.RegisteredPackageView;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class EPackageAutoRegistrationBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.emf.ecoretools.registration.EPackageAutoRegistrationBuilder";
    private static final String MARKER_TYPE = "org.eclipse.emf.ecoretools.registration.ecoreAutoRegisterProblem";

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        this.getProject().deleteMarkers(MARKER_TYPE, true, 2);
    }

    void registerEcoreEPackages(IResource resource) {
        if (resource instanceof IFile && resource.getName().endsWith(".ecore")) {
            IFile ecoreFile = (IFile)resource;
            this.deleteMarkers(ecoreFile);
            try {
                EcoreRegisteringHelper.unregisterPackages(ecoreFile);
            }
            catch (NotValidEPackageURIException notValidEPackageURIException) {
                // empty catch block
            }
            try {
                EcoreRegisteringHelper.registerPackages(ecoreFile);
            }
            catch (NotValidEPackageURIException e) {
                this.addMarker(ecoreFile, NLS.bind((String)Messages.EcoreRegisteringBuilder_CanNotBeRegistered, (Object)ecoreFile.getName(), (Object)e.getEPackage().getName()), -1, 1);
            }
            if (Display.getDefault() != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RegisteredPackageView.refreshViewIfActive();
                    }
                });
            }
        }
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new EcoreAutoRegisterResourceVisitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new EPackageAutoRegistrationDeltaVisitor());
    }

    class EPackageAutoRegistrationDeltaVisitor
    implements IResourceDeltaVisitor {
        EPackageAutoRegistrationDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    EPackageAutoRegistrationBuilder.this.registerEcoreEPackages(resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    EPackageAutoRegistrationBuilder.this.registerEcoreEPackages(resource);
                }
            }
            return true;
        }
    }

    class EcoreAutoRegisterResourceVisitor
    implements IResourceVisitor {
        EcoreAutoRegisterResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            EPackageAutoRegistrationBuilder.this.registerEcoreEPackages(resource);
            return true;
        }
    }
}

