/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core;

import java.util.Dictionary;
import org.eclipse.epp.internal.mpc.core.util.ServiceUtil;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.mpc.core.service.ICatalogService;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.core.service.IMarketplaceServiceLocator;
import org.eclipse.epp.mpc.core.service.IMarketplaceUnmarshaller;
import org.eclipse.epp.mpc.core.service.ITransportFactory;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceHelperImpl
extends ServiceHelper {
    private ServiceTracker<IMarketplaceServiceLocator, IMarketplaceServiceLocator> locatorServiceTracker;
    private ServiceTracker<ITransportFactory, ITransportFactory> transportFactoryTracker;
    private ServiceTracker<ITransportFactory, TransportFactory> legacyTransportFactoryTracker;
    private ServiceTracker<IMarketplaceUnmarshaller, IMarketplaceUnmarshaller> unmarshallerTracker;
    private BundleContext context;

    void startTracking(BundleContext context) {
        this.context = context;
        this.locatorServiceTracker = new ServiceTracker(context, IMarketplaceServiceLocator.class, null);
        this.locatorServiceTracker.open(true);
        this.transportFactoryTracker = new ServiceTracker(context, ITransportFactory.class, null);
        this.transportFactoryTracker.open(true);
        this.legacyTransportFactoryTracker = new TransportFactory.LegacyTransportFactoryTracker(context);
        this.legacyTransportFactoryTracker.open(true);
        this.unmarshallerTracker = new ServiceTracker(context, IMarketplaceUnmarshaller.class, null);
        this.unmarshallerTracker.open(true);
    }

    void stopTracking(BundleContext context) {
        this.context = null;
        if (this.locatorServiceTracker != null) {
            this.locatorServiceTracker.close();
            this.locatorServiceTracker = null;
        }
        if (this.transportFactoryTracker != null) {
            this.transportFactoryTracker.close();
            this.transportFactoryTracker = null;
        }
        if (this.legacyTransportFactoryTracker != null) {
            this.legacyTransportFactoryTracker.close();
            this.legacyTransportFactoryTracker = null;
        }
        if (this.unmarshallerTracker != null) {
            this.unmarshallerTracker.close();
            this.unmarshallerTracker = null;
        }
    }

    @Override
    protected IMarketplaceServiceLocator doGetMarketplaceServiceLocator() {
        return this.locatorServiceTracker == null ? null : (IMarketplaceServiceLocator)this.locatorServiceTracker.getService();
    }

    @Override
    protected IMarketplaceUnmarshaller doGetMarketplaceUnmarshaller() {
        return this.unmarshallerTracker == null ? null : (IMarketplaceUnmarshaller)this.unmarshallerTracker.getService();
    }

    @Override
    protected ITransportFactory doGetTransportFactory() {
        return this.transportFactoryTracker == null ? null : (ITransportFactory)this.transportFactoryTracker.getService();
    }

    @Deprecated
    public TransportFactory getLegacyTransportFactory() {
        return this.legacyTransportFactoryTracker == null ? null : (TransportFactory)this.legacyTransportFactoryTracker.getService();
    }

    public ServiceRegistration<IMarketplaceServiceLocator> registerMarketplaceServiceLocator(IMarketplaceServiceLocator marketplaceServiceLocator) {
        return this.context.registerService(IMarketplaceServiceLocator.class, (Object)marketplaceServiceLocator, ServiceUtil.higherServiceRanking(this.locatorServiceTracker.getServiceReference(), null));
    }

    public ServiceRegistration<IMarketplaceUnmarshaller> registerMarketplaceUnmarshaller(IMarketplaceUnmarshaller unmarshaller) {
        return this.context.registerService(IMarketplaceUnmarshaller.class, (Object)unmarshaller, ServiceUtil.higherServiceRanking(this.unmarshallerTracker.getServiceReference(), null));
    }

    public ServiceRegistration<ITransportFactory> registerTransportFactory(ITransportFactory transportFactory) {
        return this.context.registerService(ITransportFactory.class, (Object)transportFactory, ServiceUtil.higherServiceRanking(this.transportFactoryTracker.getServiceReference(), null));
    }

    public ServiceRegistration<IMarketplaceService> registerMarketplaceService(String baseUrl, IMarketplaceService marketplaceService) {
        Dictionary<String, Object> properties = ServiceUtil.serviceRanking(Integer.MAX_VALUE, null);
        properties.put("url", baseUrl);
        return this.context.registerService(IMarketplaceService.class, (Object)marketplaceService, properties);
    }

    public ServiceRegistration<ICatalogService> registerCatalogService(ICatalogService catalogService) {
        return this.context.registerService(ICatalogService.class, (Object)catalogService, ServiceUtil.serviceRanking(Integer.MAX_VALUE, null));
    }
}

