/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.addon.vcdgenerator.behaviors;

import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.TraceHelper;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.Block;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Expression;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.trace.util.ReferenceNameBuilder;
import fr.inria.aoste.timesquare.vcd.model.BinaryVectorValueChange;
import fr.inria.aoste.timesquare.vcd.model.ICommentCommand;
import fr.inria.aoste.timesquare.vcd.model.Value;
import fr.inria.aoste.timesquare.vcd.model.ValueChange;
import fr.inria.aoste.timesquare.vcd.model.keyword.VarType;
import fr.inria.aoste.trace.EnableStateKind;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.FiredStateKind;
import fr.inria.aoste.trace.ModelElementReference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gemoc.addon.vcdgenerator.ScoreBoard;
import org.eclipse.gemoc.addon.vcdgenerator.behaviors.AbstractVCDClockBehavior;

public class VCDGeneratorClockBehavior
extends AbstractVCDClockBehavior {
    private boolean _pulses;
    private boolean _ghosts;
    private boolean _timer;
    private boolean _dead;
    protected String _name;
    private ClockEntity _clock;
    private ICommentCommand _xmiCommentCommand = null;
    private final String _uniqueName;
    private ModelElementReference modelElementReference = null;
    private String _discretize = null;
    private boolean _wasBorn = true;

    public VCDGeneratorClockBehavior(boolean pulses, boolean ghosts, String name, String discretize) {
        this._pulses = pulses;
        this._ghosts = ghosts;
        this._dead = false;
        this._name = name;
        this._uniqueName = this.sanitizeClockName(name);
        this._scoreBoard = null;
        this._discretize = discretize;
    }

    public boolean isPulses() {
        return this._pulses;
    }

    public boolean isGhosts() {
        return this._ghosts;
    }

    public boolean isTimer() {
        return this._timer;
    }

    public boolean isDead() {
        return this._dead;
    }

    @Override
    public String getPCode() {
        return this._pCode;
    }

    public String getName() {
        return this._name;
    }

    public String getDiscretize() {
        return this._discretize;
    }

    public String getUniqueName() {
        return this._uniqueName;
    }

    public ClockEntity getClock() {
        return this._clock;
    }

    public void setPulses(boolean pulses) {
        this._pulses = pulses;
    }

    public void setGhosts(boolean ghosts) {
        this._ghosts = ghosts;
    }

    @Override
    public void setPCode(String pCode) {
        this._pCode = pCode;
    }

    public void setTimer(boolean timer) {
        this._timer = timer;
    }

    public void setClock(ClockEntity clock) {
        if (clock != null) {
            this._clock = clock;
            this.modelElementReference = clock.getModelElementReference();
        }
    }

    @Override
    public void setScoreBoard(ScoreBoard scoreBoard) {
        this._scoreBoard = scoreBoard;
    }

    public String getDescription() {
        return "This clock's VCD will be generated.";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        VCDGeneratorClockBehavior other = (VCDGeneratorClockBehavior)o;
        return this._pCode.equals(other._pCode) && this._uniqueName.equals(other._uniqueName);
    }

    public int hashCode() {
        int x = this._pCode != null ? this._pCode.hashCode() : 0;
        return x += this._uniqueName != null ? this._uniqueName.hashCode() : 0;
    }

    public void run(TraceHelper helper) {
        EventOccurrence eventOccurrence = helper.getClockState();
        if (this._pCode != null) {
            this.clockValueChangeGeneration(eventOccurrence);
        }
    }

    public void runWithWrongActivationState(TraceHelper helper) {
    }

    private void clockValueChangeGeneration(EventOccurrence eventOccurrence) {
        this._wasBorn = eventOccurrence.isWasBorn();
        this._dead = eventOccurrence.isIsClockDead();
        if (this._timer) {
            if (eventOccurrence.getFState() == FiredStateKind.TICK) {
                this._scoreBoard.add((ValueChange)new BinaryVectorValueChange("X", this._pCode));
            }
            if (eventOccurrence.getFState() == FiredStateKind.NO_TICK) {
                this._scoreBoard.add((ValueChange)new BinaryVectorValueChange("Z", this._pCode));
            }
        } else {
            if (eventOccurrence.getFState() == FiredStateKind.TICK) {
                this._scoreBoard.addScalarValueChange(Value._1, this._pCode);
                this._scoreBoard.getVcdModel().getClocklistener().putDataonTickClock(this._name, eventOccurrence.getCounter(), "clockstate", (Object)eventOccurrence);
            }
            if (eventOccurrence.getFState() == FiredStateKind.NO_TICK) {
                if (this._dead || !this._wasBorn) {
                    this._scoreBoard.addScalarValueChange(Value._z, this._pCode);
                } else if (eventOccurrence.getEState() == EnableStateKind.FREE || eventOccurrence.getEState() == EnableStateKind.INDETERMINED) {
                    this._scoreBoard.addScalarValueChange(Value._x, this._pCode);
                } else {
                    this._scoreBoard.addScalarValueChange(Value._0, this._pCode);
                }
            }
        }
    }

    @Override
    public void end() {
        this._scoreBoard.addScalarValueChange(Value._z, this._pCode);
    }

    @Override
    public void aNewStep() {
    }

    @Override
    public void aPostNewStep() {
        if (!this._timer) {
            if (this._dead || !this._wasBorn) {
                this._scoreBoard.addScalarValueChange(Value._z, this._pCode);
            } else {
                this._scoreBoard.addScalarValueChange(Value._0, this._pCode);
            }
        }
    }

    @Override
    public void initialize() {
        ICommentCommand icc;
        if (this.clockIsHiddenInVCD(this.modelElementReference)) {
            this._scoreBoard.getVcdModel().createCommentClock("hide", this._uniqueName);
        }
        this._scoreBoard.addVar(this._uniqueName, VarType.event, this._pCode);
        String alias = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)this.modelElementReference);
        if (alias.compareTo(this._uniqueName) != 0 && (icc = this._scoreBoard.getVcdModel().createCommentClock("alias", this._uniqueName)) != null) {
            icc.setString(2, "\"" + alias + "\"");
        }
        this.setInitialized(true);
    }

    private boolean clockIsHiddenInVCD(ModelElementReference modelElementReference) {
        EObject r = (EObject)modelElementReference.getElementRef().get(modelElementReference.getElementRef().size() - 1);
        if (r instanceof Clock || r instanceof Expression) {
            return r.eContainer() == null || !(r.eContainer() instanceof Block);
        }
        return false;
    }
}

