/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gemoc.commons.eclipse.core.resources.IProjectUtils;
import org.eclipse.gemoc.commons.eclipse.pde.ui.PluginConverter;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.dse.AddRemoveGemocDSENatureHandler;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.ui.wizards.pages.AskDSEInfoWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class CreateNewDSEProject
extends Wizard
implements INewWizard {
    public WizardNewProjectCreationPage _askProjectNamePage;
    public AskDSEInfoWizardPage _askDSEInfoPage;
    private AddRemoveGemocDSENatureHandler nature = new AddRemoveGemocDSENatureHandler();
    private IProject createdProject = null;
    public String createdProjectName = "";
    public String createdTemplateECLFile = "";

    public CreateNewDSEProject() {
        this.setWindowTitle("Create DSE project");
        this._askProjectNamePage = new WizardNewProjectCreationPage("NewProjectName");
        this._askProjectNamePage.setTitle("Project");
        this._askProjectNamePage.setDescription("Create a new DSE Project");
        this.addPage((IWizardPage)this._askProjectNamePage);
        this._askDSEInfoPage = new AskDSEInfoWizardPage("NewDSEInfo");
        this._askDSEInfoPage.setTitle("Language");
        this._askDSEInfoPage.setDescription("Specify the DSE");
        this.addPage((IWizardPage)this._askDSEInfoPage);
    }

    public void addPages() {
        super.addPages();
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this._askDSEInfoPage && this._askDSEInfoPage.isPageComplete();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        try {
            this.createdProject = this._askProjectNamePage.getProjectHandle();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            final IProjectDescription description = workspace.newProjectDescription(this.createdProject.getName());
            if (!this._askProjectNamePage.getLocationPath().equals((Object)workspace.getRoot().getLocation())) {
                description.setLocation(this._askProjectNamePage.getLocationPath());
            }
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    CreateNewDSEProject.this.createdProject.create(description, monitor);
                    CreateNewDSEProject.this.createdProject.open(monitor);
                    try {
                        PluginConverter.convert((IProject)CreateNewDSEProject.this.createdProject);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    IProjectUtils.createFolder((IProject)CreateNewDSEProject.this.createdProject, (String)"ecl", (IProgressMonitor)monitor);
                    String content = "rootElement = " + CreateNewDSEProject.this._askDSEInfoPage.getRootContainerModelElement();
                    IProjectUtils.createFile((IProject)CreateNewDSEProject.this.createdProject, (String)"moc2as.properties", (String)content, (IProgressMonitor)monitor);
                    String filePath = "ecl/" + CreateNewDSEProject.this._askDSEInfoPage.getTemplateECLFileNameFile() + ".ecl";
                    StringBuilder eclfilecontent = new StringBuilder();
                    eclfilecontent.append("import '" + CreateNewDSEProject.this._askDSEInfoPage.metamodelNsuri + "'\n\n");
                    eclfilecontent.append("ECLimport \"platform:/plugin/fr.inria.aoste.timesquare.ccslkernel.model/ccsllibrary/kernel.ccslLib\"\nECLimport \"platform:/plugin/fr.inria.aoste.timesquare.ccslkernel.model/ccsllibrary/CCSL.ccslLib\"\n\n");
                    if (CreateNewDSEProject.this._askDSEInfoPage.getRootContainerModelElement().contains("::")) {
                        String packageName = CreateNewDSEProject.this._askDSEInfoPage.getRootContainerModelElement().substring(0, CreateNewDSEProject.this._askDSEInfoPage.getRootContainerModelElement().indexOf("::"));
                        eclfilecontent.append("package " + packageName + "\n\n\t --add DSE and MoCCML mapping here\n\n endpackage");
                    }
                    IProjectUtils.createFile((IProject)CreateNewDSEProject.this.createdProject, (String)filePath, (String)eclfilecontent.toString(), (IProgressMonitor)monitor);
                    String buildFileContent = "bin.includes = META-INF/,\\\r\n\tqvto-gen/modeling/";
                    IProjectUtils.setFileContent((IProject)CreateNewDSEProject.this.createdProject, (String)"build.properties", (String)buildFileContent);
                    CreateNewDSEProject.this.addDSEProjectNature(CreateNewDSEProject.this.createdProject);
                    CreateNewDSEProject.this.createdProjectName = CreateNewDSEProject.this._askProjectNamePage.getProjectName();
                    CreateNewDSEProject.this.createdTemplateECLFile = CreateNewDSEProject.this._askDSEInfoPage.getTemplateECLFileNameFile();
                    CreateNewDSEProject.this.createdProject.refreshLocal(2, monitor);
                    CreateNewDSEProject.this.createdProject.touch((IProgressMonitor)new NullProgressMonitor());
                }
            };
            ResourcesPlugin.getWorkspace().run(operation, null);
        }
        catch (CoreException exception) {
            Activator.error(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private void addDSEProjectNature(IProject project) throws CoreException {
        this.nature.toggleNature(project);
    }

    public IProject getCreatedProject() {
        return this.createdProject;
    }
}

