/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.trace.gemoc.generator.codegen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opsemanticsview.Rule;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gemoc.trace.commons.CodeGenUtil;
import org.eclipse.gemoc.trace.commons.EcoreCraftingUtil;
import org.eclipse.gemoc.trace.commons.model.trace.TracePackage;
import org.eclipse.gemoc.trace.metamodel.generator.TraceMMGenerationTraceability;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class TraceConstructorGeneratorJava {
    private final String className;
    private final String packageQN;
    private final EPackage traceMM;
    private final EPackage abstractSyntax;
    private final TraceMMGenerationTraceability traceability;
    private final Set<GenPackage> refGenPackages;
    private final boolean partialTraceManagement;
    private boolean getExeToTracedUsed = false;
    private final EClass stateClass;
    private final EClass specificStepClass;
    private final String stateFQN;
    private final String specificStepFQN;

    public String getClassName() {
        return this.className;
    }

    public TraceConstructorGeneratorJava(String languageName, String packageQN, EPackage traceMM, TraceMMGenerationTraceability traceability, Set<GenPackage> refGenPackages, EPackage abstractSyntax, boolean partialTraceManagement) {
        String _plus;
        this.traceMM = traceMM;
        String _firstUpper = StringExtensions.toFirstUpper((String)languageName.replaceAll(" ", ""));
        this.className = _plus = String.valueOf(_firstUpper) + "Constructor";
        this.packageQN = packageQN;
        this.traceability = traceability;
        this.refGenPackages = refGenPackages;
        this.abstractSyntax = abstractSyntax;
        this.stateClass = traceability.getTraceMMExplorer().getSpecificStateClass();
        this.specificStepClass = traceability.getTraceMMExplorer().getSpecificStepClass();
        this.partialTraceManagement = partialTraceManagement;
        this.stateFQN = this.getJavaFQN((EClassifier)this.stateClass);
        this.specificStepFQN = this.getJavaFQN((EClassifier)this.specificStepClass);
    }

    private Set<EClass> findAllDirectSubTypes(final EClass clazz) {
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return c.getESuperTypes().contains((Object)clazz);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)this.traceability.getAllMutableClasses(), (Functions.Function1)_function));
    }

    private String getFQN(EStructuralFeature eFeature) {
        String _baseFQN = EcoreCraftingUtil.getBaseFQN((EClassifier)eFeature.getEContainingClass());
        String _plus = String.valueOf(_baseFQN) + ".";
        String _name = eFeature.getName();
        return String.valueOf(_plus) + _name;
    }

    private static boolean isNotSuperTypeOf(EClass c, Collection<EClass> eclasses) {
        for (EClass eclass : eclasses) {
            boolean _contains = eclass.getEAllSuperTypes().contains((Object)c);
            if (!_contains) continue;
            return false;
        }
        return true;
    }

    private String getTracedJavaFQN(EClassifier c, boolean enforcePrimitiveJavaClass) {
        if (c instanceof EClass) {
            boolean _notEquals;
            EClass tracedClass = this.traceability.getTracedClass((EClass)c);
            boolean bl = _notEquals = !Objects.equal((Object)tracedClass, null);
            if (_notEquals) {
                return this.getJavaFQN((EClassifier)this.traceability.getTracedClass((EClass)c), enforcePrimitiveJavaClass);
            }
            return this.getJavaFQN(c, enforcePrimitiveJavaClass);
        }
        return this.getJavaFQN(c, enforcePrimitiveJavaClass);
    }

    private String getJavaFQN(EClassifier c) {
        return this.getJavaFQN(c, false);
    }

    private String getJavaFQN(EClassifier c, boolean enforcePrimitiveJavaClass) {
        return EcoreCraftingUtil.getJavaFQN((EClassifier)c, this.refGenPackages, (boolean)enforcePrimitiveJavaClass);
    }

    private String stringSetter(EStructuralFeature f, String value) {
        return EcoreCraftingUtil.stringSetter((EStructuralFeature)f, (String)value, this.refGenPackages);
    }

    private static Set<EClass> findTopSuperClasses(Iterable<EClass> eclasses) {
        HashSet<EClass> res = new HashSet<EClass>();
        for (final EClass c : eclasses) {
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass s) {
                    return !c.getName().endsWith("Configuration") || !c.getName().startsWith(s.getName());
                }
            };
            Iterable filtered = IterableExtensions.filter((Iterable)c.getESuperTypes(), (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)filtered);
            if (_isEmpty) {
                res.add(c);
                continue;
            }
            Set<EClass> candidates = TraceConstructorGeneratorJava.findTopSuperClasses(filtered);
            res.addAll(candidates);
        }
        return res;
    }

    private static List<EClass> partialOrderSort(Iterable<EClass> eclasses) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        for (EClass ci : eclasses) {
            boolean _isEmpty = result.isEmpty();
            if (_isEmpty) {
                result.add(ci);
                continue;
            }
            boolean found = false;
            int i = 0;
            while (i < result.size() && !found) {
                Set followings = IterableExtensions.toSet(result.subList(i, result.size()));
                boolean _isNotSuperTypeOf = TraceConstructorGeneratorJava.isNotSuperTypeOf(ci, followings);
                if (_isNotSuperTypeOf) {
                    result.add(i, ci);
                    found = true;
                }
                ++i;
            }
            if (found) continue;
            result.add(ci);
        }
        return result;
    }

    public String generateCode() {
        String code = this.generateTraceConstructorClass();
        try {
            return CodeGenUtil.formatJavaCode((String)code);
        }
        catch (Throwable _t) {
            if (_t instanceof Throwable) {
                return code;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static String getBaseFQN(Rule r) {
        EOperation o = r.getOperation();
        EClass c = r.getContainingClass();
        String _baseFQN = EcoreCraftingUtil.getBaseFQN((EClassifier)c);
        String _plus = String.valueOf(_baseFQN) + ".";
        String _name = o.getName();
        return String.valueOf(_plus) + _name;
    }

    private String stringGetterTracedValue(String javaVarName, EStructuralFeature p) {
        EClassifier pRealType = p.getEType();
        if (p instanceof EReference && this.traceability.hasTracedClass((EClass)pRealType)) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("((");
            String _javaFQN = this.getJavaFQN((EClassifier)this.traceability.getTracedClass((EClass)pRealType));
            _builder.append(_javaFQN);
            _builder.append(")exeToTraced.get(");
            _builder.append(javaVarName);
            _builder.append(".");
            String _stringGetter = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
            _builder.append(_stringGetter);
            _builder.append("))");
            _builder.newLineIfNotEmpty();
            return _builder.toString();
        }
        String _stringGetter_1 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
        return String.valueOf(javaVarName) + "." + _stringGetter_1;
    }

    private Set<EStructuralFeature> getAllMutablePropertiesOf(EClass exeClass) {
        HashSet<EStructuralFeature> res = new HashSet<EStructuralFeature>();
        res.addAll(this.traceability.getMutablePropertiesOf(exeClass));
        Functions.Function1<EClass, Set<EStructuralFeature>> _function = new Functions.Function1<EClass, Set<EStructuralFeature>>(){

            public Set<EStructuralFeature> apply(EClass s) {
                return TraceConstructorGeneratorJava.this.traceability.getMutablePropertiesOf(s);
            }
        };
        res.addAll(IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)exeClass.getEAllSuperTypes(), (Functions.Function1)_function))));
        return res;
    }

    private String generateImports() {
        StringConcatenation _builder = new StringConcatenation();
        if (this.getExeToTracedUsed) {
            _builder.append("import java.util.ArrayList;");
            _builder.newLine();
        }
        _builder.append("import java.util.Collection;");
        _builder.newLine();
        _builder.append("import java.util.Deque;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import java.util.LinkedList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import java.util.Map;");
        _builder.newLine();
        _builder.append("import java.util.Set;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.emf.common.util.TreeIterator;");
        _builder.newLine();
        _builder.append("import org.eclipse.emf.common.util.URI;");
        _builder.newLine();
        _builder.append("import org.eclipse.emf.ecore.EObject;");
        _builder.newLine();
        _builder.append("import org.eclipse.emf.ecore.resource.Resource;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.commons.model.launchconfiguration.LaunchConfiguration;");
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.commons.model.trace.MSEModel;");
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.commons.model.trace.SequentialStep;");
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.commons.model.trace.TracedObject;");
        _builder.newLine();
        _builder.append("import org.eclipse.gemoc.trace.gemoc.api.ITraceConstructor;");
        _builder.newLine();
        return _builder.toString();
    }

    private String generateFields() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private ");
        String _javaFQN = this.getJavaFQN((EClassifier)this.traceability.getTraceMMExplorer().getSpecificTraceClass());
        _builder.append(_javaFQN);
        _builder.append(" traceRoot;");
        _builder.newLineIfNotEmpty();
        _builder.append("private MSEModel mseModel;");
        _builder.newLine();
        _builder.append("private Resource executedModel;");
        _builder.newLine();
        _builder.append("private final Map<EObject, TracedObject<?>> exeToTraced;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("private ");
        _builder.append(this.stateFQN);
        _builder.append(" lastState;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("private Resource traceResource;");
        _builder.newLine();
        _builder.append("private final Deque<");
        _builder.append(this.specificStepFQN);
        _builder.append("> context = new LinkedList<");
        _builder.append(this.specificStepFQN);
        _builder.append(">();");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String generateConstructor() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public ");
        _builder.append(this.className);
        _builder.append(" (Resource exeModel, Resource traceResource, Map<EObject, TracedObject<?>> exeToTraced) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("this.traceResource = traceResource;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.executedModel = exeModel;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("this.exeToTraced = exeToTraced;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private String getExeToTracedMethodName() {
        this.getExeToTracedUsed = true;
        return "getExeToTraced";
    }

    private String stringFeatureID(EStructuralFeature p) {
        EClassifier _xifexpression = null;
        EObject _eContainer = p.eContainer();
        if (_eContainer instanceof EClass) {
            EObject _eContainer_1 = p.eContainer();
            _xifexpression = (EClassifier)_eContainer_1;
        }
        EClassifier containingClass = _xifexpression;
        return EcoreCraftingUtil.stringFeatureID((EStructuralFeature)p, (EClassifier)containingClass, this.refGenPackages);
    }

    private String generateGetAllResourcesMethod() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private Set<Resource> getAllExecutedModelResources() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Set<Resource> allResources = new HashSet<>();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("allResources.add(executedModel);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("allResources.addAll(org.eclipse.gemoc.commons.eclipse.emf.EMFResource.getRelatedResources(executedModel));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("allResources.removeIf(r -> r == null || (r != executedModel && executedModel.getContents().contains(r.getContents().get(0))));");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return allResources;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private String generateAddInitialStateMethod() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("private void addInitialState() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (lastState == null) {");
        _builder.newLine();
        _builder.append("// Creation of the initial state");
        _builder.newLine();
        _builder.append("Set<Resource> allResources = getAllExecutedModelResources();");
        _builder.newLine();
        _builder.append("lastState =  ");
        String _stringCreate = EcoreCraftingUtil.stringCreate((EClass)this.stateClass);
        _builder.append(_stringCreate);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("for (Resource r : allResources) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("for (TreeIterator<EObject> i = r.getAllContents(); i.hasNext();) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("EObject o = i.next();");
        _builder.newLine();
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                boolean _isAbstract = c.isAbstract();
                return !_isAbstract;
            }
        };
        Functions.Function1<EClass, String> _function_1 = new Functions.Function1<EClass, String>(){

            public String apply(EClass it) {
                return it.getName();
            }
        };
        List<EClass> _partialOrderSort = TraceConstructorGeneratorJava.partialOrderSort(TraceConstructorGeneratorJava.findTopSuperClasses(IterableExtensions.toSet((Iterable)IterableExtensions.sortBy((Iterable)IterableExtensions.filter((Iterable)this.traceability.getAllMutableClasses(), (Functions.Function1)_function), (Functions.Function1)_function_1))));
        boolean _hasElements = false;
        for (EClass c : _partialOrderSort) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"else", "\t\t\t");
            }
            _builder.append("\t\t\t");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("if (o instanceof ");
            String _javaFQN = this.getJavaFQN((EClassifier)c);
            _builder.append(_javaFQN, "\t\t\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            String _javaFQN_1 = this.getJavaFQN((EClassifier)c);
            _builder.append(_javaFQN_1, "\t\t\t\t");
            _builder.append(" o_cast = (");
            String _javaFQN_2 = this.getJavaFQN((EClassifier)c);
            _builder.append(_javaFQN_2, "\t\t\t\t");
            _builder.append(") o;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("addNewObjectToState(o_cast, lastState);");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.append("this.traceRoot.getStates().add(lastState);");
        _builder.newLine();
        _builder.append("}}");
        _builder.newLine();
        return _builder.toString();
    }

    private boolean shouldHaveAddNewObjectToStateMethod(EClassifier c) {
        boolean _xifexpression = false;
        _xifexpression = c instanceof EClass ? this.shouldHaveAddNewObjectToStateMethod((EClass)c) : false;
        return _xifexpression;
    }

    private boolean shouldHaveAddNewObjectToStateMethod(EClass c) {
        Set<EClass> subTypes = this.findAllDirectSubTypes(c);
        if (this.traceability.getAllMutableClasses().contains(c) && !c.isAbstract()) {
            return true;
        }
        if (subTypes.isEmpty() && c.isAbstract()) {
            return false;
        }
        if (!subTypes.isEmpty() && c.isAbstract()) {
            boolean _not;
            Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass s) {
                    return TraceConstructorGeneratorJava.this.shouldHaveAddNewObjectToStateMethod(s);
                }
            };
            Iterable validSubTypes = IterableExtensions.filter(subTypes, (Functions.Function1)_function);
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)validSubTypes);
            boolean bl = _not = !_isEmpty;
            if (_not) {
                return true;
            }
        }
        return false;
    }

    private String generateAddNewObjectToStateMethods() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1<EClass, String> _function = new Functions.Function1<EClass, String>(){

            public String apply(EClass it) {
                return it.getName();
            }
        };
        List _sortBy = IterableExtensions.sortBy((Iterable)this.traceability.getAllMutableClasses(), (Functions.Function1)_function);
        for (EClass c : _sortBy) {
            boolean _not;
            EClass traced = this.traceability.getTracedClass(c);
            _builder.newLineIfNotEmpty();
            List<EClass> subTypes = TraceConstructorGeneratorJava.partialOrderSort(this.findAllDirectSubTypes(c));
            _builder.newLineIfNotEmpty();
            boolean _shouldHaveAddNewObjectToStateMethod = this.shouldHaveAddNewObjectToStateMethod(c);
            if (!_shouldHaveAddNewObjectToStateMethod) continue;
            Functions.Function1<EStructuralFeature, Boolean> _function_1 = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature p) {
                    return p instanceof EReference && p.isMany();
                }
            };
            boolean _exists = IterableExtensions.exists(this.getAllMutablePropertiesOf(c), (Functions.Function1)_function_1);
            if (_exists) {
                _builder.append("@SuppressWarnings(\"unchecked\")");
                _builder.newLine();
            }
            _builder.append("private boolean addNewObjectToState(");
            String _javaFQN = this.getJavaFQN((EClassifier)c);
            _builder.append(_javaFQN);
            _builder.append(" o_cast, ");
            _builder.append(this.stateFQN);
            _builder.append(" newState) {");
            _builder.newLineIfNotEmpty();
            _builder.append("boolean added = false; ");
            _builder.newLine();
            Functions.Function1<EClass, Boolean> _function_2 = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass sub) {
                    return TraceConstructorGeneratorJava.this.shouldHaveAddNewObjectToStateMethod(sub);
                }
            };
            Iterable subTypesWithMethods = IterableExtensions.filter(subTypes, (Functions.Function1)_function_2);
            _builder.newLineIfNotEmpty();
            boolean _hasElements = false;
            for (EClass subType : subTypesWithMethods) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)" else ", "");
                }
                _builder.append("if (o_cast instanceof ");
                String _javaFQN_1 = this.getJavaFQN((EClassifier)subType);
                _builder.append(_javaFQN_1);
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("added = addNewObjectToState((");
                String _javaFQN_2 = this.getJavaFQN((EClassifier)subType);
                _builder.append(_javaFQN_2, "\t");
                _builder.append(")o_cast, newState);");
                _builder.newLineIfNotEmpty();
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.newLine();
            boolean _isAbstract = c.isAbstract();
            boolean bl = _not = !_isAbstract;
            if (_not) {
                _builder.newLine();
                _builder.append("if (!added && !exeToTraced.containsKey(o_cast)) {");
                _builder.newLine();
                _builder.append("\t");
                String _javaFQN_3 = this.getJavaFQN((EClassifier)traced);
                _builder.append(_javaFQN_3, "\t");
                _builder.append(" tracedObject = ");
                String _stringCreate = EcoreCraftingUtil.stringCreate((EClass)traced);
                _builder.append(_stringCreate, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                Set origRefs1 = this.traceability.getRefs_originalObject(traced);
                _builder.newLineIfNotEmpty();
                Functions.Function1<EReference, String> _function_3 = new Functions.Function1<EReference, String>(){

                    public String apply(EReference it) {
                        return it.getName();
                    }
                };
                List _sortBy_1 = IterableExtensions.sortBy((Iterable)origRefs1, (Functions.Function1)_function_3);
                for (EReference origRef : _sortBy_1) {
                    _builder.append("\t");
                    _builder.append("tracedObject.");
                    String _stringSetter = this.stringSetter((EStructuralFeature)origRef, "o_cast");
                    _builder.append(_stringSetter, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t");
                _builder.append("exeToTraced.put(o_cast, tracedObject);");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("traceRoot.getTracedObjects().add(tracedObject);");
                _builder.newLine();
                _builder.append("\t");
                _builder.newLine();
                Functions.Function1<EStructuralFeature, String> _function_4 = new Functions.Function1<EStructuralFeature, String>(){

                    public String apply(EStructuralFeature it) {
                        return TraceConstructorGeneratorJava.this.getFQN(it);
                    }
                };
                List _sortBy_2 = IterableExtensions.sortBy(this.getAllMutablePropertiesOf(c), (Functions.Function1)_function_4);
                for (EStructuralFeature p : _sortBy_2) {
                    _builder.append("\t");
                    EClass pdimensionClass = this.traceability.getDimensionClass(p);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    EReference pdimensionRef = this.traceability.getDimensionRef(p);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    EClass valueClass = this.traceability.getValueClass(p);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    EStructuralFeature valueProperty = this.traceability.getValuePropertyOfMutableProperty(p);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("// Creation of the dimension corresponding to the field ");
                    String _name = p.getName();
                    _builder.append(_name, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("tracedObject.");
                    String _stringSetter_1 = EcoreCraftingUtil.stringSetter((EStructuralFeature)pdimensionRef, (String)EcoreCraftingUtil.stringCreate((EClass)pdimensionClass));
                    _builder.append(_stringSetter_1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("// Creation of the first value of the field ");
                    String _name_1 = p.getName();
                    _builder.append(_name_1, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    String _javaFQN_4 = this.getJavaFQN((EClassifier)valueClass);
                    _builder.append(_javaFQN_4, "\t");
                    _builder.append(" firstValue_");
                    String _name_2 = p.getName();
                    _builder.append(_name_2, "\t");
                    _builder.append(" = ");
                    String _stringCreate_1 = EcoreCraftingUtil.stringCreate((EClass)valueClass);
                    _builder.append(_stringCreate_1, "\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.newLine();
                    boolean _isMany = p.isMany();
                    if (_isMany) {
                        _builder.append("\t");
                        _builder.newLine();
                        if (p instanceof EReference) {
                            _builder.append("\t");
                            _builder.newLine();
                            _builder.append("\t");
                            _builder.newLine();
                            boolean _shouldHaveAddNewObjectToStateMethod_1 = this.shouldHaveAddNewObjectToStateMethod(((EReference)p).getEType());
                            if (_shouldHaveAddNewObjectToStateMethod_1) {
                                _builder.append("\t");
                                _builder.append("for(");
                                String _javaFQN_5 = this.getJavaFQN(((EReference)p).getEType());
                                _builder.append(_javaFQN_5, "\t");
                                _builder.append(" aValue : o_cast.");
                                String _stringGetter = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
                                _builder.append(_stringGetter, "\t");
                                _builder.append(") {");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("addNewObjectToState((");
                                String _javaFQN_6 = this.getJavaFQN(((EReference)p).getEType());
                                _builder.append(_javaFQN_6, "\t\t");
                                _builder.append(")aValue, newState);");
                                _builder.newLineIfNotEmpty();
                                _builder.append("\t");
                                _builder.append("}");
                                _builder.newLine();
                            }
                            _builder.append("\t");
                            _builder.newLine();
                            _builder.append("\t");
                            _builder.append("firstValue_");
                            String _name_3 = ((EReference)p).getName();
                            _builder.append(_name_3, "\t");
                            _builder.append(".");
                            String _stringGetter_1 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
                            _builder.append(_stringGetter_1, "\t");
                            _builder.append(".addAll");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("(");
                            _builder.newLine();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("(Collection<? extends ");
                            String _tracedJavaFQN = this.getTracedJavaFQN(this.traceability.getValuePropertyOfMutableProperty(p).getEType(), true);
                            _builder.append(_tracedJavaFQN, "\t\t");
                            _builder.append(">)");
                            _builder.newLineIfNotEmpty();
                            boolean _contains = this.traceability.getAllMutableClasses().contains(((EReference)p).getEType());
                            if (_contains) {
                                _builder.append("\t");
                                _builder.append("\t");
                                String _exeToTracedMethodName = this.getExeToTracedMethodName();
                                _builder.append(_exeToTracedMethodName, "\t\t");
                                _builder.append("(o_cast.");
                                String _stringGetter_2 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
                                _builder.append(_stringGetter_2, "\t\t");
                                _builder.append(", newState)");
                                _builder.newLineIfNotEmpty();
                            } else {
                                _builder.append("\t");
                                _builder.append("\t");
                                _builder.append("o_cast.");
                                String _stringGetter_3 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
                                _builder.append(_stringGetter_3, "\t\t");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append(");");
                            _builder.newLine();
                            _builder.append("\t");
                        } else {
                            _builder.append(" ");
                            _builder.append("\tfirstValue_");
                            String _name_4 = p.getName();
                            _builder.append(_name_4, "\t");
                            _builder.append(".");
                            String _stringGetter_4 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
                            _builder.append(_stringGetter_4, "\t");
                            _builder.append(".addAll");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("((Collection<? extends ");
                            String _tracedJavaFQN_1 = this.getTracedJavaFQN(this.traceability.getValuePropertyOfMutableProperty(p).getEType(), true);
                            _builder.append(_tracedJavaFQN_1, "\t\t");
                            _builder.append(">) o_cast.");
                            String _stringGetter_5 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
                            _builder.append(_stringGetter_5, "\t\t");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("\t");
                        _builder.newLine();
                    } else if (p instanceof EReference) {
                        _builder.append("\t");
                        EClassifier realMutableType = ((EReference)p).getEType();
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("if (o_cast.");
                        String _stringGetter_6 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
                        _builder.append(_stringGetter_6, "\t");
                        _builder.append(" != null) {");
                        _builder.newLineIfNotEmpty();
                        boolean _shouldHaveAddNewObjectToStateMethod_2 = this.shouldHaveAddNewObjectToStateMethod(realMutableType);
                        if (_shouldHaveAddNewObjectToStateMethod_2) {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("addNewObjectToState((");
                            String _javaFQN_7 = this.getJavaFQN(realMutableType);
                            _builder.append(_javaFQN_7, "\t\t");
                            _builder.append(")o_cast.");
                            String _stringGetter_7 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
                            _builder.append(_stringGetter_7, "\t\t");
                            _builder.append(", newState);");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("firstValue_");
                            String _name_5 = ((EReference)p).getName();
                            _builder.append(_name_5, "\t\t");
                            _builder.append(".");
                            String _stringSetter_2 = this.stringSetter(valueProperty, this.stringGetterTracedValue("o_cast", p));
                            _builder.append(_stringSetter_2, "\t\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("firstValue_");
                            String _name_6 = ((EReference)p).getName();
                            _builder.append(_name_6, "\t\t");
                            _builder.append(".");
                            String _stringGetter_8 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
                            String _plus = "o_cast." + _stringGetter_8;
                            String _stringSetter_3 = this.stringSetter(valueProperty, _plus);
                            _builder.append(_stringSetter_3, "\t\t");
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("\t");
                        }
                        _builder.append(" ");
                        _builder.append("\t} else {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("firstValue_");
                        String _name_7 = ((EReference)p).getName();
                        _builder.append(_name_7, "\t\t");
                        _builder.append(".");
                        String _stringSetter_4 = this.stringSetter(valueProperty, "null");
                        _builder.append(_stringSetter_4, "\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.newLine();
                        _builder.append("\t");
                    } else {
                        _builder.append(" ");
                        _builder.append("\tfirstValue_");
                        String _name_8 = p.getName();
                        _builder.append(_name_8, "\t");
                        _builder.append(".");
                        String _stringGetter_9 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p);
                        String _plus_1 = "o_cast." + _stringGetter_9;
                        String _stringSetter_5 = this.stringSetter(valueProperty, _plus_1);
                        _builder.append(_stringSetter_5, "\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t");
                    _builder.append("tracedObject.");
                    String _stringGetter_10 = EcoreCraftingUtil.stringGetter((EStructuralFeature)pdimensionRef);
                    _builder.append(_stringGetter_10, "\t");
                    _builder.append(".getValues().add(firstValue_");
                    String _name_9 = p.getName();
                    _builder.append(_name_9, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("newState.getValues().add(firstValue_");
                    String _name_10 = p.getName();
                    _builder.append(_name_10, "\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.newLine();
                }
                _builder.append(" ");
                _builder.append("} // end if (!exeToTraced.containsKey");
                _builder.newLineIfNotEmpty();
            }
            _builder.append(" ");
            _builder.append("return added;");
            _builder.newLineIfNotEmpty();
            _builder.append("}// end addNewObjectToState");
            _builder.newLine();
        }
        _builder.append(" ");
        return _builder.toString();
    }

    private String generateAddStateUsingListenerMethods() {
        boolean _isEmpty_3;
        boolean _not_3;
        boolean _not_1;
        boolean _not;
        Functions.Function1<EClass, Boolean> _function = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                boolean _isEmpty = c.getEStructuralFeatures().isEmpty();
                return !_isEmpty;
            }
        };
        Set newClassesNotEmpty = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)this.traceability.getNewClasses(), (Functions.Function1)_function));
        Functions.Function1<EClass, Boolean> _function_1 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                boolean _isAbstract = c.isAbstract();
                return !_isAbstract;
            }
        };
        final List<EClass> newAbstractClassesNotEmpty = TraceConstructorGeneratorJava.partialOrderSort(IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)newClassesNotEmpty, (Functions.Function1)_function_1)));
        Functions.Function1<EClass, Boolean> _function_2 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                EList _eAllSuperTypes = c.getEAllSuperTypes();
                ArrayList superTypes = new ArrayList(_eAllSuperTypes);
                superTypes.retainAll(newAbstractClassesNotEmpty);
                return !c.isAbstract() && (!c.getEStructuralFeatures().isEmpty() || !superTypes.isEmpty());
            }
        };
        List newConcreteClassesNotEmpty = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)this.traceability.getNewClasses(), (Functions.Function1)_function_2));
        Functions.Function1<EClass, Boolean> _function_3 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return !TraceConstructorGeneratorJava.this.traceability.getMutablePropertiesOf(c).isEmpty() && IterableExtensions.exists((Iterable)TraceConstructorGeneratorJava.this.traceability.getMutablePropertiesOf(c), (Functions.Function1)new Functions.Function1<EStructuralFeature, Boolean>(){

                    public Boolean apply(EStructuralFeature p) {
                        boolean _isMany = p.isMany();
                        return !_isMany;
                    }
                });
            }
        };
        Iterable mutableClassesWithNonCollectionMutableFields = IterableExtensions.filter((Iterable)this.traceability.getAllMutableClasses(), (Functions.Function1)_function_3);
        Functions.Function1<EClass, Boolean> _function_4 = new Functions.Function1<EClass, Boolean>(){

            public Boolean apply(EClass c) {
                return !TraceConstructorGeneratorJava.this.traceability.getMutablePropertiesOf(c).isEmpty() && IterableExtensions.exists((Iterable)TraceConstructorGeneratorJava.this.traceability.getMutablePropertiesOf(c), (Functions.Function1)new Functions.Function1<EStructuralFeature, Boolean>(){

                    public Boolean apply(EStructuralFeature p) {
                        return p.isMany();
                    }
                });
            }
        };
        Iterable mutableClassesWithCollectionMutableFields = IterableExtensions.filter((Iterable)this.traceability.getAllMutableClasses(), (Functions.Function1)_function_4);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private boolean copiedState = false;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("private ");
        _builder.append(this.stateFQN);
        _builder.append(" copyState(");
        _builder.append(this.stateFQN);
        _builder.append("  oldState) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(this.stateFQN, "\t");
        _builder.append(" newState = ");
        String _stringCreate = EcoreCraftingUtil.stringCreate((EClass)this.stateClass);
        _builder.append(_stringCreate, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("newState.getValues().addAll(oldState.getValues());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("copiedState = true;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return newState;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public void addState(List<org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.ModelChange> changes) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("if (lastState == null) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("addInitialState();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.append("\t\t\t\t\telse if (!changes.isEmpty()) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("boolean stateChanged = false;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// We start by a (shallow) copy of the last state");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// But we will have to rollback a little by replacing values that changed");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(this.stateFQN, "\t\t");
        _builder.append(" newState = copyState(lastState);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("for (org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.ModelChange modelChange : changes) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("EObject o = modelChange.getChangedObject();");
        _builder.newLine();
        boolean _isEmpty = newConcreteClassesNotEmpty.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("\t\t\t");
            _builder.append("// We only look at constructable objects that have mutable fields");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// Here we have nothing to rollback, just a new object to add");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("if (modelChange instanceof org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NewObjectModelChange) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("stateChanged = true;");
            _builder.newLine();
            Functions.Function1<EClass, Boolean> _function_5 = new Functions.Function1<EClass, Boolean>(){

                public Boolean apply(EClass c) {
                    return TraceConstructorGeneratorJava.this.shouldHaveAddNewObjectToStateMethod(c);
                }
            };
            Iterable _filter = IterableExtensions.filter(TraceConstructorGeneratorJava.partialOrderSort(TraceConstructorGeneratorJava.findTopSuperClasses(newConcreteClassesNotEmpty)), (Functions.Function1)_function_5);
            for (Object c : _filter) {
                _builder.append("\t\t\t");
                _builder.append("if (o instanceof ");
                String _javaFQN = this.getJavaFQN((EClassifier)c);
                _builder.append(_javaFQN, "\t\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                String _javaFQN_1 = this.getJavaFQN((EClassifier)c);
                _builder.append(_javaFQN_1, "\t\t\t\t");
                _builder.append(" o_cast = (");
                String _javaFQN_2 = this.getJavaFQN((EClassifier)c);
                _builder.append(_javaFQN_2, "\t\t\t\t");
                _builder.append(") o;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("addNewObjectToState(o_cast, newState);");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("} ");
                _builder.append("\t\t\t\t\t\t\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.append("\t\t\t\t\t\t\t");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// We only look at constructable objects that have mutable fields");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// Here we must rollback to remove the values of the removed object from the copied state");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("else if (modelChange instanceof org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.RemovedObjectModelChange) {");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("stateChanged = true;");
            _builder.newLine();
            List<EClass> _partialOrderSort = TraceConstructorGeneratorJava.partialOrderSort(newClassesNotEmpty);
            for (EClass c_1 : _partialOrderSort) {
                _builder.append("\t\t\t");
                EClass traced = this.traceability.getTracedClass(c_1);
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("if (o instanceof ");
                String _javaFQN_3 = this.getJavaFQN((EClassifier)c_1);
                _builder.append(_javaFQN_3, "\t\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                String _javaFQN_4 = this.getJavaFQN((EClassifier)c_1);
                _builder.append(_javaFQN_4, "\t\t\t\t");
                _builder.append(" o_cast = (");
                String _javaFQN_5 = this.getJavaFQN((EClassifier)c_1);
                _builder.append(_javaFQN_5, "\t\t\t\t");
                _builder.append(") o;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                String _javaFQN_6 = this.getJavaFQN((EClassifier)traced);
                _builder.append(_javaFQN_6, "\t\t\t\t");
                _builder.append(" traced = (");
                String _javaFQN_7 = this.getJavaFQN((EClassifier)traced);
                _builder.append(_javaFQN_7, "\t\t\t\t");
                _builder.append(") exeToTraced.get(o_cast);");
                _builder.newLineIfNotEmpty();
                EList _eStructuralFeatures = c_1.getEStructuralFeatures();
                for (EStructuralFeature p : _eStructuralFeatures) {
                    _builder.append("\t\t\t");
                    EReference pdimension = this.traceability.getDimensionRef(p);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("newState.getValues().remove(traced.");
                    String _stringGetter = EcoreCraftingUtil.stringGetter((EStructuralFeature)pdimension);
                    _builder.append(_stringGetter, "\t\t\t");
                    _builder.append(".getValues().get(traced.");
                    String _stringGetter_1 = EcoreCraftingUtil.stringGetter((EStructuralFeature)pdimension);
                    _builder.append(_stringGetter_1, "\t\t\t");
                    _builder.append(".getValues().size()-1));");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("\t\t\t");
                _builder.append("}");
                _builder.append("\t\t\t\t\t\t\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.append("\t\t\t\t\t\t\t");
        }
        _builder.newLineIfNotEmpty();
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)mutableClassesWithNonCollectionMutableFields);
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            boolean _not_2;
            _builder.append("\t\t\t");
            _builder.append("// Here we must look at non-collection mutable fields");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// We must rollback the last values from the copied state, and add new values as well");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// ie. mix of remove and new");
            _builder.newLine();
            _builder.append("\t\t\t");
            boolean _isEmpty_2 = newConcreteClassesNotEmpty.isEmpty();
            boolean bl3 = _not_2 = !_isEmpty_2;
            if (_not_2) {
                _builder.append(" else ");
            }
            _builder.append(" if (modelChange instanceof org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NonCollectionFieldModelChange) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("stateChanged = true;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NonCollectionFieldModelChange modelChange_cast = (org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.NonCollectionFieldModelChange) modelChange;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            String _canonicalName = EStructuralFeature.class.getCanonicalName();
            _builder.append(_canonicalName, "\t\t\t\t");
            _builder.append(" p = modelChange_cast.getChangedField();");
            _builder.newLineIfNotEmpty();
            List<EClass> _partialOrderSort_1 = TraceConstructorGeneratorJava.partialOrderSort(mutableClassesWithNonCollectionMutableFields);
            for (EClass c_2 : _partialOrderSort_1) {
                _builder.append("\t\t\t");
                _builder.append("\t");
                Functions.Function1<EStructuralFeature, Boolean> _function_6 = new Functions.Function1<EStructuralFeature, Boolean>(){

                    public Boolean apply(EStructuralFeature p) {
                        boolean _isMany = p.isMany();
                        return !_isMany;
                    }
                };
                Iterable nonCollectionMutableFields = IterableExtensions.filter((Iterable)this.traceability.getMutablePropertiesOf(c_2), (Functions.Function1)_function_6);
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.newLine();
                _builder.append("\t\t\t");
                _builder.append("\t");
                EClass traced_1 = this.traceability.getTracedClass(c_2);
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("if (o instanceof ");
                String _javaFQN_8 = this.getJavaFQN((EClassifier)c_2);
                _builder.append(_javaFQN_8, "\t\t\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("\t");
                String _javaFQN_9 = this.getJavaFQN((EClassifier)c_2);
                _builder.append(_javaFQN_9, "\t\t\t\t\t");
                _builder.append(" o_cast = (");
                String _javaFQN_10 = this.getJavaFQN((EClassifier)c_2);
                _builder.append(_javaFQN_10, "\t\t\t\t\t");
                _builder.append(") o;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.newLine();
                boolean _hasElements = false;
                for (EStructuralFeature p_1 : nonCollectionMutableFields) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)" else ", "\t\t\t\t\t");
                    }
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    EClass valueClass = this.traceability.getValueClass(p_1);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    EReference pdimension_1 = this.traceability.getDimensionRef(p_1);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("if (p.getFeatureID() == ");
                    String _stringFeatureID = this.stringFeatureID(p_1);
                    _builder.append(_stringFeatureID, "\t\t\t\t\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("// Rollback: we remove the last value of this field from the new state");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    String _javaFQN_11 = this.getJavaFQN((EClassifier)traced_1);
                    _builder.append(_javaFQN_11, "\t\t\t\t\t\t");
                    _builder.append(" traced = (");
                    String _javaFQN_12 = this.getJavaFQN((EClassifier)traced_1);
                    _builder.append(_javaFQN_12, "\t\t\t\t\t\t");
                    _builder.append(") exeToTraced.get(o);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    String _javaFQN_13 = this.getJavaFQN((EClassifier)valueClass);
                    _builder.append(_javaFQN_13, "\t\t\t\t\t\t");
                    _builder.append(" lastValue = traced.");
                    String _stringGetter_2 = EcoreCraftingUtil.stringGetter((EStructuralFeature)pdimension_1);
                    _builder.append(_stringGetter_2, "\t\t\t\t\t\t");
                    _builder.append(".getValues().get(traced.");
                    String _stringGetter_3 = EcoreCraftingUtil.stringGetter((EStructuralFeature)pdimension_1);
                    _builder.append(_stringGetter_3, "\t\t\t\t\t\t");
                    _builder.append(".getValues().size()-1);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("newState.getValues().remove(lastValue);");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("// And we create a proper new value");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    String _javaFQN_14 = this.getJavaFQN((EClassifier)valueClass);
                    _builder.append(_javaFQN_14, "\t\t\t\t\t\t");
                    _builder.append(" newValue = ");
                    String _stringCreate_1 = EcoreCraftingUtil.stringCreate((EClass)valueClass);
                    _builder.append(_stringCreate_1, "\t\t\t\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    EStructuralFeature valueProperty = this.traceability.getValuePropertyOfMutableProperty(p_1);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    if (p_1 instanceof EReference && this.shouldHaveAddNewObjectToStateMethod(p_1.getEType())) {
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        String _javaFQN_15 = this.getJavaFQN(valueProperty.getEType());
                        _builder.append(_javaFQN_15, "\t\t\t\t\t\t");
                        _builder.append(" value = null;");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("if (o_cast.");
                        String _stringGetter_4 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_1);
                        _builder.append(_stringGetter_4, "\t\t\t\t\t\t");
                        _builder.append(" != null) {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("addNewObjectToState(o_cast.");
                        String _stringGetter_5 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_1);
                        _builder.append(_stringGetter_5, "\t\t\t\t\t\t\t");
                        _builder.append(", newState);");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("value = ");
                        String _stringGetterTracedValue = this.stringGetterTracedValue("o_cast", p_1);
                        _builder.append(_stringGetterTracedValue, "\t\t\t\t\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                    } else {
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        String _javaFQN_16 = this.getJavaFQN(valueProperty.getEType());
                        _builder.append(_javaFQN_16, "\t\t\t\t\t\t");
                        _builder.append(" value = o_cast.");
                        String _stringGetter_6 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_1);
                        _builder.append(_stringGetter_6, "\t\t\t\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("newValue.");
                    String _stringSetter = this.stringSetter(valueProperty, "value");
                    _builder.append(_stringSetter, "\t\t\t\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("traced.");
                    String _stringGetter_7 = EcoreCraftingUtil.stringGetter((EStructuralFeature)pdimension_1);
                    _builder.append(_stringGetter_7, "\t\t\t\t\t\t");
                    _builder.append(".getValues().add(newValue);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("newState.getValues().add(newValue);");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                }
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.newLine();
        }
        boolean bl4 = _not_3 = !(_isEmpty_3 = IterableExtensions.isEmpty((Iterable)mutableClassesWithCollectionMutableFields));
        if (_not_3) {
            _builder.append("\t\t\t");
            _builder.append("// Here we look at collection mutable fields");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// We must first manually find out if the collection changed...");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("// If it changed we must rollback the last values from the copied state, and add new values as well");
            _builder.newLine();
            _builder.append("\t\t\t");
            if (!newConcreteClassesNotEmpty.isEmpty() || !IterableExtensions.isEmpty((Iterable)mutableClassesWithNonCollectionMutableFields)) {
                _builder.append(" else ");
            }
            _builder.append(" if (modelChange instanceof org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.PotentialCollectionFieldModelChange) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("\t");
            _builder.append("org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.PotentialCollectionFieldModelChange modelChange_cast = (org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.PotentialCollectionFieldModelChange) modelChange;");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("\t");
            String _canonicalName_1 = EStructuralFeature.class.getCanonicalName();
            _builder.append(_canonicalName_1, "\t\t\t\t");
            _builder.append(" p = modelChange_cast.getChangedField();");
            _builder.newLineIfNotEmpty();
            List<EClass> _partialOrderSort_2 = TraceConstructorGeneratorJava.partialOrderSort(mutableClassesWithCollectionMutableFields);
            for (EClass c_3 : _partialOrderSort_2) {
                _builder.append("\t\t\t");
                _builder.append("\t");
                Functions.Function1<EStructuralFeature, Boolean> _function_7 = new Functions.Function1<EStructuralFeature, Boolean>(){

                    public Boolean apply(EStructuralFeature p) {
                        return p.isMany();
                    }
                };
                Iterable collectionMutableFields = IterableExtensions.filter((Iterable)this.traceability.getMutablePropertiesOf(c_3), (Functions.Function1)_function_7);
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                EClass traced_2 = this.traceability.getTracedClass(c_3);
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("if (o instanceof ");
                String _javaFQN_17 = this.getJavaFQN((EClassifier)c_3);
                _builder.append(_javaFQN_17, "\t\t\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("\t");
                String _javaFQN_18 = this.getJavaFQN((EClassifier)c_3);
                _builder.append(_javaFQN_18, "\t\t\t\t\t");
                _builder.append(" o_cast = (");
                String _javaFQN_19 = this.getJavaFQN((EClassifier)c_3);
                _builder.append(_javaFQN_19, "\t\t\t\t\t");
                _builder.append(") o;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("\t");
                String _javaFQN_20 = this.getJavaFQN((EClassifier)traced_2);
                _builder.append(_javaFQN_20, "\t\t\t\t\t");
                _builder.append(" tracedObject = (");
                String _javaFQN_21 = this.getJavaFQN((EClassifier)traced_2);
                _builder.append(_javaFQN_21, "\t\t\t\t\t");
                _builder.append(") exeToTraced.get(o_cast);");
                _builder.newLineIfNotEmpty();
                boolean _hasElements_1 = false;
                for (EStructuralFeature p_2 : collectionMutableFields) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)" else ", "\t\t\t\t\t");
                    }
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    EClass valueClass_1 = this.traceability.getValueClass(p_2);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    EReference pdimension_2 = this.traceability.getDimensionRef(p_2);
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("if (p.getFeatureID() == ");
                    String _stringFeatureID_1 = this.stringFeatureID(p_2);
                    _builder.append(_stringFeatureID_1, "\t\t\t\t\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("// We compare the last collection in the value sequence, and the current one in the potentially changed object");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("List<");
                    String _javaFQN_22 = this.getJavaFQN((EClassifier)valueClass_1);
                    _builder.append(_javaFQN_22, "\t\t\t\t\t\t");
                    _builder.append("> valueSequence = tracedObject.");
                    String _stringGetter_8 = EcoreCraftingUtil.stringGetter((EStructuralFeature)pdimension_2);
                    _builder.append(_stringGetter_8, "\t\t\t\t\t\t");
                    _builder.append(".getValues();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    String _javaFQN_23 = this.getJavaFQN((EClassifier)valueClass_1);
                    _builder.append(_javaFQN_23, "\t\t\t\t\t\t");
                    _builder.append(" previousValue = null;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("if (!valueSequence.isEmpty()) {");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("previousValue = valueSequence.get(valueSequence.size() - 1);");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.newLine();
                    boolean _shouldHaveAddNewObjectToStateMethod = this.shouldHaveAddNewObjectToStateMethod(p_2.getEType());
                    if (_shouldHaveAddNewObjectToStateMethod) {
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("for(");
                        String _javaFQN_24 = this.getJavaFQN(p_2.getEType());
                        _builder.append(_javaFQN_24, "\t\t\t\t\t");
                        _builder.append(" aValue : o_cast.");
                        String _stringGetter_9 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_2);
                        _builder.append(_stringGetter_9, "\t\t\t\t\t");
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("addNewObjectToState((");
                        String _javaFQN_25 = this.getJavaFQN(p_2.getEType());
                        _builder.append(_javaFQN_25, "\t\t\t\t\t\t");
                        _builder.append(")aValue, newState);");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.append("\t\t\t\t\t\t\t\t\t\t");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("boolean change = false;");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("if (previousValue != null) {");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("if (previousValue.");
                    String _stringGetter_10 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_2);
                    _builder.append(_stringGetter_10, "\t\t\t\t\t\t\t");
                    _builder.append(".size() == o_cast");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t\t\t");
                    _builder.append(".");
                    String _stringGetter_11 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_2);
                    _builder.append(_stringGetter_11, "\t\t\t\t\t\t\t\t\t");
                    _builder.append(".size()) {");
                    _builder.newLineIfNotEmpty();
                    boolean _isOrdered = p_2.isOrdered();
                    if (_isOrdered) {
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("java.util.Iterator<");
                        String _javaFQN_26 = this.getJavaFQN(p_2.getEType(), true);
                        _builder.append(_javaFQN_26, "\t\t\t\t\t");
                        _builder.append("> it = o_cast.");
                        String _stringGetter_12 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_2);
                        _builder.append(_stringGetter_12, "\t\t\t\t\t");
                        _builder.append(".iterator();");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("for (");
                        String _tracedJavaFQN = this.getTracedJavaFQN(this.traceability.getValuePropertyOfMutableProperty(p_2).getEType(), true);
                        _builder.append(_tracedJavaFQN, "\t\t\t\t\t");
                        _builder.append(" aPreviousValue : previousValue");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append(".");
                        String _stringGetter_13 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_2);
                        _builder.append(_stringGetter_13, "\t\t\t\t\t\t\t");
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        String _javaFQN_27 = this.getJavaFQN(p_2.getEType());
                        _builder.append(_javaFQN_27, "\t\t\t\t\t\t");
                        _builder.append(" aCurrentValue = it.next();");
                        _builder.newLineIfNotEmpty();
                        if (p_2 instanceof EReference) {
                            _builder.append("\t\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("if (aPreviousValue != exeToTraced.get(aCurrentValue))");
                            _builder.newLine();
                        } else {
                            _builder.append("\t\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("if (!aPreviousValue.equals(aCurrentValue))");
                            _builder.newLine();
                        }
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("{");
                        _builder.newLine();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("change = true;");
                        _builder.newLine();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("break;");
                        _builder.newLine();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("}");
                        _builder.newLine();
                    } else {
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("change = !previousValue.");
                        String _stringGetter_14 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_2);
                        _builder.append(_stringGetter_14, "\t\t\t\t\t");
                        _builder.append(".containsAll(");
                        String _exeToTracedMethodName = this.getExeToTracedMethodName();
                        _builder.append(_exeToTracedMethodName, "\t\t\t\t\t");
                        _builder.append("(o_cast.");
                        String _stringGetter_15 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_2);
                        _builder.append(_stringGetter_15, "\t\t\t\t\t");
                        _builder.append("), newState);");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
                    _builder.append("}");
                    _builder.append("\t\t\t\t\t\t\t\t\t\t\telse {");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t\t");
                    _builder.append("change = true;");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.append("\t\t\t\t\t\t\t\t\t\t} else {");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("change = true;");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.append("\t\t\t\t\t\t\t\t\t\tif (change) {");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("stateChanged = true;");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("// Rollback: we remove the last value of this field from the new state");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    String _javaFQN_28 = this.getJavaFQN((EClassifier)valueClass_1);
                    _builder.append(_javaFQN_28, "\t\t\t\t\t\t\t");
                    _builder.append(" lastValue = tracedObject.");
                    String _stringGetter_16 = EcoreCraftingUtil.stringGetter((EStructuralFeature)pdimension_2);
                    _builder.append(_stringGetter_16, "\t\t\t\t\t\t\t");
                    _builder.append(".getValues().get(tracedObject.");
                    String _stringGetter_17 = EcoreCraftingUtil.stringGetter((EStructuralFeature)pdimension_2);
                    _builder.append(_stringGetter_17, "\t\t\t\t\t\t\t");
                    _builder.append(".getValues().size()-1);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("newState.getValues().remove(lastValue);");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("// And we create a proper new value");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    String _javaFQN_29 = this.getJavaFQN((EClassifier)valueClass_1);
                    _builder.append(_javaFQN_29, "\t\t\t\t\t\t\t");
                    _builder.append(" newValue = ");
                    String _stringCreate_2 = EcoreCraftingUtil.stringCreate((EClass)valueClass_1);
                    _builder.append(_stringCreate_2, "\t\t\t\t\t\t\t");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    EStructuralFeature valueProperty_1 = this.traceability.getValuePropertyOfMutableProperty(p_2);
                    _builder.newLineIfNotEmpty();
                    boolean _isMany = p_2.isMany();
                    if (_isMany) {
                        if (p_2 instanceof EReference) {
                            _builder.append("\t\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t\t");
                            _builder.append("newValue.");
                            String _stringGetter_18 = EcoreCraftingUtil.stringGetter((EStructuralFeature)valueProperty_1);
                            _builder.append(_stringGetter_18, "\t\t\t\t\t\t\t");
                            _builder.append(".addAll");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("((Collection<? extends ");
                            String _tracedJavaFQN_1 = this.getTracedJavaFQN(this.traceability.getValuePropertyOfMutableProperty(p_2).getEType(), true);
                            _builder.append(_tracedJavaFQN_1, "\t\t\t\t\t\t\t\t");
                            _builder.append(">) ");
                            String _exeToTracedMethodName_1 = this.getExeToTracedMethodName();
                            _builder.append(_exeToTracedMethodName_1, "\t\t\t\t\t\t\t\t");
                            _builder.append("(o_cast.");
                            String _stringGetter_19 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_2);
                            _builder.append(_stringGetter_19, "\t\t\t\t\t\t\t\t");
                            _builder.append(", newState));");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("\t\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t\t");
                            _builder.append("newValue.");
                            String _stringGetter_20 = EcoreCraftingUtil.stringGetter((EStructuralFeature)valueProperty_1);
                            _builder.append(_stringGetter_20, "\t\t\t\t\t\t\t");
                            _builder.append(".addAll");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t\t");
                            _builder.append("\t");
                            _builder.append("\t");
                            _builder.append("\t\t");
                            _builder.append("\t");
                            _builder.append("((Collection<? extends ");
                            String _tracedJavaFQN_2 = this.getTracedJavaFQN(this.traceability.getValuePropertyOfMutableProperty(p_2).getEType(), true);
                            _builder.append(_tracedJavaFQN_2, "\t\t\t\t\t\t\t\t");
                            _builder.append(">) o_cast.");
                            String _stringGetter_21 = EcoreCraftingUtil.stringGetter((EStructuralFeature)p_2);
                            _builder.append(_stringGetter_21, "\t\t\t\t\t\t\t\t");
                            _builder.append(");");
                            _builder.newLineIfNotEmpty();
                        }
                    } else {
                        _builder.append("\t\t\t");
                        _builder.append("\t");
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("newValue.");
                        String _stringSetter_1 = this.stringSetter(valueProperty_1, this.stringGetterTracedValue("o_cast", p_2));
                        _builder.append(_stringSetter_1, "\t\t\t\t\t\t\t");
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("tracedObject.");
                    String _stringGetter_22 = EcoreCraftingUtil.stringGetter((EStructuralFeature)pdimension_2);
                    _builder.append(_stringGetter_22, "\t\t\t\t\t\t\t");
                    _builder.append(".getValues().add(newValue);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("newState.getValues().add(newValue);");
                    _builder.newLine();
                    _builder.append("\t\t\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("\t");
                    _builder.append("}");
                    _builder.append("\t\t\t\t\t\t\t\t\t}");
                    _builder.append("\t\t\t\t\t\t\t\t\t");
                }
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("} ");
                _builder.append("\t\t\t\t\t\t\t\t");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("}");
            _builder.append("\t\t\t\t\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.append("\t\t\t\t\t\tif (stateChanged) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("final ");
        _builder.append(this.specificStepFQN, "\t\t\t");
        _builder.append(" currentStep = context.peekFirst();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("if (currentStep != null && currentStep instanceof ");
        String _javaFQN_30 = this.getJavaFQN((EClassifier)TracePackage.eINSTANCE.getBigStep());
        _builder.append(_javaFQN_30, "\t\t\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("final ");
        _builder.append(this.stateFQN, "\t\t\t\t");
        _builder.append(" startingState = lastState;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("final ");
        _builder.append(this.stateFQN, "\t\t\t\t");
        _builder.append(" endingState = newState;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t");
        _builder.append("addImplicitStep(currentStep, startingState, endingState);");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("lastState = newState;");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("traceRoot.getStates().add(lastState);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.append("\t\t\t\t\t\telse if (copiedState) {");
        _builder.newLine();
        Functions.Function1<EStructuralFeature, String> _function_8 = new Functions.Function1<EStructuralFeature, String>(){

            public String apply(EStructuralFeature it) {
                return TraceConstructorGeneratorJava.this.getFQN(it);
            }
        };
        List _sortBy = IterableExtensions.sortBy((Iterable)this.traceability.getAllMutableProperties(), (Functions.Function1)_function_8);
        for (EStructuralFeature p_3 : _sortBy) {
            _builder.append("\t\t\t");
            _builder.append("newState.getValues().clear();");
            _builder.newLine();
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("copiedState = false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.append("\t\t\t\t}");
        _builder.append("\t\t\t");
        return _builder.toString();
    }

    private String generateAddStepMethods() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        EList stepRules = this.traceability.getMmext().getRules();
        _builder.newLineIfNotEmpty();
        _builder.append("@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public void addStep(org.eclipse.gemoc.trace.commons.model.trace.Step<?> step) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(this.specificStepFQN, "\t");
        _builder.append(" step_cast = null;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (step != null && step instanceof ");
        _builder.append(this.specificStepFQN, "\t");
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("step_cast = (");
        _builder.append(this.specificStepFQN, "\t\t");
        _builder.append(") step;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if (mseModel == null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("mseModel = org.eclipse.gemoc.trace.commons.model.trace.TraceFactory.eINSTANCE.createMSEModel();");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("traceResource.getContents().add(mseModel);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("mseModel.getOwnedMSEs().add(step_cast.getMseoccurrence().getMse());");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// Creating generic (or almost generic) links");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append(this.stateFQN, "\t\t");
        _builder.append(" state = traceRoot.getStates().get(traceRoot.getStates().size()-1);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("step_cast.setStartingState(state);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("if (!context.isEmpty() && context.getFirst() != null) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("((SequentialStep<");
        _builder.append(this.specificStepFQN, "\t\t\t");
        _builder.append(", ");
        _builder.append(this.stateFQN, "\t\t\t");
        _builder.append(">) context.getFirst()).getSubSteps().add(step_cast);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("((SequentialStep<");
        _builder.append(this.specificStepFQN, "\t\t\t");
        _builder.append(", ");
        _builder.append(this.stateFQN, "\t\t\t");
        _builder.append(">) traceRoot.getRootStep()).getSubSteps().add(step_cast);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("// Adding step in its dedicated sequence/dimension");
        _builder.newLine();
        boolean _isEmpty = stepRules.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1<Rule, String> _function = new Functions.Function1<Rule, String>(){

                public String apply(Rule it) {
                    return TraceConstructorGeneratorJava.getBaseFQN(it);
                }
            };
            List _sortBy = IterableExtensions.sortBy((Iterable)stepRules, (Functions.Function1)_function);
            boolean _hasElements = false;
            for (Rule stepRule : _sortBy) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"else", "\t\t");
                }
                _builder.append("\t\t");
                EClass stepClass = this.traceability.getStepClassFromStepRule(stepRule);
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                String _replace = StringExtensions.toFirstLower((String)stepClass.getName()).replace(" ", "");
                String varName = String.valueOf(_replace) + "Instance";
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("if (step_cast instanceof ");
                String _javaFQN = this.getJavaFQN((EClassifier)stepClass);
                _builder.append(_javaFQN, "\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                String _javaFQN_1 = this.getJavaFQN((EClassifier)stepClass);
                _builder.append(_javaFQN_1, "\t\t\t");
                _builder.append(" ");
                _builder.append(varName, "\t\t\t");
                _builder.append(" = (");
                String _javaFQN_2 = this.getJavaFQN((EClassifier)stepClass);
                _builder.append(_javaFQN_2, "\t\t\t");
                _builder.append(") step_cast;");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("traceRoot.");
                String _stringGetter = EcoreCraftingUtil.stringGetter((EStructuralFeature)this.traceability.getStepSequence(stepClass));
                _builder.append(_stringGetter, "\t\t\t");
                _builder.append(".add(");
                _builder.append(varName, "\t\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("context.push(step_cast);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append("@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append("private void addImplicitStep(");
        _builder.append(this.specificStepFQN);
        _builder.append(" currentStep,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(this.stateFQN, "\t");
        _builder.append(" startingState,");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(this.stateFQN, "\t");
        _builder.append(" endingState) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        if (!stepRules.isEmpty() && !this.traceability.getBigStepClasses().isEmpty()) {
            _builder.append("\t");
            _builder.append("\t");
            _builder.append(this.specificStepFQN, "\t\t");
            _builder.append(" implicitStep = null;");
            _builder.newLineIfNotEmpty();
            Functions.Function1<EClass, String> _function_1 = new Functions.Function1<EClass, String>(){

                public String apply(EClass it) {
                    return it.getName();
                }
            };
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)this.traceability.getBigStepClasses(), (Functions.Function1)_function_1);
            boolean _hasElements_1 = false;
            for (EClass bigStepClass : _sortBy_1) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)"else", "\t\t");
                }
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("if (currentStep instanceof ");
                String _javaFQN_3 = this.getJavaFQN((EClassifier)bigStepClass);
                _builder.append(_javaFQN_3, "\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("implicitStep = ");
                String _stringCreateImplicitStep = EcoreCraftingUtil.stringCreateImplicitStep((EClass)bigStepClass);
                _builder.append(_stringCreateImplicitStep, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("\t");
            _builder.append("if (implicitStep != null) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("implicitStep.setStartingState(startingState);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("implicitStep.setEndingState(endingState);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("((SequentialStep<");
            _builder.append(this.specificStepFQN, "\t\t");
            _builder.append(", ");
            _builder.append(this.stateFQN, "\t\t");
            _builder.append(">) currentStep).getSubSteps().add(implicitStep);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public void endStep(org.eclipse.gemoc.trace.commons.model.trace.Step<?> step) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(this.specificStepFQN, "\t");
        _builder.append(" popped = context.pop();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("if (popped != null)");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("popped.setEndingState(lastState);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private String generateInitAndSaveTraceMethods() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public EObject initTrace(LaunchConfiguration launchConfiguration) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Create root");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("traceRoot = ");
        String _stringCreate = EcoreCraftingUtil.stringCreate((EClass)this.traceability.getTraceMMExplorer().getSpecificTraceClass());
        _builder.append(_stringCreate, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("traceRoot.setLaunchconfiguration(launchConfiguration);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Create root sequential step");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("org.eclipse.gemoc.trace.commons.model.trace.SequentialStep<");
        _builder.append(this.specificStepFQN, "\t");
        _builder.append(", ");
        _builder.append(this.stateFQN, "\t");
        _builder.append("> rootStep = ");
        String _stringCreate_1 = EcoreCraftingUtil.stringCreate((EClass)this.traceability.getTraceMMExplorer().getSpecificRootStepClass());
        _builder.append(_stringCreate_1, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("traceRoot.setRootStep(rootStep);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// Put in the resource");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("traceResource.getContents().add(traceRoot);");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return traceRoot;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public void save() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("traceResource.save(null);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (java.io.IOException e) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("e.printStackTrace();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("public void save(URI uri) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("try {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("traceResource.setURI(uri);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("traceResource.save(null);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("} catch (java.io.IOException e) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("e.printStackTrace();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private String generateExeToFromTracedGenericMethods() {
        StringConcatenation _builder = new StringConcatenation();
        if (this.getExeToTracedUsed) {
            _builder.append("private Collection<? extends EObject> ");
            String _exeToTracedMethodName = this.getExeToTracedMethodName();
            _builder.append(_exeToTracedMethodName);
            _builder.append("(Collection<? extends EObject> exeObjects, ");
            String _javaFQN = this.getJavaFQN((EClassifier)this.stateClass);
            _builder.append(_javaFQN);
            _builder.append(" newState) {");
            _builder.newLineIfNotEmpty();
            _builder.append("Collection<EObject> result = new ArrayList<EObject>();");
            _builder.newLine();
            _builder.append("for(EObject exeObject : exeObjects) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("result.add(exeToTraced.get(exeObject));");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("}\t");
            _builder.newLine();
        }
        return _builder.toString();
    }

    private String generateTraceConstructorClass() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public class ");
        _builder.append(this.className);
        _builder.append(" implements ITraceConstructor {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateFields = this.generateFields();
        _builder.append(_generateFields, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateConstructor = this.generateConstructor();
        _builder.append(_generateConstructor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateAddInitialStateMethod = this.generateAddInitialStateMethod();
        _builder.append(_generateAddInitialStateMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateAddNewObjectToStateMethods = this.generateAddNewObjectToStateMethods();
        _builder.append(_generateAddNewObjectToStateMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateAddStateUsingListenerMethods = this.generateAddStateUsingListenerMethods();
        _builder.append(_generateAddStateUsingListenerMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateAddStepMethods = this.generateAddStepMethods();
        _builder.append(_generateAddStepMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateInitAndSaveTraceMethods = this.generateInitAndSaveTraceMethods();
        _builder.append(_generateInitAndSaveTraceMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateGetAllResourcesMethod = this.generateGetAllResourcesMethod();
        _builder.append(_generateGetAllResourcesMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _generateExeToFromTracedGenericMethods = this.generateExeToFromTracedGenericMethods();
        _builder.append(_generateExeToFromTracedGenericMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean isPartialTraceConstructor() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return false;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        String body = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("package ");
        _builder_1.append(this.packageQN);
        _builder_1.append(";");
        _builder_1.newLineIfNotEmpty();
        _builder_1.newLine();
        String _generateImports = this.generateImports();
        _builder_1.append(_generateImports);
        _builder_1.newLineIfNotEmpty();
        _builder_1.newLine();
        _builder_1.append(body);
        _builder_1.newLineIfNotEmpty();
        return _builder_1.toString();
    }
}

