/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.ui.utils;

import fr.inria.diverse.melange.metamodel.melange.Import;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.Operator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public class XDSMLProjectHelper {
    public static String baseProjectName(IProject xdsmlProject) {
        return XDSMLProjectHelper.baseProjectName(xdsmlProject.getName());
    }

    public static String baseProjectName(String xdsmlProjectName) {
        int index = xdsmlProjectName.indexOf(".xdsml");
        if (index != -1) {
            return xdsmlProjectName.substring(0, index);
        }
        index = xdsmlProjectName.indexOf(".dsml");
        if (index != -1) {
            return xdsmlProjectName.substring(0, index);
        }
        return xdsmlProjectName;
    }

    public static String getFirstEcorePath(Language language) {
        Import firstImport = null;
        for (Operator op : language.getOperators()) {
            if (!(op instanceof Import)) continue;
            firstImport = (Import)op;
            break;
        }
        if (firstImport != null) {
            return firstImport.getEcoreUri();
        }
        return null;
    }

    public static IFile getFirstEcore(Language lang) {
        String ecoreURI = XDSMLProjectHelper.getFirstEcorePath(lang);
        if (ecoreURI != null) {
            URI uri = URI.createURI((String)ecoreURI);
            String filePath = uri.toPlatformString(true);
            Path path = new Path(filePath);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }
}

