/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.emf.validation.validity.ui.view;

import java.lang.reflect.Method;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.examples.emf.validation.validity.ResultConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.ResultValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.RootNode;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.CollapseAllNodesAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.DebugValidityAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.DisableAllUnusedNodesAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.EnableDisableAllNodesAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.ExpandAllNodesAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.ExportValidationResultAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.FilterValidationResultAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.ForceValidityViewRefreshAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.LockValidatableNodesAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.RunValidityAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.actions.ShowElementInEditorAction;
import org.eclipse.ocl.examples.emf.validation.validity.ui.messages.ValidityUIMessages;
import org.eclipse.ocl.examples.emf.validation.validity.ui.providers.ConstrainingNodeContentProvider;
import org.eclipse.ocl.examples.emf.validation.validity.ui.providers.NodeCheckStateProvider;
import org.eclipse.ocl.examples.emf.validation.validity.ui.providers.NodeLabelProvider;
import org.eclipse.ocl.examples.emf.validation.validity.ui.providers.ValidatableNodeContentProvider;
import org.eclipse.ocl.examples.emf.validation.validity.ui.ripoffs.DecoratingColumnLabelProvider;
import org.eclipse.ocl.examples.emf.validation.validity.ui.ripoffs.FilteredCheckboxTree;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.FormMessageManager;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.IDEValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.SelectionUtil;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.SeveritiesDecorator;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityNodeCheckStateListener;
import org.eclipse.ocl.examples.emf.validation.validity.ui.view.ValidityViewRefreshJob;
import org.eclipse.ocl.examples.emf.validation.validity.utilities.IVisibilityFilter;
import org.eclipse.ocl.examples.ui.OCLPropertyTester;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.ViewPart;

public class ValidityView
extends ViewPart
implements ISelectionListener {
    public static final @NonNull String ID = "org.eclipse.ocl.examples.emf.validation.validity.ui.validity";
    private static OCLPropertyTester ensureViewsIdIsreferenced = null;
    protected FilteredCheckboxTree filteredValidatableNodesTree;
    protected FilteredCheckboxTree filteredConstrainingNodesTree;
    private final @NonNull ValidityViewRefreshJob refreshJob = new ValidityViewRefreshJob();
    protected final @NonNull IDEValidityManager validityManager = new IDEValidityManager(this.refreshJob);
    private FormToolkit formToolkit;
    private Form validityViewForm;
    private FormMessageManager messageManager;
    private SashForm validateableElementsForm;
    private SashForm constrainingElementsForm;
    private SashForm formBody;
    private Section validatableNodesSection;
    private final String messageKey = "ValidityViewMessageKey";
    private int messageCount;
    private Section constrainingNodesSection;
    protected ResourceSet modelResourceSet = new ResourceSetImpl();
    private ShowElementInEditorAction showValidatableElementInEditorAction;
    private ShowElementInEditorAction showConstrainingElementInEditorAction;
    private Action expandAllNodesAction;
    private Action collapseAllNodesAction;
    private Action runValidationAction;
    private Action runValidatableAction;
    private Action runConstrainingAction;
    private Action debugValidatableResultAction;
    private Action debugConstrainingResultAction;
    private Action lockValidatableNodesAction;
    private Action forceValidityViewRefreshAction;
    private Action exportValidationResultAction;
    private IAction filterValidationResultAction;
    private Action expandAllValidatableNodesAction;
    private Action collapseAllValidatableNodesAction;
    private Action enableAllValidatableNodesAction;
    private Action disableAllValidatableNodesAction;
    private DisableAllUnusedNodesAction disableAllUnusedValidatableNodesAction;
    private Action expandAllConstrainingNodesAction;
    private Action collapseAllConstrainingNodesAction;
    private Action enableAllConstrainingNodesAction;
    private Action disableAllConstrainingNodesAction;
    private DisableAllUnusedNodesAction disableAllUnusedConstrainingNodesAction;
    private Action constrainingNodesDoubleClickAction;
    private Action validatableNodesDoubleClickAction;
    private @Nullable IWorkbenchPart currentPart;
    private @Nullable ISelection currentSelection;
    private @Nullable Notifier selection = null;
    private @Nullable ChangeSelectionJob setInputJob = null;

    public void addFilter(boolean isValidatableFilterAction, @NonNull IVisibilityFilter filter) {
        if (isValidatableFilterAction) {
            this.validityManager.addValidatableFilter(filter);
        } else {
            this.validityManager.addConstrainingFilter(filter);
        }
        this.redraw();
    }

    public void addFilteredSeverity(@NonNull Severity severity) {
        this.validityManager.addFilteredSeverity(severity);
        this.redraw();
    }

    private void contributeToActionBars() {
        IToolBarManager toolBarManager = this.getForm().getToolBarManager();
        this.fillLocalToolBar(toolBarManager);
        ToolBarManager validatableSectionToolBarManager = ValidityView.createSectionToolBar(this.validatableNodesSection);
        this.fillValidatableColumnToolBar((IContributionManager)validatableSectionToolBarManager);
        ToolBarManager constrainingSectionToolBarManager = ValidityView.createSectionToolBar(this.constrainingNodesSection);
        this.fillConstrainingColumnToolBar((IContributionManager)constrainingSectionToolBarManager);
    }

    protected static final ToolBarManager createSectionToolBar(Section section) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        final ToolBar toolBar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(handCursor);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        section.setTextClient((Control)toolBar);
        toolBar.setData((Object)toolBarManager);
        toolBar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                toolBar.setData(null);
            }
        });
        return toolBarManager;
    }

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 256);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        sash.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 1;
        sash.setLayoutData((Object)gridData);
        this.formToolkit = new FormToolkit(sash.getDisplay());
        this.createValidityViewForm(this.formToolkit, (Composite)sash);
    }

    protected void createValidityViewForm(FormToolkit toolkit, Composite parent) {
        Color blackColor = parent.getDisplay().getSystemColor(2);
        Color blueColor = parent.getDisplay().getSystemColor(9);
        ValidityViewLabelProvider labelProvider = new ValidityViewLabelProvider(this.validityManager.getAdapterFactory());
        NodeLabelProvider nodeLabelProvider = new NodeLabelProvider((ILabelProvider)labelProvider, blackColor, blueColor);
        ValidatableNodeContentProvider validatableContentProvider = new ValidatableNodeContentProvider(this.validityManager);
        ConstrainingNodeContentProvider constrainingNodeContentProvider = new ConstrainingNodeContentProvider(this.validityManager);
        NodeCheckStateProvider nodeCheckStateProvider = new NodeCheckStateProvider();
        DecoratingNodeLabelProvider nodeDecoratingLabelProvider = new DecoratingNodeLabelProvider((ILabelProvider)nodeLabelProvider);
        this.validityViewForm = toolkit.createForm(parent);
        this.messageManager = new FormMessageManager(this.getForm());
        this.messageManager.setDecorationPosition(16512);
        toolkit.decorateFormHeading(this.getForm());
        this.getForm().setText(ValidityUIMessages.ValidityView_viewTitle);
        this.messageManager.addMessage("ValidityViewMessageKey" + this.messageCount++, ValidityUIMessages.ValidityView_Messages_NoSelection, 2, (Control)this.getForm());
        Composite mainBody = this.getForm().getBody();
        mainBody.setLayout((Layout)new GridLayout());
        this.formBody = new SashForm(mainBody, 65792);
        toolkit.adapt((Composite)this.formBody);
        this.formBody.setLayoutData((Object)new GridData(1808));
        this.validateableElementsForm = new SashForm((Composite)this.formBody, 66048);
        toolkit.adapt((Composite)this.validateableElementsForm);
        this.validatableNodesSection = toolkit.createSection((Composite)this.validateableElementsForm, 256);
        this.validatableNodesSection.setText(ValidityUIMessages.ValidityView_validatableNodesSectionName);
        Composite validatableNodesSectionBody = toolkit.createComposite((Composite)this.validatableNodesSection);
        GridLayout layout = new GridLayout(1, true);
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        validatableNodesSectionBody.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        validatableNodesSectionBody.setLayoutData((Object)gridData);
        PatternFilter filter = new PatternFilter();
        this.filteredValidatableNodesTree = new FilteredCheckboxTree(validatableNodesSectionBody, 268436258, filter);
        this.filteredValidatableNodesTree.disableTextWidget();
        this.filteredValidatableNodesTree.getViewer().setUseHashlookup(true);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.filteredValidatableNodesTree.setLayoutData(gridData);
        CheckboxTreeViewer validatableNodesViewer = this.getValidatableNodesViewer();
        validatableNodesViewer.getControl().setLayoutData((Object)gridData);
        toolkit.paintBordersFor(validatableNodesSectionBody);
        this.validatableNodesSection.setClient((Control)validatableNodesSectionBody);
        this.constrainingElementsForm = new SashForm((Composite)this.formBody, 66048);
        toolkit.adapt((Composite)this.constrainingElementsForm);
        this.constrainingNodesSection = toolkit.createSection((Composite)this.constrainingElementsForm, 256);
        this.constrainingNodesSection.setText(ValidityUIMessages.ValidityView_constrainingNodesSectionName);
        Composite constrainingNodesSectionBody = toolkit.createComposite((Composite)this.constrainingNodesSection);
        GridLayout layout2 = new GridLayout(1, true);
        layout2.marginBottom = 0;
        layout2.marginLeft = 0;
        layout2.marginRight = 0;
        layout2.marginTop = 0;
        constrainingNodesSectionBody.setLayout((Layout)layout2);
        GridData gridData2 = new GridData(1808);
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        constrainingNodesSectionBody.setLayoutData((Object)gridData2);
        PatternFilter filter2 = new PatternFilter();
        this.filteredConstrainingNodesTree = new FilteredCheckboxTree(constrainingNodesSectionBody, 268436258, filter2);
        this.filteredConstrainingNodesTree.disableTextWidget();
        this.filteredConstrainingNodesTree.getViewer().setUseHashlookup(true);
        gridData2 = new GridData(1808);
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        this.filteredConstrainingNodesTree.setLayoutData(gridData2);
        CheckboxTreeViewer constrainingNodesViewer = this.getConstrainingNodesViewer();
        constrainingNodesViewer.getControl().setLayoutData((Object)gridData2);
        toolkit.paintBordersFor(constrainingNodesSectionBody);
        this.constrainingNodesSection.setClient((Control)constrainingNodesSectionBody);
        ValidityNodeCheckStateListener nodeCheckStateListener = new ValidityNodeCheckStateListener(this);
        validatableNodesViewer.setContentProvider((IContentProvider)validatableContentProvider);
        validatableNodesViewer.setLabelProvider((IBaseLabelProvider)nodeDecoratingLabelProvider);
        validatableNodesViewer.setCheckStateProvider((ICheckStateProvider)nodeCheckStateProvider);
        validatableNodesViewer.addCheckStateListener((ICheckStateListener)nodeCheckStateListener);
        constrainingNodesViewer.setContentProvider((IContentProvider)constrainingNodeContentProvider);
        constrainingNodesViewer.setLabelProvider((IBaseLabelProvider)nodeDecoratingLabelProvider);
        constrainingNodesViewer.setCheckStateProvider((ICheckStateProvider)nodeCheckStateProvider);
        constrainingNodesViewer.addCheckStateListener((ICheckStateListener)nodeCheckStateListener);
        this.formBody.setWeights(new int[]{1, 1});
        this.makeActions();
        this.hookContextMenu();
        this.hookConstrainingNodesDoubleClickAction();
        this.hookValidatableNodesDoubleClickAction();
        this.contributeToActionBars();
        IWorkbenchPage page = this.getSite().getPage();
        assert (page != null);
        ISelectionService service = (ISelectionService)this.getSite().getService(ISelectionService.class);
        if (service != null) {
            IEditorPart activeEditor = page.getActiveEditor();
            service.addSelectionListener((ISelectionListener)this);
            ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
            if (selectionProvider == null && activeEditor != null) {
                selectionProvider = activeEditor.getSite().getSelectionProvider();
            }
            if (selectionProvider != null) {
                ISelection selectionFromProvider = selectionProvider.getSelection();
                this.selectionChanged((IWorkbenchPart)activeEditor, selectionFromProvider);
            }
        }
        this.refreshJob.initViewers(this, validatableNodesViewer, constrainingNodesViewer);
        Dialog.applyDialogFont((Control)parent);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)validatableNodesViewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)constrainingNodesViewer);
    }

    public @Nullable IResource getSelectedResource() {
        Object selection = null;
        ISelection currentSelection2 = this.currentSelection;
        if (currentSelection2 != null && (selection = SelectionUtil.getNotifierSelection(currentSelection2, this.currentPart)) == null && currentSelection2 instanceof IStructuredSelection) {
            selection = ((IStructuredSelection)currentSelection2).getFirstElement();
        }
        if (selection != null) {
            URI resourceURI;
            if (selection instanceof IAdaptable) {
                IAdaptable selection2 = (IAdaptable)selection;
                Object adapted = ClassUtil.getAdapter((IAdaptable)selection2, EObject.class);
                if (adapted == null && (adapted = ClassUtil.getAdapter((IAdaptable)selection2, Resource.class)) == null) {
                    adapted = ClassUtil.getAdapter((IAdaptable)selection2, IResource.class);
                }
                if (adapted != null) {
                    selection = adapted;
                }
            }
            if (selection instanceof EObject) {
                selection = ((EObject)selection).eResource();
            }
            if (selection instanceof Resource && (resourceURI = ((Resource)selection).getURI()) != null && resourceURI.isPlatform()) {
                Path resourcePath = new Path(resourceURI.toPlatformString(true));
                selection = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)resourcePath);
            }
        }
        return selection instanceof IResource ? (IResource)selection : null;
    }

    protected Form getForm() {
        return this.validityViewForm;
    }

    public void dispose() {
        ISelectionService service = (ISelectionService)this.getSite().getService(ISelectionService.class);
        if (service != null) {
            service.removeSelectionListener((ISelectionListener)this);
        }
        this.filteredValidatableNodesTree.dispose();
        this.filteredConstrainingNodesTree.dispose();
        super.dispose();
    }

    private void fillConstrainingColumnToolBar(IContributionManager manager) {
        manager.add((IAction)this.expandAllConstrainingNodesAction);
        manager.add((IAction)this.collapseAllConstrainingNodesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.enableAllConstrainingNodesAction);
        manager.add((IAction)this.disableAllConstrainingNodesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.disableAllUnusedConstrainingNodesAction);
        manager.update(true);
    }

    private void fillConstrainingContextMenu(@NonNull IContributionManager manager) {
        manager.add((IAction)this.expandAllConstrainingNodesAction);
        manager.add((IAction)this.collapseAllConstrainingNodesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.enableAllConstrainingNodesAction);
        manager.add((IAction)this.disableAllConstrainingNodesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.disableAllUnusedConstrainingNodesAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.runConstrainingAction);
        manager.add((IAction)this.debugConstrainingResultAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showConstrainingElementInEditorAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.expandAllNodesAction);
        manager.add((IAction)this.collapseAllNodesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.lockValidatableNodesAction);
        manager.add((IAction)this.forceValidityViewRefreshAction);
        manager.add((IAction)this.runValidationAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.filterValidationResultAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.exportValidationResultAction);
        manager.update(true);
    }

    private void fillValidatableColumnToolBar(IContributionManager manager) {
        manager.add((IAction)this.expandAllValidatableNodesAction);
        manager.add((IAction)this.collapseAllValidatableNodesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.enableAllValidatableNodesAction);
        manager.add((IAction)this.disableAllValidatableNodesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.disableAllUnusedValidatableNodesAction);
        manager.update(true);
    }

    private void fillValidatableContextMenu(@NonNull IContributionManager manager) {
        manager.add((IAction)this.expandAllValidatableNodesAction);
        manager.add((IAction)this.collapseAllValidatableNodesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.enableAllValidatableNodesAction);
        manager.add((IAction)this.disableAllValidatableNodesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.disableAllUnusedValidatableNodesAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.runValidatableAction);
        manager.add((IAction)this.debugValidatableResultAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showValidatableElementInEditorAction);
    }

    public @NonNull CheckboxTreeViewer getConstrainingNodesViewer() {
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.filteredConstrainingNodesTree.getViewer();
        assert (viewer != null);
        return viewer;
    }

    public @NonNull IDEValidityManager getValidityManager() {
        return this.validityManager;
    }

    public @NonNull CheckboxTreeViewer getValidatableNodesViewer() {
        CheckboxTreeViewer viewer = (CheckboxTreeViewer)this.filteredValidatableNodesTree.getViewer();
        assert (viewer != null);
        return viewer;
    }

    private void hookContextMenu() {
        MenuManager menuMgrValidatable = new MenuManager("#PopupMenu");
        menuMgrValidatable.setRemoveAllWhenShown(true);
        menuMgrValidatable.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                @NonNull IMenuManager manager2 = manager;
                ValidityView.this.fillValidatableContextMenu((IContributionManager)manager2);
            }
        });
        Menu menuValidatable = menuMgrValidatable.createContextMenu(this.getValidatableNodesViewer().getControl());
        this.getValidatableNodesViewer().getControl().setMenu(menuValidatable);
        this.getSite().registerContextMenu(menuMgrValidatable, (ISelectionProvider)this.getValidatableNodesViewer());
        MenuManager menuMgrConstraining = new MenuManager("#PopupMenu");
        menuMgrConstraining.setRemoveAllWhenShown(true);
        menuMgrConstraining.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                @NonNull IMenuManager manager2 = manager;
                ValidityView.this.fillConstrainingContextMenu((IContributionManager)manager2);
            }
        });
        Menu menuConstraining = menuMgrConstraining.createContextMenu(this.getConstrainingNodesViewer().getControl());
        this.getConstrainingNodesViewer().getControl().setMenu(menuConstraining);
        this.getSite().registerContextMenu(menuMgrConstraining, (ISelectionProvider)this.getConstrainingNodesViewer());
    }

    private void hookConstrainingNodesDoubleClickAction() {
        this.getConstrainingNodesViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ValidityView.this.constrainingNodesDoubleClickAction.run();
            }
        });
    }

    private void hookValidatableNodesDoubleClickAction() {
        this.getValidatableNodesViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ValidityView.this.validatableNodesDoubleClickAction.run();
            }
        });
    }

    protected void initializeFilters() {
        this.disableAllUnusedConstrainingNodesAction.refreshChecked();
        this.disableAllUnusedValidatableNodesAction.refreshChecked();
    }

    private void makeActions() {
        this.lockValidatableNodesAction = new LockValidatableNodesAction();
        this.forceValidityViewRefreshAction = new ForceValidityViewRefreshAction(this.validityManager, this);
        this.showValidatableElementInEditorAction = new ShowElementInEditorAction(this.validityManager, (ISelectionProvider)this.getValidatableNodesViewer());
        this.showConstrainingElementInEditorAction = new ShowElementInEditorAction(this.validityManager, (ISelectionProvider)this.getConstrainingNodesViewer());
        this.expandAllNodesAction = new ExpandAllNodesAction(this, true, true);
        this.collapseAllNodesAction = new CollapseAllNodesAction(this, true, true);
        this.runValidationAction = new RunValidityAction(this, null);
        this.runValidatableAction = new RunValidityAction(this, (ISelectionProvider)this.getValidatableNodesViewer());
        this.runConstrainingAction = new RunValidityAction(this, (ISelectionProvider)this.getConstrainingNodesViewer());
        this.debugValidatableResultAction = new DebugValidityAction(this, (ISelectionProvider)this.getValidatableNodesViewer());
        this.debugConstrainingResultAction = new DebugValidityAction(this, (ISelectionProvider)this.getConstrainingNodesViewer());
        this.exportValidationResultAction = new ExportValidationResultAction(this.validityManager, this);
        this.filterValidationResultAction = new FilterValidationResultAction(this);
        this.expandAllValidatableNodesAction = new ExpandAllNodesAction(this, true, false);
        this.collapseAllValidatableNodesAction = new CollapseAllNodesAction(this, true, false);
        this.enableAllValidatableNodesAction = new EnableDisableAllNodesAction(this, true, true);
        this.disableAllValidatableNodesAction = new EnableDisableAllNodesAction(this, false, true);
        this.disableAllUnusedValidatableNodesAction = new DisableAllUnusedNodesAction(this, true);
        this.expandAllConstrainingNodesAction = new ExpandAllNodesAction(this, false, true);
        this.collapseAllConstrainingNodesAction = new CollapseAllNodesAction(this, false, true);
        this.enableAllConstrainingNodesAction = new EnableDisableAllNodesAction(this, true, false);
        this.disableAllConstrainingNodesAction = new EnableDisableAllNodesAction(this, false, false);
        this.disableAllUnusedConstrainingNodesAction = new DisableAllUnusedNodesAction(this, false);
        this.constrainingNodesDoubleClickAction = new Action(){

            public void run() {
                ISelection selection = ValidityView.this.getConstrainingNodesViewer().getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof ResultConstrainingNode) {
                    ResultValidatableNode resultValidatableNode = ((ResultConstrainingNode)obj).getResultValidatableNode();
                    ValidityView.this.getValidatableNodesViewer().setSelection((ISelection)new StructuredSelection((Object)resultValidatableNode), true);
                }
            }
        };
        this.validatableNodesDoubleClickAction = new Action(){

            public void run() {
                ISelection selection = ValidityView.this.getValidatableNodesViewer().getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof ResultValidatableNode) {
                    ResultConstrainingNode resultConstrainingNode = ((ResultValidatableNode)obj).getResultConstrainingNode();
                    ValidityView.this.getConstrainingNodesViewer().setSelection((ISelection)new StructuredSelection((Object)resultConstrainingNode), true);
                }
            }
        };
    }

    public synchronized void redraw() {
        this.validityManager.redraw();
    }

    public void removeFilter(boolean isValidatableFilterAction, @NonNull IVisibilityFilter filter) {
        if (isValidatableFilterAction) {
            this.validityManager.removeValidatableFilter(filter);
        } else {
            this.validityManager.removeConstrainingFilter(filter);
        }
        this.redraw();
    }

    public void removeFilteredSeverity(@NonNull Severity severity) {
        this.validityManager.removeFilteredSeverity(severity);
        this.redraw();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.currentPart = part;
        this.currentSelection = selection;
        if (this.lockValidatableNodesAction.isChecked()) {
            return;
        }
        if (part instanceof EditorPart) {
            ResourceSet resourceSet;
            Resource resource;
            Notifier input = SelectionUtil.getNotifierSelection(selection, part);
            if (input instanceof EObject && (resource = ((EObject)input).eResource()) != null) {
                input = resource;
            }
            if (input instanceof Resource && (resourceSet = ((Resource)input).getResourceSet()) != null) {
                input = resourceSet;
            }
            this.setSelection(input);
        }
    }

    protected synchronized void setSelection(Notifier newSelection) {
        if (newSelection != this.selection) {
            this.selection = newSelection;
            ChangeSelectionJob oldJob = this.setInputJob;
            ChangeSelectionJob newJob = this.setInputJob = new ChangeSelectionJob(newSelection);
            if (oldJob != null) {
                oldJob.cancelThenSchedule(newJob);
            } else {
                newJob.schedule();
            }
        }
    }

    private void validationRootChanged(RootNode rootNode) {
        this.messageManager.removeMessages((Control)this.getForm());
        String currentMessagekey = null;
        String currentMessageText = null;
        int currentStatus = 0;
        if (rootNode != null) {
            if (rootNode.getValidatableNodes().isEmpty()) {
                this.filteredValidatableNodesTree.disableTextWidget();
                currentMessagekey = "ValidityViewMessageKey" + this.messageCount++;
                currentMessageText = ValidityUIMessages.ValidityView_Messages_NoModelElement;
                currentStatus = 1;
            } else {
                this.filteredValidatableNodesTree.enableTextWidget();
            }
            if (rootNode.getConstrainingNodes().isEmpty()) {
                this.filteredConstrainingNodesTree.disableTextWidget();
                currentMessagekey = "ValidityViewMessageKey" + this.messageCount++;
                currentMessageText = ValidityUIMessages.ValidityView_Messages_NoConstraints;
                currentStatus = 2;
            } else {
                this.filteredConstrainingNodesTree.enableTextWidget();
            }
        } else {
            this.filteredValidatableNodesTree.disableTextWidget();
            this.filteredConstrainingNodesTree.disableTextWidget();
            currentMessagekey = "ValidityViewMessageKey" + this.messageCount++;
            currentMessageText = ValidityUIMessages.ValidityView_Messages_NoSelection;
            currentStatus = 2;
        }
        if (currentMessagekey != null) {
            this.messageManager.addMessage(currentMessagekey, currentMessageText, currentStatus, (Control)this.getForm());
        }
    }

    public void setFocus() {
        this.getValidatableNodesViewer().getControl().setFocus();
        this.filteredValidatableNodesTree.resetFilter();
        this.filteredConstrainingNodesTree.resetFilter();
    }

    protected class ChangeSelectionJob
    extends Job {
        private final @Nullable Notifier newSelection;
        private @Nullable ChangeSelectionJob replacementJob;

        protected ChangeSelectionJob(Notifier newSelection) {
            super("Validity View: Change Selection");
            this.replacementJob = null;
            this.newSelection = newSelection;
        }

        public synchronized void cancelThenSchedule(@NonNull ChangeSelectionJob newJob) {
            this.replacementJob = newJob;
            this.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IStatus iStatus;
            assert (monitor != null);
            try {
                final @NonNull Monitor emfMonitor = BasicMonitor.toMonitor((IProgressMonitor)monitor);
                ValidityView.this.validityManager.setInput(this.newSelection, emfMonitor);
                if (!monitor.isCanceled()) {
                    Form form;
                    ValidityView.this.initializeFilters();
                    ValidityModel model = ValidityView.this.validityManager.getModel();
                    if (model != null) {
                        model.refreshModel(null, null);
                    }
                    if (!(form = ValidityView.this.getForm()).isDisposed()) {
                        form.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                RootNode rootNode = ((ChangeSelectionJob)ChangeSelectionJob.this).ValidityView.this.validityManager.getRootNode();
                                Object validatableNodesViewerInput = ValidityView.this.getValidatableNodesViewer().getInput();
                                if (validatableNodesViewerInput == null || !validatableNodesViewerInput.equals(rootNode)) {
                                    if (!emfMonitor.isCanceled()) {
                                        ValidityView.this.getValidatableNodesViewer().setInput((Object)rootNode);
                                    }
                                    if (!emfMonitor.isCanceled()) {
                                        ValidityView.this.getConstrainingNodesViewer().setInput((Object)rootNode);
                                    }
                                    if (!emfMonitor.isCanceled()) {
                                        ((ChangeSelectionJob)ChangeSelectionJob.this).ValidityView.this.filteredValidatableNodesTree.resetFilter();
                                        ((ChangeSelectionJob)ChangeSelectionJob.this).ValidityView.this.filteredConstrainingNodesTree.resetFilter();
                                        ValidityView.this.validationRootChanged(rootNode);
                                    }
                                }
                            }
                        });
                    }
                }
                iStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
            catch (Throwable throwable) {
                monitor.done();
                ChangeSelectionJob changeSelectionJob = this;
                synchronized (changeSelectionJob) {
                    ValidityView.this.setInputJob = null;
                    ChangeSelectionJob replacementJob2 = this.replacementJob;
                    if (replacementJob2 != null) {
                        replacementJob2.schedule();
                    }
                }
                throw throwable;
            }
            monitor.done();
            ChangeSelectionJob changeSelectionJob = this;
            synchronized (changeSelectionJob) {
                ValidityView.this.setInputJob = null;
                ChangeSelectionJob replacementJob2 = this.replacementJob;
                if (replacementJob2 != null) {
                    replacementJob2.schedule();
                }
            }
            return iStatus;
        }
    }

    class DecoratingNodeLabelProvider
    extends DecoratingColumnLabelProvider {
        public DecoratingNodeLabelProvider(ILabelProvider nodeLabelProvider) {
            super(nodeLabelProvider, new SeveritiesDecorator(ValidityView.this.validityManager));
            this.cellLabelProvider = (CellLabelProvider)nodeLabelProvider;
        }
    }

    public static class ValidityViewLabelProvider
    extends AdapterFactoryLabelProvider {
        public ValidityViewLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        protected Image getDefaultImage(Object object) {
            Object image = null;
            if (object instanceof Method) {
                image = EcoreEditPlugin.INSTANCE.getImage("full/obj16/EOperation");
            }
            if (image != null) {
                return ExtendedImageRegistry.INSTANCE.getImage(image);
            }
            return super.getDefaultImage(object);
        }
    }
}

