/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.aql.business.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.IQueryValidationEngine;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.query.runtime.QueryParsing;
import org.eclipse.acceleo.query.runtime.QueryValidation;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.acceleo.aql.business.AQLSiriusPlugin;
import org.eclipse.sirius.common.acceleo.aql.business.Messages;
import org.eclipse.sirius.common.acceleo.aql.business.api.ExpressionTrimmer;
import org.eclipse.sirius.common.acceleo.aql.business.api.TypesUtil;
import org.eclipse.sirius.common.acceleo.aql.business.internal.AcceleoAbstractInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.ClassLoadingCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EPackageLoadingCallback;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterWithDiagnostic;
import org.eclipse.sirius.common.tools.api.interpreter.IJavaAwareInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.InterpreterStatusFactory;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.ecore.extender.business.api.accessor.EcoreMetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public class AQLSiriusInterpreter
extends AcceleoAbstractInterpreter
implements IJavaAwareInterpreter {
    private LoadingCache<String, IQueryBuilderEngine.AstResult> parsedExpressions;
    private IQueryEnvironment queryEnvironment;
    private ECrossReferenceAdapter siriusXref;
    private CrossReferenceProvider xRef = new CrossReferenceProvider(){

        public Collection<EStructuralFeature.Setting> getInverseReferences(EObject self) {
            if (AQLSiriusInterpreter.this.siriusXref != null) {
                return AQLSiriusInterpreter.this.siriusXref.getInverseReferences(self);
            }
            return Collections.emptySet();
        }
    };
    private final ClassLoadingCallback callback = new ClassLoadingCallback(){

        public void loaded(String qualifiedName, Class<?> clazz) {
            ServiceUtils.registerServices((IQueryEnvironment)AQLSiriusInterpreter.this.queryEnvironment, (Set)ServiceUtils.getServices((IReadOnlyQueryEnvironment)AQLSiriusInterpreter.this.queryEnvironment, clazz));
        }

        public void notFound(String qualifiedName) {
            AQLSiriusPlugin.INSTANCE.log(new Status(2, AQLSiriusPlugin.INSTANCE.getSymbolicName(), MessageFormat.format(Messages.AQLInterpreter_javaClassNotFound, qualifiedName)));
        }

        public void unloaded(String qualifiedName, Class<?> clazz) {
            ServiceUtils.removeServices((IQueryEnvironment)AQLSiriusInterpreter.this.queryEnvironment, (Set)ServiceUtils.getServices((IReadOnlyQueryEnvironment)AQLSiriusInterpreter.this.queryEnvironment, clazz));
        }
    };
    private final EPackageLoadingCallback ePackageCallBack;

    public AQLSiriusInterpreter() {
        this.queryEnvironment = Query.newEnvironmentWithDefaultServices((CrossReferenceProvider)this.xRef);
        this.ePackageCallBack = new EPackageLoadingCallback(){

            public void loaded(String nsURI, EPackage pak) {
                AQLSiriusInterpreter.this.queryEnvironment.registerEPackage(pak);
            }

            public void unloaded(String nsURI, EPackage pak) {
                AQLSiriusInterpreter.this.queryEnvironment.removeEPackage(pak.getName());
            }
        };
        this.javaExtensions.addClassLoadingCallBack(this.callback);
        this.javaExtensions.addEPackageCallBack(this.ePackageCallBack);
        this.queryEnvironment.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        this.queryEnvironment.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        this.initExpressionsCache();
    }

    private void initExpressionsCache() {
        final IQueryBuilderEngine builder = QueryParsing.newBuilder((IQueryEnvironment)this.queryEnvironment);
        this.parsedExpressions = CacheBuilder.newBuilder().maximumSize(500L).build((CacheLoader)new CacheLoader<String, IQueryBuilderEngine.AstResult>(){

            public IQueryBuilderEngine.AstResult load(String key) throws Exception {
                return builder.build(key);
            }
        });
    }

    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
        LinkedHashSet<EPackage> additionalEPackages = new LinkedHashSet<EPackage>();
        for (MetamodelDescriptor descriptor : metamodels) {
            EPackage pkg;
            if (!(descriptor instanceof EcoreMetamodelDescriptor) || (pkg = ((EcoreMetamodelDescriptor)descriptor).resolve()) == null) continue;
            additionalEPackages.add(pkg);
        }
        for (EPackage ePackage : additionalEPackages) {
            this.queryEnvironment.registerEPackage(ePackage);
        }
        if (additionalEPackages.size() > 0) {
            this.initExpressionsCache();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.javaExtensions.removeClassLoadingCallBack(this.callback);
        this.javaExtensions.removeEPackageCallBack(this.ePackageCallBack);
    }

    public Object evaluate(EObject target, String fullExpression) throws EvaluationException {
        IInterpreterWithDiagnostic.IEvaluationResult evaluationResult = this.evaluateExpression(target, fullExpression);
        Diagnostic diagnostic = evaluationResult.getDiagnostic();
        if (diagnostic.getSeverity() == 4) {
            String uri = EcoreUtil.getURI((EObject)target).toString();
            String message = MessageFormat.format(Messages.AQLInterpreter_errorWithExpression, fullExpression, diagnostic.toString(), uri, target);
            throw new EvaluationException(message, diagnostic.getException());
        }
        return evaluationResult.getValue();
    }

    public IInterpreterWithDiagnostic.IEvaluationResult evaluateExpression(EObject target, String fullExpression) throws EvaluationException {
        this.javaExtensions.reloadIfNeeded();
        String expression = new ExpressionTrimmer(fullExpression).getExpression();
        Map<String, Object> variables = this.getVariables();
        variables.put("self", target);
        try {
            IQueryBuilderEngine.AstResult build = (IQueryBuilderEngine.AstResult)this.parsedExpressions.get((Object)expression);
            IQueryEvaluationEngine evaluationEngine = QueryEvaluation.newEngine((IQueryEnvironment)this.queryEnvironment);
            final EvaluationResult evalResult = evaluationEngine.eval(build, variables);
            final BasicDiagnostic diagnostic = new BasicDiagnostic();
            if (build.getDiagnostic().getSeverity() != 0) {
                diagnostic.merge(build.getDiagnostic());
            }
            if (evalResult.getDiagnostic().getSeverity() != 0) {
                diagnostic.merge(evalResult.getDiagnostic());
            }
            return new IInterpreterWithDiagnostic.IEvaluationResult(){

                public Object getValue() {
                    return evalResult.getResult();
                }

                public Diagnostic getDiagnostic() {
                    List children = diagnostic.getChildren();
                    if (children.size() == 1) {
                        return (Diagnostic)children.get(0);
                    }
                    return diagnostic;
                }
            };
        }
        catch (ExecutionException e) {
            throw new EvaluationException(e.getCause());
        }
    }

    public String getVariablePrefix() {
        return null;
    }

    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
        this.siriusXref = crossReferencer;
    }

    public void setModelAccessor(ModelAccessor modelAccessor) {
    }

    public boolean supportsValidation() {
        return true;
    }

    public ValidationResult analyzeExpression(IInterpreterContext context, String fullExpression) {
        this.javaExtensions.reloadIfNeeded();
        String trimmedExpression = new ExpressionTrimmer(fullExpression).getExpression();
        Map<String, Set<IType>> variableTypes = TypesUtil.createAQLVariableTypesFromInterpreterContext(context, this.queryEnvironment);
        ValidationResult result = new ValidationResult();
        IQueryValidationEngine validator = QueryValidation.newEngine((IQueryEnvironment)this.queryEnvironment);
        try {
            final IValidationResult aqlValidationResult = validator.validate(trimmedExpression, variableTypes);
            result = new ValidationResult(){

                public Map<String, VariableType> getInferredVariableTypes(Boolean value) {
                    LinkedHashMap<String, VariableType> mapResult = new LinkedHashMap<String, VariableType>();
                    Map types = aqlValidationResult.getInferredVariableTypes(aqlValidationResult.getAstResult().getAst(), value);
                    Iterator it = types.entrySet().iterator();
                    while (it.hasNext()) {
                        LinkedHashSet<EClassifier> eClassifiers = new LinkedHashSet<EClassifier>();
                        Map.Entry entry = it.next();
                        for (IType type : (Set)entry.getValue()) {
                            if (!(type.getType() instanceof EClassifier)) continue;
                            eClassifiers.add((EClassifier)type.getType());
                        }
                        if (eClassifiers.size() <= 0) continue;
                        mapResult.put((String)entry.getKey(), VariableType.fromEClassifiers(eClassifiers));
                    }
                    return mapResult;
                }
            };
            for (IValidationMessage message : aqlValidationResult.getMessages()) {
                String severity = "warning";
                if (message.getLevel() == ValidationMessageLevel.ERROR) {
                    severity = "error";
                } else if (message.getLevel() == ValidationMessageLevel.INFO) {
                    severity = "info";
                }
                result.addStatus(InterpreterStatusFactory.createInterpreterStatus((IInterpreterContext)context, (String)severity, (String)message.getMessage()));
            }
            ArrayList<EClassifier> classifierNames = new ArrayList<EClassifier>();
            ArrayList<Class> javaClasses = new ArrayList<Class>();
            Iterator iterator = aqlValidationResult.getPossibleTypes(aqlValidationResult.getAstResult().getAst()).iterator();
            while (iterator.hasNext()) {
                IType type;
                IType actualType = type = (IType)iterator.next();
                if (type instanceof ICollectionType) {
                    actualType = ((ICollectionType)type).getCollectionType();
                }
                if (actualType instanceof EClassifierType) {
                    EClassifierType eClassifierType = (EClassifierType)actualType;
                    if (eClassifierType.getType() == null) continue;
                    classifierNames.add(eClassifierType.getType());
                    continue;
                }
                if (!(actualType instanceof ClassType) || actualType.getClass() == null) continue;
                Class clazz = ((ClassType)actualType).getType();
                Set eClassifiersFromJavaClassName = this.queryEnvironment.getEPackageProvider().getEClassifiers(clazz);
                if (eClassifiersFromJavaClassName != null && eClassifiersFromJavaClassName.size() > 0) {
                    classifierNames.addAll(eClassifiersFromJavaClassName);
                    continue;
                }
                javaClasses.add(clazz);
            }
            result.setReturnType(VariableType.fromEClassifiersAndClasses(classifierNames, javaClasses));
        }
        catch (AcceleoQueryValidationException e) {
            result.addStatus(InterpreterStatusFactory.createInterpreterStatus((IInterpreterContext)context, (String)"error", (String)e.getMessage()));
            AQLSiriusPlugin.INSTANCE.log(new Status(4, AQLSiriusPlugin.INSTANCE.getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        catch (AcceleoQueryEvaluationException e) {
            result.addStatus(InterpreterStatusFactory.createInterpreterStatus((IInterpreterContext)context, (String)"error", (String)e.getMessage()));
        }
        return result;
    }

    public Collection<Method> getImplementation(String serviceCall) {
        this.javaExtensions.reloadIfNeeded();
        Set registeredServices = this.queryEnvironment.getLookupEngine().getRegisteredServices();
        ArrayList<Method> results = new ArrayList<Method>();
        registeredServices.iterator().forEachRemaining(s -> {
            if (s instanceof JavaMethodService) {
                results.add(((JavaMethodService)s).getMethod());
            }
        });
        return results;
    }

    public CrossReferenceProvider getCrossReferenceProvider() {
        return this.xRef;
    }

    public String getPrefix() {
        return "aql:";
    }

    public boolean provides(String expression) {
        return expression != null && expression.startsWith("aql:");
    }

    public IQueryEnvironment getQueryEnvironment() {
        this.javaExtensions.reloadIfNeeded();
        return this.queryEnvironment;
    }
}

