/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.elements;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.sequence.Messages;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractSequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.LostMessageEnd;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ObservationPoint;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.emf.AllContents;

public class SequenceDiagram
extends AbstractSequenceElement {
    private boolean useCache;
    private List<AbstractNodeEvent> allAbstractNodeEventsCache;
    private List<CombinedFragment> allCombinedFragmentsCache;
    private Set<EndOfLife> allEndOfLifesCache;
    private List<Execution> allExecutionsCache;
    private List<AbstractFrame> allFramesCache;
    private Collection<InstanceRole> allInstanceRolesCache;
    private List<InteractionUse> allInteractionUsesCache;
    private List<Lifeline> allLifelinesCache;
    private Collection<LostMessageEnd> allLostMessageEndCache;
    private List<Message> allMessagesCache;
    private Collection<ObservationPoint> allObservationPointsCache;
    private List<Operand> allOperandsCache;
    private List<State> allStatesCache;
    private LinkedHashSet<AbstractNodeEvent> allOrderedAbstractNodeEventsCache;
    private LinkedHashSet<CombinedFragment> allOrderedCombinedFragmentsCache;
    private Set<ISequenceEvent> allOrderedDelimitedSequenceEventsCache;
    private LinkedHashSet<Execution> allOrderedExecutionsCache;
    private LinkedHashSet<AbstractFrame> allOrderedFramesCache;
    private LinkedHashSet<InteractionUse> allOrderedInteractionUsesCache;
    private List<Lifeline> allOrderedLifelinesCache;
    private LinkedHashSet<Message> allOrderedMessagesCache;
    private LinkedHashSet<Operand> allOrderedOperandsCache;
    private LinkedHashSet<State> allOrderedStatesCache;

    SequenceDiagram(Diagram diagram) {
        super((View)diagram);
        Preconditions.checkArgument((boolean)SequenceDiagram.notationPredicate().apply((Object)diagram), (Object)Messages.SequenceDiagram_nonSequenceDiagramDiagram);
    }

    public static Predicate<View> notationPredicate() {
        return NotationPredicate.INSTANCE;
    }

    public static Predicate<DDiagram> viewpointElementPredicate() {
        return SiriusElementPredicate.INSTANCE;
    }

    public Diagram getNotationDiagram() {
        return (Diagram)this.view;
    }

    public SequenceDDiagram getSequenceDDiagram() {
        return (SequenceDDiagram)this.view.getElement();
    }

    public Set<Lifeline> getGraphicallyCoveredLifelines(final Rectangle area) {
        ArrayList result = new ArrayList();
        Iterables.addAll(result, (Iterable)Iterables.filter(this.getAllLifelines(), (Predicate)new Predicate<Lifeline>(){

            public boolean apply(Lifeline input) {
                return input.getProperLogicalBounds().intersects(area) && input.getVerticalRange().includes(area.getTop().y);
            }
        }));
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        return Sets.newLinkedHashSet(result);
    }

    public List<InstanceRole> getSortedInstanceRole() {
        Function<InstanceRole, Integer> xLocation = new Function<InstanceRole, Integer>(){

            public Integer apply(InstanceRole from) {
                Rectangle bounds = from.getBounds();
                return bounds.x;
            }
        };
        ArrayList allInstanceRoles = Lists.newArrayList(this.getAllInstanceRoles());
        Collections.sort(allInstanceRoles, Ordering.natural().onResultOf((Function)xLocation));
        return allInstanceRoles;
    }

    public Collection<InstanceRole> getAllInstanceRoles() {
        Collection<InstanceRole> allInstanceRoles = null;
        if (this.useCache) {
            allInstanceRoles = this.allInstanceRolesCache;
        }
        if (allInstanceRoles == null) {
            allInstanceRoles = new ArrayList<InstanceRole>();
            for (View child : Iterables.filter((Iterable)this.getNotationView().getChildren(), View.class)) {
                Option<InstanceRole> instanceRole;
                if (!InstanceRole.notationPredicate().apply((Object)child) || !(instanceRole = ISequenceElementAccessor.getInstanceRole(child)).some()) continue;
                allInstanceRoles.add((InstanceRole)instanceRole.get());
            }
            if (this.useCache) {
                this.allInstanceRolesCache = allInstanceRoles;
            }
        }
        return allInstanceRoles;
    }

    public List<Lifeline> getAllLifelines() {
        ArrayList allLifelines = null;
        if (this.useCache && this.allLifelinesCache != null) {
            allLifelines = Lists.newArrayList(this.allLifelinesCache);
        }
        if (this.allOrderedLifelinesCache == null) {
            if (allLifelines == null) {
                allLifelines = new ArrayList();
                Collection<InstanceRole> allInstanceRoles = this.getAllInstanceRoles();
                Function<ISequenceNode, Lifeline> lifelineFunction = new Function<ISequenceNode, Lifeline>(){

                    public Lifeline apply(ISequenceNode from) {
                        return (Lifeline)from.getLifeline().get();
                    }
                };
                allLifelines = Lists.newArrayList((Iterable)Iterables.transform(allInstanceRoles, (Function)lifelineFunction));
                if (this.useCache) {
                    this.allLifelinesCache = allLifelines;
                }
            }
            Collections.sort(allLifelines, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
            this.allOrderedLifelinesCache = Lists.newArrayList(allLifelines);
        }
        return this.allOrderedLifelinesCache;
    }

    public Collection<ObservationPoint> getAllObservationPoints() {
        Collection<ObservationPoint> allObservationPoints = null;
        if (this.useCache) {
            allObservationPoints = this.allObservationPointsCache;
        }
        if (allObservationPoints == null) {
            allObservationPoints = new ArrayList<ObservationPoint>();
            for (View child : Iterables.filter((Iterable)this.getNotationView().getChildren(), View.class)) {
                Option<ObservationPoint> obsPoint;
                if (!ObservationPoint.notationPredicate().apply((Object)child) || !(obsPoint = ISequenceElementAccessor.getObservationPoint(child)).some()) continue;
                allObservationPoints.add((ObservationPoint)obsPoint.get());
            }
            if (this.useCache) {
                this.allObservationPointsCache = allObservationPoints;
            }
        }
        return allObservationPoints;
    }

    public Collection<LostMessageEnd> getAllLostMessageEnds() {
        Collection<LostMessageEnd> allLostMessageEnd = null;
        if (this.useCache) {
            allLostMessageEnd = this.allLostMessageEndCache;
        }
        if (allLostMessageEnd == null) {
            allLostMessageEnd = new ArrayList<LostMessageEnd>();
            for (View child : Iterables.filter((Iterable)this.getNotationView().getChildren(), View.class)) {
                Option<LostMessageEnd> lostMessageEnd;
                if (!LostMessageEnd.notationPredicate().apply((Object)child) || !(lostMessageEnd = ISequenceElementAccessor.getLostMessageEnd(child)).some()) continue;
                allLostMessageEnd.add((LostMessageEnd)lostMessageEnd.get());
            }
            if (this.useCache) {
                this.allLostMessageEndCache = allLostMessageEnd;
            }
        }
        return allLostMessageEnd;
    }

    public Set<Message> getAllMessages() {
        ArrayList<Message> allMessages = null;
        LinkedHashSet allOrderedMessages = null;
        if (this.useCache) {
            if (this.allMessagesCache != null) {
                allMessages = Lists.newArrayList(this.allMessagesCache);
            }
            allOrderedMessages = this.allOrderedMessagesCache;
        }
        if (allOrderedMessages == null) {
            if (allMessages == null) {
                allMessages = new ArrayList<Message>();
                for (Edge edge : Iterables.filter((Iterable)Iterables.filter((Iterable)this.getNotationDiagram().getEdges(), Edge.class), Message.notationPredicate())) {
                    Option<Message> message = ISequenceElementAccessor.getMessage((View)edge);
                    assert (message.some()) : Messages.SequenceDiagram_InternalError;
                    allMessages.add((Message)message.get());
                }
                if (this.useCache) {
                    this.allMessagesCache = allMessages;
                }
            }
            Collections.sort(allMessages, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
            allOrderedMessages = Sets.newLinkedHashSet(allMessages);
            if (this.useCache) {
                this.allOrderedMessagesCache = allOrderedMessages;
            }
        }
        return allOrderedMessages;
    }

    public Set<AbstractNodeEvent> getAllAbstractNodeEvents() {
        ArrayList<AbstractNodeEvent> allAbstractNodeEvents = null;
        LinkedHashSet allOrderedAbstractNodeEvents = null;
        if (this.useCache) {
            if (this.allAbstractNodeEventsCache != null) {
                allAbstractNodeEvents = Lists.newArrayList(this.allAbstractNodeEventsCache);
            }
            allOrderedAbstractNodeEvents = this.allOrderedAbstractNodeEventsCache;
        }
        if (allOrderedAbstractNodeEvents == null) {
            if (allAbstractNodeEvents == null) {
                allAbstractNodeEvents = new ArrayList<AbstractNodeEvent>();
                for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)this.getNotationDiagram()), Node.class), AbstractNodeEvent.notationPredicate())) {
                    Option<AbstractNodeEvent> exec = ISequenceElementAccessor.getAbstractNodeEvent((View)node);
                    assert (exec.some()) : Messages.SequenceDiagram_InternalError;
                    allAbstractNodeEvents.add((AbstractNodeEvent)exec.get());
                }
                if (this.useCache) {
                    this.allAbstractNodeEventsCache = allAbstractNodeEvents;
                }
            }
            Collections.sort(allAbstractNodeEvents, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
            allOrderedAbstractNodeEvents = Sets.newLinkedHashSet(allAbstractNodeEvents);
            if (this.useCache) {
                this.allOrderedAbstractNodeEventsCache = allOrderedAbstractNodeEvents;
            }
        }
        return allOrderedAbstractNodeEvents;
    }

    public Set<Execution> getAllExecutions() {
        ArrayList<Execution> allExecutions = null;
        LinkedHashSet allOrderedExecutions = null;
        if (this.useCache) {
            if (this.allExecutionsCache != null) {
                allExecutions = Lists.newArrayList(this.allExecutionsCache);
            }
            allOrderedExecutions = this.allOrderedExecutionsCache;
        }
        if (allOrderedExecutions == null) {
            if (allExecutions == null) {
                allExecutions = new ArrayList<Execution>();
                for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)this.getNotationDiagram()), Node.class), Execution.notationPredicate())) {
                    Option<Execution> exec = ISequenceElementAccessor.getExecution((View)node);
                    assert (exec.some()) : Messages.SequenceDiagram_InternalError;
                    allExecutions.add((Execution)exec.get());
                }
                if (this.useCache) {
                    this.allExecutionsCache = allExecutions;
                }
            }
            Collections.sort(allExecutions, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
            allOrderedExecutions = Sets.newLinkedHashSet(allExecutions);
            if (this.useCache) {
                this.allOrderedExecutionsCache = allOrderedExecutions;
            }
        }
        return allOrderedExecutions;
    }

    public Set<State> getAllStates() {
        ArrayList<State> allStates = null;
        LinkedHashSet allOrderedStates = null;
        if (this.useCache) {
            if (this.allOperandsCache != null) {
                allStates = Lists.newArrayList(this.allStatesCache);
            }
            allOrderedStates = this.allOrderedStatesCache;
        }
        if (allOrderedStates == null) {
            if (allStates == null) {
                allStates = new ArrayList<State>();
                for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)this.getNotationDiagram()), Node.class), State.notationPredicate())) {
                    Option<State> exec = ISequenceElementAccessor.getState((View)node);
                    assert (exec.some()) : Messages.SequenceDiagram_InternalError;
                    allStates.add((State)exec.get());
                }
                if (this.useCache) {
                    this.allStatesCache = allStates;
                }
            }
            Collections.sort(allStates, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
            allOrderedStates = Sets.newLinkedHashSet(allStates);
            if (this.useCache) {
                this.allOrderedStatesCache = allOrderedStates;
            }
        }
        return allOrderedStates;
    }

    public Collection<AbstractFrame> getAllFrames() {
        ArrayList<AbstractFrame> allFrames = null;
        LinkedHashSet allOrderedFrames = null;
        if (this.useCache) {
            if (this.allExecutionsCache != null) {
                allFrames = Lists.newArrayList(this.allFramesCache);
            }
            allOrderedFrames = this.allOrderedFramesCache;
        }
        if (allOrderedFrames == null) {
            if (allFrames == null) {
                allFrames = new ArrayList<AbstractFrame>();
                for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)this.getNotationDiagram().getChildren(), Node.class), AbstractFrame.notationPredicate())) {
                    Option<ISequenceEvent> exec = ISequenceElementAccessor.getISequenceEvent((View)node);
                    assert (exec.some()) : Messages.SequenceDiagram_InternalError;
                    if (!(exec.get() instanceof AbstractFrame)) continue;
                    allFrames.add((AbstractFrame)exec.get());
                }
                if (this.useCache) {
                    this.allFramesCache = allFrames;
                }
            }
            Collections.sort(allFrames, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
            allOrderedFrames = Sets.newLinkedHashSet(allFrames);
            if (this.useCache) {
                this.allOrderedFramesCache = allOrderedFrames;
            }
        }
        return allOrderedFrames;
    }

    public Set<InteractionUse> getAllInteractionUses() {
        ArrayList<InteractionUse> allInteractionUses = null;
        LinkedHashSet allOrderedInteractionUses = null;
        if (this.useCache) {
            if (this.allInteractionUsesCache != null) {
                allInteractionUses = Lists.newArrayList(this.allInteractionUsesCache);
            }
            allOrderedInteractionUses = this.allOrderedInteractionUsesCache;
        }
        if (allOrderedInteractionUses == null) {
            if (allInteractionUses == null) {
                allInteractionUses = new ArrayList<InteractionUse>();
                for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)this.getNotationDiagram().getChildren(), Node.class), InteractionUse.notationPredicate())) {
                    Option<InteractionUse> exec = ISequenceElementAccessor.getInteractionUse((View)node);
                    assert (exec.some()) : Messages.SequenceDiagram_InternalError;
                    allInteractionUses.add((InteractionUse)exec.get());
                }
                if (this.useCache) {
                    this.allInteractionUsesCache = allInteractionUses;
                }
            }
            Collections.sort(allInteractionUses, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
            allOrderedInteractionUses = Sets.newLinkedHashSet(allInteractionUses);
            if (this.useCache) {
                this.allOrderedInteractionUsesCache = allOrderedInteractionUses;
            }
        }
        return allOrderedInteractionUses;
    }

    public Set<CombinedFragment> getAllCombinedFragments() {
        ArrayList<CombinedFragment> allCombinedFragments = null;
        LinkedHashSet allOrderedCombinedFragments = null;
        if (this.useCache) {
            if (this.allCombinedFragmentsCache != null) {
                allCombinedFragments = Lists.newArrayList(this.allCombinedFragmentsCache);
            }
            allOrderedCombinedFragments = this.allOrderedCombinedFragmentsCache;
        }
        if (allOrderedCombinedFragments == null) {
            if (allCombinedFragments == null) {
                allCombinedFragments = new ArrayList<CombinedFragment>();
                for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)this.getNotationDiagram().getChildren(), Node.class), CombinedFragment.notationPredicate())) {
                    Option<CombinedFragment> exec = ISequenceElementAccessor.getCombinedFragment((View)node);
                    assert (exec.some()) : Messages.SequenceDiagram_InternalError;
                    allCombinedFragments.add((CombinedFragment)exec.get());
                }
                if (this.useCache) {
                    this.allCombinedFragmentsCache = allCombinedFragments;
                }
            }
            Collections.sort(allCombinedFragments, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
            allOrderedCombinedFragments = Sets.newLinkedHashSet(allCombinedFragments);
            if (this.useCache) {
                this.allOrderedCombinedFragmentsCache = allOrderedCombinedFragments;
            }
        }
        return allOrderedCombinedFragments;
    }

    public Set<Operand> getAllOperands() {
        ArrayList<Operand> allOperands = null;
        LinkedHashSet allOrderedOperands = null;
        if (this.useCache) {
            if (this.allOperandsCache != null) {
                allOperands = Lists.newArrayList(this.allOperandsCache);
            }
            allOrderedOperands = this.allOrderedOperandsCache;
        }
        if (allOrderedOperands == null) {
            if (allOperands == null) {
                allOperands = new ArrayList<Operand>();
                for (Node node : Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)this.getNotationDiagram()), Node.class), Operand.notationPredicate())) {
                    Option<Operand> exec = ISequenceElementAccessor.getOperand((View)node);
                    assert (exec.some()) : Messages.SequenceDiagram_InternalError;
                    allOperands.add((Operand)exec.get());
                }
                if (this.useCache) {
                    this.allOperandsCache = allOperands;
                }
            }
            Collections.sort(allOperands, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
            allOrderedOperands = Sets.newLinkedHashSet(allOperands);
            if (this.useCache) {
                this.allOrderedOperandsCache = allOrderedOperands;
            }
        }
        return allOrderedOperands;
    }

    public Set<EndOfLife> getAllEndOfLifes() {
        Set<EndOfLife> allEndOfLifes = null;
        if (this.useCache) {
            allEndOfLifes = this.allEndOfLifesCache;
        }
        if (allEndOfLifes == null) {
            allEndOfLifes = new HashSet<EndOfLife>();
            for (Lifeline lifeline : this.getAllLifelines()) {
                if (!lifeline.getEndOfLife().some()) continue;
                allEndOfLifes.add((EndOfLife)lifeline.getEndOfLife().get());
            }
            if (this.useCache) {
                this.allEndOfLifesCache = allEndOfLifes;
            }
        }
        return allEndOfLifes;
    }

    public Set<ISequenceEvent> getAllOrderedDelimitedSequenceEvents() {
        LinkedHashSet allOrderedDelimitedSequenceEvents = null;
        if (this.useCache) {
            allOrderedDelimitedSequenceEvents = this.allOrderedDelimitedSequenceEventsCache;
        }
        if (allOrderedDelimitedSequenceEvents == null) {
            ArrayList result = new ArrayList();
            Iterables.addAll(result, this.getAllDelimitedSequenceEvents());
            Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
            allOrderedDelimitedSequenceEvents = Sets.newLinkedHashSet(result);
            if (this.useCache) {
                this.allOrderedDelimitedSequenceEventsCache = allOrderedDelimitedSequenceEvents;
            }
        }
        return allOrderedDelimitedSequenceEvents;
    }

    public Iterable<? extends ISequenceEvent> getAllDelimitedSequenceEvents() {
        Function<View, ISequenceEvent> getISE = new Function<View, ISequenceEvent>(){

            public ISequenceEvent apply(View from) {
                Option<ISequenceEvent> ise = ISequenceElementAccessor.getISequenceEvent(from);
                if (!$assertionsDisabled && !ise.some()) {
                    throw new AssertionError((Object)Messages.SequenceDiagram_InternalError);
                }
                return (ISequenceEvent)ise.get();
            }
        };
        return Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.filter((Iterable)AllContents.of((EObject)this.getNotationDiagram()), View.class), ISequenceEvent.ISEQUENCEEVENT_NOTATION_PREDICATE), (Function)getISE);
    }

    public List<EventEnd> findEnds(ISequenceEvent event) {
        ArrayList<EventEnd> ends = new ArrayList<EventEnd>();
        EObject seqDiag = this.getNotationDiagram().getElement();
        Option<EObject> semanticEvent = event.getSemanticTargetElement();
        if (seqDiag instanceof SequenceDDiagram && semanticEvent.some()) {
            for (EventEnd ee : ((SequenceDDiagram)seqDiag).getGraphicalOrdering().getEventEnds()) {
                if (!EventEndHelper.getSemanticEvents(ee).contains(semanticEvent.get())) continue;
                ends.add(ee);
            }
        }
        return ends;
    }

    @Override
    public Option<Lifeline> getLifeline() {
        return Options.newNone();
    }

    @Override
    public Rectangle getProperLogicalBounds() {
        return new Rectangle(0, 0, 0, 0);
    }

    public void useCache(boolean newStatus) {
        this.useCache = newStatus;
    }

    public void clearAllCaches() {
        this.allAbstractNodeEventsCache = null;
        this.allCombinedFragmentsCache = null;
        this.allEndOfLifesCache = null;
        this.allExecutionsCache = null;
        this.allFramesCache = null;
        this.allInstanceRolesCache = null;
        this.allInteractionUsesCache = null;
        this.allLifelinesCache = null;
        this.allLostMessageEndCache = null;
        this.allMessagesCache = null;
        this.allObservationPointsCache = null;
        this.allOperandsCache = null;
        this.allStatesCache = null;
        this.clearOrderedCaches();
    }

    public void clearOrderedCaches() {
        this.allOrderedAbstractNodeEventsCache = null;
        this.allOrderedCombinedFragmentsCache = null;
        this.allOrderedDelimitedSequenceEventsCache = null;
        this.allOrderedExecutionsCache = null;
        this.allOrderedFramesCache = null;
        this.allOrderedInteractionUsesCache = null;
        this.allOrderedLifelinesCache = null;
        this.allOrderedMessagesCache = null;
        this.allOrderedOperandsCache = null;
        this.allOrderedStatesCache = null;
    }

    private static enum NotationPredicate implements Predicate<View>
    {
        INSTANCE;


        public boolean apply(View input) {
            if (input instanceof Diagram) {
                EObject element = input.getElement();
                return element instanceof DDiagram && SequenceDiagram.viewpointElementPredicate().apply((Object)((DDiagram)element));
            }
            return false;
        }
    }

    private static enum SiriusElementPredicate implements Predicate<DDiagram>
    {
        INSTANCE;


        public boolean apply(DDiagram input) {
            if (input == null) {
                return false;
            }
            EClass sdDescClass = DescriptionPackage.eINSTANCE.getSequenceDiagramDescription();
            return input instanceof SequenceDDiagram && sdDescClass.isInstance((Object)input.getDescription());
        }
    }
}

