/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.scripts;

import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.IImageService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.AbstractPrePostTagHandler;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;

public class ImageTagHandler
extends AbstractPrePostTagHandler {
    public String doRun(ITag tag) throws GenDocException {
        String result = super.doRun(tag);
        if (tag != null && tag.getAttributes() != null) {
            boolean keepH = Boolean.parseBoolean((String)tag.getAttributes().get(RegisteredTags.IMAGE_KEEP_H));
            boolean keepW = Boolean.parseBoolean((String)tag.getAttributes().get(RegisteredTags.IMAGE_KEEP_W));
            boolean maxH = Boolean.parseBoolean((String)tag.getAttributes().get(RegisteredTags.IMAGE_MAX_H));
            boolean maxW = Boolean.parseBoolean((String)tag.getAttributes().get(RegisteredTags.IMAGE_MAX_W));
            String filePath = (String)tag.getAttributes().get(RegisteredTags.IMAGE_FILE_PATH);
            String object = (String)tag.getAttributes().get(RegisteredTags.IMAGE_OBJECT);
            IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
            IImageService imageService = documentService.getAdditionalResourceService().getImageService();
            String imageId = "";
            if (filePath != null) {
                imageId = imageService.getImageId(filePath);
            } else if (object != null) {
                imageId = object;
                filePath = imageService.getFilePath(imageId);
            }
            result = imageService.manageImage(tag, imageId, filePath, keepH, keepW, maxH, maxW);
            result = result.replaceAll("(&lt;image[^&]*&gt;)|(&lt;/image[^&]*&gt;)", "");
        }
        return result;
    }
}

