/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.m2t.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.gendoc.m2t.IFragmentService;
import org.eclipse.gendoc.m2t.IncorrectFragmentException;
import org.eclipse.gendoc.m2t.model.Argument;
import org.eclipse.gendoc.m2t.model.Fragment;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.exception.GenDocException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentService
extends AbstractService
implements IFragmentService {
    private Map<String, Fragment> fragments = new HashMap<String, Fragment>();

    @Override
    public void addFragment(String name) throws GenDocException {
        if (this.fragments.containsKey(name)) {
            throw new IncorrectFragmentException(name);
        }
        Fragment f = new Fragment(name);
        this.fragments.put(name, f);
    }

    @Override
    public void addArgument(String fragmentName, String argumentName, String argumentType) throws GenDocException {
        Fragment f = this.fragments.get(fragmentName);
        if (f != null) {
            Argument a = new Argument(argumentName, argumentType);
            if (f.containsArgument(a.getName())) {
                throw new GenDocException("Fragment " + fragmentName + " already contains argument named " + argumentName){
                    private static final long serialVersionUID = 1L;
                };
            }
            f.addArgument(a);
        }
    }

    @Override
    public void addFragmentScriptContent(String fragmentName, String scriptValue) {
        Fragment f = this.fragments.get(fragmentName);
        if (f != null) {
            f.setScriptValue(scriptValue);
        }
    }

    @Override
    public List<Fragment> getAllFragments() {
        return new LinkedList<Fragment>(this.fragments.values());
    }

    @Override
    public void addBundleToFragment(String fragmentName, String bundle) {
        Fragment f = this.fragments.get(fragmentName);
        if (f != null) {
            f.addImportedBundle(bundle);
        }
    }

    @Override
    public void addFragmentImportToFragment(String fragmentName, String fragmentImported) {
        Fragment f = this.fragments.get(fragmentName);
        if (f != null) {
            f.addImportedFragment(fragmentImported);
        }
    }
}

