/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.impl.fragment;

import org.eclipse.gendoc.m2t.IFragmentService;
import org.eclipse.gendoc.m2t.IFragmentableM2TProcessor;
import org.eclipse.gendoc.m2t.IM2TProcessor;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.ElementNotFoundException;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.ModelNotFoundException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.AbstractScriptTagHandler;
import org.eclipse.gendoc.tags.handlers.IContextService;
import org.eclipse.gendoc.tags.handlers.exceptions.FragmentUnavailableException;
import org.eclipse.gendoc.tags.handlers.exceptions.IncorrectTagException;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;

public class FragmentTagHandler
extends AbstractScriptTagHandler {
    private static final String delimiter = ";";

    protected String runAttributes(ITag tag, String value) throws GenDocException {
        super.runChildren(tag, value);
        String result = super.runAttributes(tag, value);
        String name = (String)tag.getAttributes().get(RegisteredTags.FRAGMENT_NAME);
        if (name == null || name.length() == 0) {
            throw new IncorrectTagException(tag, "name is mandatory");
        }
        final IFragmentService service = (IFragmentService)GendocServices.getDefault().getService(IFragmentService.class);
        service.addFragment(name);
        this.manageImport(tag, name, service, RegisteredTags.FRAGMENT_IMPORTED_BUNDLES, new IAdder(){

            public void add(String from, String toAdd) {
                service.addBundleToFragment(from, toAdd);
            }
        });
        this.manageImport(tag, name, service, RegisteredTags.FRAGMENT_IMPORTED_FRAGMENTS, new IAdder(){

            public void add(String from, String toAdd) {
                service.addFragmentImportToFragment(from, toAdd);
            }
        });
        return result;
    }

    protected void manageImport(ITag tag, String name, IFragmentService service, String attributeName, IAdder run) {
        String imported = (String)tag.getAttributes().get(attributeName);
        if (imported != null && imported.length() > 0) {
            String[] toImport;
            String[] stringArray = toImport = imported.split(delimiter);
            int n = toImport.length;
            int n2 = 0;
            while (n2 < n) {
                String bundle = stringArray[n2];
                run.add(name, bundle);
                ++n2;
            }
        }
    }

    protected String doRun(ITag tag) throws GenDocException {
        String result = super.doRun(tag);
        IFragmentService service = (IFragmentService)GendocServices.getDefault().getService(IFragmentService.class);
        service.addFragmentScriptContent((String)tag.getAttributes().get(RegisteredTags.FRAGMENT_NAME), result);
        return "";
    }

    protected String runProcessorScript(IM2TProcessor processor, IContextService context, String cleanedTagValue, ITag tag) throws GenDocException, ModelNotFoundException, ElementNotFoundException {
        return cleanedTagValue;
    }

    protected IM2TProcessor getProcessor(String language) throws GenDocException {
        IM2TProcessor processor = super.getProcessor(language);
        if (!(processor instanceof IFragmentableM2TProcessor)) {
            throw new FragmentUnavailableException(processor.getClass());
        }
        return processor;
    }

    private static interface IAdder {
        public void add(String var1, String var2);
    }
}

