/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.documents;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.ZipDocument;
import org.eclipse.gendoc.documents.FileRunnable;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.ResourceRunnable;
import org.eclipse.gendoc.documents.impl.IDGenerator;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.AdditionalResourceException;
import org.eclipse.gendoc.services.utils.DefaultImageExtensionUtils;

public abstract class AdditionalResourceService
extends AbstractService
implements IAdditionalResourceService {
    protected String SEPARATOR = "/";
    protected Map<String, ResourceRunnable> runnableMap;
    protected Map<String, String> imagesMap = new LinkedHashMap<String, String>();
    protected Set<String> fileExtensions;

    public AdditionalResourceService() {
        this.runnableMap = new LinkedHashMap<String, ResourceRunnable>();
        this.fileExtensions = new HashSet<String>();
    }

    public void clear() {
    }

    protected String getFileName(String filePath) {
        int index = filePath.lastIndexOf(File.separatorChar);
        if (index == -1) {
            return filePath;
        }
        return filePath.substring(index);
    }

    public String addImage(String fullPath) {
        String imageId = this.generateUniqueId();
        this.imagesMap.put(imageId, fullPath);
        this.fileExtensions.add(Path.fromOSString((String)fullPath).getFileExtension());
        return imageId;
    }

    public String getImageRelativePath(String imageKey) {
        String imageFullPath = this.imagesMap.get(imageKey);
        if (imageFullPath != null) {
            File imageFile = new File(this.imagesMap.get(imageKey));
            return String.valueOf(this.getRelativeResourceFolder()) + this.SEPARATOR + imageKey + "." + Path.fromOSString((String)imageFile.getAbsolutePath()).getFileExtension();
        }
        ResourceRunnable runnable = this.runnableMap.get(imageKey);
        String extension = this.getFileExtensionFromRunnable(runnable);
        return String.valueOf(this.getRelativeResourceFolder()) + this.SEPARATOR + imageKey + "." + extension;
    }

    private String getFileExtensionFromRunnable(ResourceRunnable runnable) {
        if (runnable instanceof FileRunnable) {
            return ((FileRunnable)runnable).getFileExtension();
        }
        return DefaultImageExtensionUtils.getDefaultImageExtension();
    }

    public abstract void addAdditionalResourcesToDocument() throws AdditionalResourceException;

    public abstract String addRunnableResourceToDocument(String var1, String var2) throws AdditionalResourceException;

    protected void copyImage(File fromImage, String toLocation) throws IOException {
        if (fromImage.exists()) {
            this.copyFile(fromImage, toLocation);
        }
    }

    protected void copyFile(File fromFile, String toLocation) throws IOException {
        FileInputStream in = new FileInputStream(fromFile);
        this.copyFile(new BufferedInputStream(in), toLocation);
    }

    private void copyFile(InputStream in, String toLocation) throws IOException {
        int len;
        File outputFile = new File(toLocation);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    protected String readFileContent(File file) throws IOException {
        String lineSep = System.getProperty("line.separator");
        BufferedReader br = new BufferedReader(new FileReader(file));
        String nextLine = "";
        StringBuffer sb = new StringBuffer();
        while ((nextLine = br.readLine()) != null) {
            sb.append(nextLine);
            sb.append(lineSep);
        }
        return sb.toString();
    }

    protected void writeFileContent(File file, StringBuffer fileContent) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(fileContent.toString());
        bw.close();
    }

    public String addNewImageRunnable(ResourceRunnable runnable) {
        String id = this.generateUniqueId();
        this.runnableMap.put(id, runnable);
        return id;
    }

    public String getResourceFolder() {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        Document document = documentService.getDocument();
        if (document instanceof ZipDocument) {
            File unzipLoc = ((ZipDocument)document).getUnzipLocationDocumentFile();
            String mediaLoc = String.valueOf(unzipLoc.getAbsolutePath()) + this.SEPARATOR + this.getRelativeResourceFolder();
            return mediaLoc;
        }
        return null;
    }

    protected abstract String getRelativeResourceFolder();

    protected String generateUniqueId() {
        return IDGenerator.nextID();
    }
}

