/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.documents.url;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.core.runtime.Path;
import org.eclipse.gendoc.documents.url.UrlTransformer;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;

public class FileUrlTransformer
extends UrlTransformer {
    private File curFile = null;

    public BufferedInputStream getInputStream(String urlOri) {
        ILogger logger;
        BufferedInputStream in = null;
        this.oriUrl = urlOri;
        try {
            this.curUrl = URLDecoder.decode(urlOri, "UTF-8").replace("///", "/").replace("file:/", "");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log("Bad encoding for url", 4);
        }
        this.curFile = new File(this.curUrl);
        if (this.curFile.exists()) {
            try {
                in = new BufferedInputStream(new FileInputStream(this.curFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log("Unable to find file : " + this.curUrl, 4);
            }
        }
        return in;
    }

    public String getExtention() {
        return Path.fromOSString((String)this.curUrl).getFileExtension();
    }

    public int getSizeOfStream() {
        long size = this.curFile.length();
        if (size > Integer.MAX_VALUE) {
            return 0;
        }
        return (int)this.curFile.length();
    }

    public String getConvertMhtUrl(String toConvert) {
        return toConvert.replace("///", "/").replace("file:/", "http:/");
    }
}

