/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.process;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractStepProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.IncompleteTagException;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.ITagExtensionService;
import org.eclipse.gendoc.tags.ITagHandler;
import org.eclipse.gendoc.tags.handlers.ITagHandlerService;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;
import org.eclipse.gendoc.tags.handlers.process.buffers.ITagAnalyserBuffer;
import org.eclipse.gendoc.tags.parsers.ITagParserService;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagAnalyserProcess
extends AbstractStepProcess {
    protected List<String> topLevelTagNames;
    private List<String> allTagNames;
    protected List<Pattern> tagNamePatterns;

    public TagAnalyserProcess() {
        this.init();
    }

    protected void step(Document document) throws GenDocException {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        ITagParserService tagParserService = (ITagParserService)GendocServices.getDefault().getService(ITagParserService.class);
        LinkedList<Node> nodesList = new LinkedList<Node>();
        boolean next = this.goToNextTextWithTag(document);
        if (!next) {
            return;
        }
        Node currentNode = document.getXMLParser().getCurrentNode();
        currentNode = documentService.cleanTags(currentNode, this.allTagNames);
        document.getXMLParser().setCurrentNode(currentNode);
        nodesList.add(currentNode);
        StringBuffer bufferedText = new StringBuffer(documentService.cleanTagContent(documentService.asText(currentNode), this.topLevelTagNames));
        List tags = tagParserService.parse(null, bufferedText.toString(), this.topLevelTagNames);
        while (next && !((ITag)tags.get(tags.size() - 1)).isComplete()) {
            next = this.goToNextText(document, bufferedText, nodesList);
            currentNode = document.getXMLParser().getCurrentNode();
            currentNode = documentService.cleanTags(currentNode, this.allTagNames);
            document.getXMLParser().setCurrentNode(currentNode);
            nodesList.add(currentNode);
            bufferedText.append(documentService.cleanTagContent(documentService.asText(currentNode), this.topLevelTagNames));
            tags = tagParserService.parse(null, bufferedText.toString(), this.topLevelTagNames);
        }
        if (!((ITag)tags.get(tags.size() - 1)).isComplete()) {
            ITag tag = (ITag)tags.get(tags.size() - 1);
            String tagIdFound = (String)tag.getAttributes().get(RegisteredTags.ID);
            if (tagIdFound == null) {
                throw new IncompleteTagException(tag.getName());
            }
            throw new IncompleteTagException(tag.getName(), tagIdFound);
        }
        if (tags.size() > 0) {
            this.executeAndInjectTags(document, documentService, nodesList, currentNode, tags);
        }
        this.worked(1);
    }

    protected void executeAndInjectTags(Document document, IDocumentService documentService, List<Node> nodesList, Node currentNode, List<ITag> tags) throws GenDocException, InvalidContentException {
        StringBuffer finalText = this.executeTags(tags);
        if (finalText != null) {
            this.injectTagsExecuted(document, documentService, nodesList, currentNode, finalText);
        }
    }

    protected void injectTagsExecuted(Document document, IDocumentService documentService, List<Node> nodesList, Node currentNode, StringBuffer finalText) throws InvalidContentException {
        ITagAnalyserBuffer buffer = (ITagAnalyserBuffer)GendocServices.getDefault().getService(ITagAnalyserBuffer.class);
        buffer.bufferize(document, currentNode, finalText, nodesList);
    }

    protected void postRun() {
        super.postRun();
        ITagAnalyserBuffer buffer = (ITagAnalyserBuffer)GendocServices.getDefault().getService(ITagAnalyserBuffer.class);
        buffer.flush();
    }

    protected boolean containsTag(String text) {
        boolean match = false;
        for (Pattern pattern : this.tagNamePatterns) {
            if (!pattern.matcher(text).matches()) continue;
            match = true;
            break;
        }
        return match;
    }

    protected StringBuffer executeTags(List<ITag> tags) throws GenDocException {
        boolean result = true;
        ITagHandlerService tagHandlerService = (ITagHandlerService)GendocServices.getDefault().getService(ITagHandlerService.class);
        StringBuffer finalText = new StringBuffer("");
        for (ITag tag : tags) {
            result &= this.executeOneTag(tagHandlerService, finalText, tag);
        }
        if (!result) {
            return null;
        }
        return finalText;
    }

    protected boolean executeOneTag(ITagHandlerService tagHandlerService, StringBuffer finalText, ITag tag) throws GenDocException {
        ITagHandler tagHandler = tagHandlerService.getHandlerFor(tag);
        if (tagHandler != null) {
            finalText.append(tagHandler.run(tag));
        } else {
            finalText.append(tag.getRawText());
        }
        return true;
    }

    protected boolean goToNextText(Document document, StringBuffer buffer, List<Node> nodesToRemove) throws InvalidContentException {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        this.worked(1);
        boolean next = document.next();
        Object extratedObject = document.get(Document.PROPERTY.text);
        Node currentNode = document.getXMLParser().getCurrentNode();
        while (next && this.isTextKO(nodesToRemove, extratedObject, currentNode)) {
            this.worked(1);
            next = document.next();
            if (!next) continue;
            currentNode = document.getXMLParser().getCurrentNode();
            extratedObject = document.get(Document.PROPERTY.text);
            if (!"".equals(extratedObject) || !documentService.isPara(currentNode.getNodeName()) || this.isAlreadyProcessed(nodesToRemove, currentNode)) continue;
            buffer.append(documentService.asText(currentNode));
            nodesToRemove.add(currentNode);
        }
        return next;
    }

    protected boolean goToNextTextWithTag(Document document) {
        boolean next = true;
        Object extratedObject = document.get(Document.PROPERTY.text);
        while (next && !this.isValidText(document, extratedObject)) {
            this.worked(1);
            next = document.next();
            if (!next) continue;
            extratedObject = document.get(Document.PROPERTY.text);
        }
        return next;
    }

    protected void init() {
        ITagExtensionService tagExtensionService = (ITagExtensionService)GendocServices.getDefault().getService(ITagExtensionService.class);
        this.topLevelTagNames = tagExtensionService.getTopLevelTagNames();
        this.allTagNames = tagExtensionService.getAllTagNames();
        this.tagNamePatterns = new LinkedList<Pattern>();
        for (String label : this.topLevelTagNames) {
            this.tagNamePatterns.add(Pattern.compile(".*<" + label + ".*>.*"));
            this.tagNamePatterns.add(Pattern.compile(".*</" + label + ".*>.*"));
        }
    }

    protected boolean isAlreadyProcessed(List<Node> nodesList, Node node) {
        boolean isAlreadyProcessed = false;
        Node parent = node;
        while (parent != null && !isAlreadyProcessed) {
            if (nodesList.contains(parent)) {
                isAlreadyProcessed = true;
            }
            parent = parent.getParentNode();
        }
        return isAlreadyProcessed;
    }

    protected boolean isTextKO(List<Node> nodesToRemove, Object extratedObject, Node currentNode) {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        boolean ko = false;
        boolean isAlreadyProcessed = this.isAlreadyProcessed(nodesToRemove, currentNode);
        if (isAlreadyProcessed) {
            ko = true;
        } else if ("".equals(extratedObject) && !documentService.isList(currentNode.getNodeName()) && !documentService.isTable(currentNode.getNodeName())) {
            ko = true;
        }
        return ko;
    }

    protected boolean isValidText(Document document, Object extratedObject) {
        boolean isValid = false;
        if (!"".equals(extratedObject) && this.containsTag((String)extratedObject)) {
            isValid = true;
        }
        return isValid;
    }
}

