/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.documents;

import java.awt.Toolkit;
import java.io.IOException;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.IImageManipulationService;
import org.eclipse.gendoc.documents.IImageManipulationServiceFactory;
import org.eclipse.gendoc.documents.IImageService;
import org.eclipse.gendoc.documents.ImageDimension;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.AdditionalResourceException;

public abstract class AbstractImageService
extends AbstractService
implements IImageService {
    @Override
    public String getFilePath(String imageId) throws AdditionalResourceException {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        IAdditionalResourceService additionalResourceService = documentService.getAdditionalResourceService();
        String filePath = additionalResourceService.addRunnableResourceToDocument(additionalResourceService.getResourceFolder(), imageId);
        return filePath;
    }

    @Override
    public String getImageId(String filePath) {
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        String imageId = documentService.getAdditionalResourceService().addImage(filePath.replaceAll("\\\\", "/"));
        return imageId;
    }

    protected double cmToPixels(double dim) {
        return dim * ((double)Toolkit.getDefaultToolkit().getScreenResolution() / 2.54);
    }

    protected double inchesToPixels(double dim) {
        return 2.54 * this.cmToPixels(dim);
    }

    protected double pixelToCm(double dim) {
        return dim * 2.54 / (double)Toolkit.getDefaultToolkit().getScreenResolution();
    }

    protected ImageDimension pixelToCm(ImageDimension dim) {
        ImageDimension dim2 = new ImageDimension();
        dim2.setWidth(this.pixelToCm(dim.getWidth()));
        dim2.setHeight(this.pixelToCm(dim.getHeight()));
        return dim2;
    }

    protected ImageDimension resizeImage(String imagePath, double frameWidth, double frameHeight, boolean keepH, boolean keepW, boolean maxH, boolean maxW) throws AdditionalResourceException {
        ImageDimension result = new ImageDimension();
        result.setWidth(frameWidth);
        result.setHeight(frameHeight);
        if (imagePath == null) {
            return result;
        }
        try {
            IImageManipulationServiceFactory imageManipulationServiceFactory = (IImageManipulationServiceFactory)GendocServices.getDefault().getService(IImageManipulationServiceFactory.class);
            IImageManipulationService imageInfoService = imageManipulationServiceFactory.getService(this.getExtension(imagePath));
            ImageDimension initialSize = imageInfoService.getImageDimension(imagePath);
            double imageHeight = initialSize.getHeight();
            double imageWidth = initialSize.getWidth();
            if (!keepH || !keepW) {
                if (!keepH && keepW) {
                    result.setWidth(frameWidth);
                    result.setHeight(imageHeight * frameWidth / imageWidth);
                } else if (!keepW && keepH) {
                    result.setWidth(frameHeight * imageWidth / imageHeight);
                    result.setHeight(frameHeight);
                } else if (!keepW && !keepH) {
                    result.setWidth(imageWidth);
                    result.setHeight(imageHeight);
                }
            }
            if (maxW && result.getWidth() >= frameWidth) {
                result.setWidth(frameWidth);
                result.setHeight(imageHeight * frameWidth / imageWidth);
            }
            if (maxH && result.getHeight() >= frameHeight) {
                result.setWidth(frameHeight * imageWidth / imageHeight);
                result.setHeight(frameHeight);
            }
        }
        catch (IOException e) {
            throw new AdditionalResourceException("Error when reading image file.", (Throwable)e);
        }
        return result;
    }

    private String getExtension(String imagePath) {
        String extension = "";
        int i = imagePath.lastIndexOf(46);
        if (i >= 0) {
            extension = imagePath.substring(i + 1);
        }
        return extension;
    }
}

