/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.docx;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Path;
import org.eclipse.gendoc.document.parser.documents.docx.DocxDocument;
import org.eclipse.gendoc.documents.AdditionalResourceService;
import org.eclipse.gendoc.documents.FileRunnable;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.IImageService;
import org.eclipse.gendoc.documents.MimeTypes;
import org.eclipse.gendoc.documents.ResourceRunnable;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.docx.DOCXDocumentService;
import org.eclipse.gendoc.services.docx.DOCXImageService;
import org.eclipse.gendoc.services.exception.AdditionalResourceException;
import org.eclipse.gendoc.services.exception.UnknownMimeTypeException;
import org.eclipse.gendoc.services.utils.DefaultImageExtensionUtils;

public class DOCXAdditionalResourceService
extends AdditionalResourceService {
    private static String DOCUMENT_XML_RELS = "document.xml.rels";
    private DOCXImageService imageHandler = new DOCXImageService();
    private StringBuffer relationShipsToAdd = new StringBuffer();
    protected Map<String, String> externalChunkMap = new LinkedHashMap<String, String>();

    public IImageService getImageService() {
        return this.imageHandler;
    }

    public void addAdditionalResourcesToDocument() throws AdditionalResourceException {
        String mediaLoc = this.getResourceFolder();
        DOCXDocumentService documentService = (DOCXDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        File unzipLoc = ((DocxDocument)documentService.getDocument()).getUnzipLocationDocumentFile();
        File mediaDir = new File(mediaLoc);
        if (!mediaDir.exists()) {
            mediaDir.mkdir();
        }
        this.addImagesResourcesToDocument(mediaLoc);
        this.addExternalResourcesToDocument(mediaLoc);
        String relsLocation = this.addRelationShips(unzipLoc);
        this.addMappingFiles(unzipLoc, relsLocation);
        this.modifyContentTypes(unzipLoc);
    }

    private void addMappingFiles(File unzipLoc, String relsLocation) throws AdditionalResourceException {
        ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
        File wordDir = new File(String.valueOf(unzipLoc.getAbsolutePath()) + this.SEPARATOR + "word");
        if (!wordDir.isDirectory()) {
            throw new AdditionalResourceException("Invalid mapping files directory :" + wordDir);
        }
        String[] fileNames = wordDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name = name.toLowerCase()).endsWith(".xml") && (name.contains("header") || name.contains("footer"));
            }
        });
        try {
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                File rels = new File(String.valueOf(relsLocation) + fileName + ".rels");
                if (this.relationShipsToAdd != null) {
                    StringBuffer relsContent;
                    if (rels.exists()) {
                        relsContent = new StringBuffer(this.readFileContent(rels));
                        Pattern p = Pattern.compile("</Relationships>");
                        Matcher m = p.matcher(relsContent);
                        if (m.find()) {
                            int index = m.start();
                            relsContent.insert(index, this.relationShipsToAdd.toString());
                            this.writeFileContent(rels, relsContent);
                        }
                    } else {
                        rels.createNewFile();
                        relsContent = new StringBuffer("<?xml version=\"1.0\" encoding=\"windows-1250\"?> <Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">");
                        relsContent.append(this.relationShipsToAdd);
                        relsContent.append("</Relationships>");
                        this.writeFileContent(rels, relsContent);
                    }
                }
                ++n2;
            }
        }
        catch (IOException iOException) {
            logger.log("Mapping files for headers and footers are not copied properly. Some images in headers and footers can be missing.", 1);
        }
    }

    private void modifyContentTypes(File unzipLoc) throws AdditionalResourceException {
        File contentTypes = new File(String.valueOf(unzipLoc.getAbsolutePath()) + this.SEPARATOR + "[Content_Types].xml");
        try {
            String contents = this.readFileContent(contentTypes);
            StringBuffer extensionsToAdd = new StringBuffer();
            for (String extension : this.fileExtensions) {
                if (contents.contains("<Default Extension=\"" + extension + "\"")) continue;
                try {
                    extensionsToAdd.append("<Default Extension=\"" + extension + "\" ContentType=\"" + MimeTypes.getMimeTypefromExtension((String)extension) + "\"/>");
                }
                catch (UnknownMimeTypeException e) {
                    throw new AdditionalResourceException("Additional resource with extension '" + extension + "' is not supported inside generated DOCX file.", (Throwable)e);
                }
            }
            extensionsToAdd.append("</Types>");
            this.writeFileContent(contentTypes, new StringBuffer(contents.replace("</Types>", extensionsToAdd.toString())));
        }
        catch (IOException iOException) {
            throw new AdditionalResourceException("DOCX document generated cannot be completed: Problem with content types");
        }
    }

    private String addRelationShips(File unzipLoc) throws AdditionalResourceException {
        try {
            Pattern p = Pattern.compile("</Relationships>");
            String relsLocation = String.valueOf(unzipLoc.getAbsolutePath()) + this.SEPARATOR + "word" + this.SEPARATOR + "_rels" + this.SEPARATOR;
            File rels = new File(String.valueOf(relsLocation) + DOCUMENT_XML_RELS);
            StringBuffer relsContent = new StringBuffer(this.readFileContent(rels));
            Matcher m = p.matcher(relsContent);
            if (m.find()) {
                int index = m.start();
                relsContent.insert(index, this.relationShipsToAdd);
                this.writeFileContent(rels, relsContent);
            }
            return relsLocation;
        }
        catch (IOException e) {
            throw new AdditionalResourceException((Throwable)e);
        }
    }

    public String addRunnableResourceToDocument(String mediaLoc, String diagramKey) throws AdditionalResourceException {
        if (this.runnableMap.get(diagramKey) == null) {
            throw new AdditionalResourceException("Image with id '" + diagramKey + "' cannot be found.");
        }
        ResourceRunnable runnable = (ResourceRunnable)this.runnableMap.get(diagramKey);
        String extension = this.getFileExtensionFromRunnable(runnable);
        runnable.run(diagramKey, this.getResourceFolder());
        String newRelationShips = this.newRelationship(diagramKey, String.valueOf(diagramKey) + "." + extension);
        if (this.relationShipsToAdd.indexOf(newRelationShips) == -1) {
            this.relationShipsToAdd.append(newRelationShips);
        }
        this.fileExtensions.add(extension);
        return String.valueOf(this.getResourceFolder()) + this.SEPARATOR + diagramKey + "." + extension;
    }

    private String getFileExtensionFromRunnable(ResourceRunnable runnable) {
        if (runnable instanceof FileRunnable) {
            return ((FileRunnable)runnable).getFileExtension();
        }
        return DefaultImageExtensionUtils.getDefaultImageExtension();
    }

    private void addImagesResourcesToDocument(String mediaLoc) throws AdditionalResourceException {
        for (String imageKey : this.imagesMap.keySet()) {
            File imageFile = new File((String)this.imagesMap.get(imageKey));
            String imageLink = String.valueOf(imageKey) + "." + Path.fromOSString((String)imageFile.getAbsolutePath()).getFileExtension();
            try {
                this.copyImage(imageFile, String.valueOf(mediaLoc) + this.SEPARATOR + imageLink);
            }
            catch (IOException e) {
                throw new AdditionalResourceException("File '" + imageFile.getAbsolutePath() + "'cannot be copied.", (Throwable)e);
            }
            this.relationShipsToAdd.append(this.newRelationship(imageKey, imageLink));
            if (imageFile.exists()) continue;
            throw new AdditionalResourceException("An image cannot be generated and has been replaced by a red cross. Cause: No image found at location:" + imageFile.getAbsolutePath());
        }
    }

    private String newRelationship(String imageKey, String imageLink) {
        return "<Relationship Id=\"" + imageKey + "\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/image\" Target=\"media/" + imageLink + "\"/>";
    }

    public String getRelativeResourceFolder() {
        return "word" + this.SEPARATOR + "media";
    }

    public String includeFile(String fullPath) {
        String id = this.generateUniqueId();
        this.externalChunkMap.put(id, fullPath);
        this.fileExtensions.add(Path.fromOSString((String)fullPath).getFileExtension());
        return id;
    }

    public void includeExtensions(Set<String> fileExt) {
        this.fileExtensions.addAll(fileExt);
    }

    private void addExternalResourcesToDocument(String mediaLoc) throws AdditionalResourceException {
        for (String key : this.externalChunkMap.keySet()) {
            File file = new File(this.externalChunkMap.get(key));
            String externalLink = String.valueOf(key) + "." + Path.fromOSString((String)file.getAbsolutePath()).getFileExtension();
            try {
                this.copyFile(file, String.valueOf(mediaLoc) + this.SEPARATOR + externalLink);
            }
            catch (IOException e) {
                throw new AdditionalResourceException("File '" + file.getAbsolutePath() + "'cannot be copied.", (Throwable)e);
            }
            this.relationShipsToAdd.append(this.newExternalChunkRelationship(key, externalLink));
            if (file.exists()) continue;
            throw new AdditionalResourceException("An external file cannot be generated. Cause: No file found at location:" + file.getAbsolutePath());
        }
    }

    private String newExternalChunkRelationship(String key, String target) {
        return "<Relationship Id=\"" + key + "\" Type=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships/aFChunk\" Target=\"media/" + target + "\"/>";
    }
}

