/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.documents.image.svg.impl;

import java.io.IOException;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gendoc.documents.IImageManipulationService;
import org.eclipse.gendoc.documents.ImageDimension;
import org.eclipse.gendoc.services.exception.AdditionalResourceException;
import org.w3c.dom.svg.SVGDocument;

public class SVGImageManipulationService
implements IImageManipulationService {
    private static int NB_PIXEL_PER_INCH = 96;
    private static int NB_PIXEL_PER_CM = 38;

    public ImageDimension getImageDimension(String imagePath) throws IOException, AdditionalResourceException {
        String uri = "file:/" + imagePath;
        if (uri == null || !uri.toLowerCase().endsWith("svg")) {
            throw new AdditionalResourceException("Cannot get dimension of image '" + uri + "'.");
        }
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parser);
        try {
            SVGDocument doc = f.createSVGDocument(uri);
            String width = doc.getDocumentElement().getAttributeNS(null, "width");
            String height = doc.getDocumentElement().getAttributeNS(null, "height");
            ImageDimension result = new ImageDimension();
            result.setWidth(100.0);
            result.setHeight(100.0);
            try {
                double dbWidth;
                double dbHeight;
                if (height.endsWith("in")) {
                    height = height.replace("in", "");
                    dbHeight = Double.valueOf(height);
                    result.setHeight(dbHeight * (double)NB_PIXEL_PER_INCH);
                } else if (height.endsWith("cm")) {
                    height = height.replace("cm", "");
                    dbHeight = Double.valueOf(height);
                    result.setHeight(dbHeight * (double)NB_PIXEL_PER_CM);
                } else {
                    result.setHeight(Double.valueOf(height).doubleValue());
                }
                if (width.endsWith("in")) {
                    width = width.replace("in", "");
                    dbWidth = Double.valueOf(width);
                    result.setWidth(dbWidth * (double)NB_PIXEL_PER_INCH);
                } else if (width.endsWith("cm")) {
                    width = width.replace("cm", "");
                    dbWidth = Double.valueOf(width);
                    result.setWidth(dbWidth * (double)NB_PIXEL_PER_CM);
                } else {
                    result.setWidth(Double.valueOf(width).doubleValue());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return result;
        }
        catch (IOException e) {
            throw new AdditionalResourceException("Cannot load image '" + uri + "'.", (Throwable)e);
        }
    }

    public String renameExtension(String extension) {
        return extension;
    }

    public void transform(IPath path) {
    }
}

