/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.html.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Scanner;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.InvalidTemplateParameterException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.handlers.AbstractPrePostTagHandler;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;
import org.eclipse.gendoc.tags.html.IHtmlService;

public class RichTextTagHandler
extends AbstractPrePostTagHandler {
    private static final String DEFAULT_RICH_TEXT = "HTML";

    public String doRun(ITag tag) throws GenDocException {
        String filePath;
        Map attributes;
        String value = super.doRun(tag);
        IHtmlService richTextService = (IHtmlService)GendocServices.getDefault().getService(IHtmlService.class);
        if ((value == null || value.isEmpty()) && (attributes = tag.getAttributes()) != null && (filePath = (String)attributes.get("filePath")) != null && !filePath.isEmpty()) {
            try {
                value = this.getFileContent(filePath);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
                logger.log("Cannot find RichText file at : " + filePath, 4);
            }
        }
        value = richTextService.convert(value);
        return value;
    }

    private String getFileContent(String filePath) throws InvalidTemplateParameterException, FileNotFoundException {
        IConfigurationService configService = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
        filePath = configService.replaceParameters(filePath);
        File file = new File(filePath.replaceAll("\\\\", "/"));
        String content = new Scanner(file).useDelimiter("\\Z").next();
        return content.trim();
    }

    protected String runAttributes(ITag tag, String value) throws GenDocException {
        IHtmlService richTextService = (IHtmlService)GendocServices.getDefault().getService(IHtmlService.class);
        Map attributes = tag.getAttributes();
        if (attributes != null) {
            String filePath;
            String format = (String)attributes.get("format");
            format = format != null ? format.toUpperCase() : DEFAULT_RICH_TEXT;
            String includePic = (String)attributes.get("includePic");
            if ((value == null || value.isEmpty()) && (filePath = (String)attributes.get("filePath")) != null) {
                if (format == null || format.isEmpty()) {
                    if (filePath.endsWith(".rtf")) {
                        format = "RTF";
                    } else if (filePath.endsWith(".html") || filePath.endsWith(".xhtml") || filePath.endsWith(".mhl")) {
                        format = DEFAULT_RICH_TEXT;
                    }
                }
                if ((includePic == null || includePic.isEmpty()) && filePath.endsWith(".mhl")) {
                    includePic = "true";
                }
            }
            richTextService.setFormat(format);
            richTextService.setVersion((String)attributes.get("version"));
            richTextService.setInTable((String)attributes.get("insideTable"));
            richTextService.setIncludePic(includePic);
        }
        return value;
    }
}

