/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.gmf.service;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gendoc.documents.IImageManipulationService;
import org.eclipse.gendoc.documents.IImageManipulationServiceFactory;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IGendocDiagnostician;
import org.eclipse.gendoc.services.IService;
import org.eclipse.gmf.runtime.notation.Diagram;

public interface IDiagramRenderer
extends IService {
    public List<EditPart> renderDiagram(Diagram var1, List<EObject> var2, IPath var3, FileFormat var4, NullProgressMonitor var5) throws CoreException;

    public static enum FileFormat {
        PNG,
        JPEG,
        GIF,
        BMP,
        JPG,
        SVG,
        EMF;


        public FileFormat getExtension() {
            IImageManipulationServiceFactory imageManipulationServiceFactory = (IImageManipulationServiceFactory)GendocServices.getDefault().getService(IImageManipulationServiceFactory.class);
            IImageManipulationService imageManipulationService = imageManipulationServiceFactory.getService(this.name().toLowerCase());
            return FileFormat.transformToFormat(imageManipulationService.renameExtension(this.name()));
        }

        public String getFullExtension() {
            return "." + this.getExtension().name().toLowerCase();
        }

        public static FileFormat transformToFormat(String ext) {
            try {
                FileFormat format = FileFormat.valueOf(ext.toUpperCase());
                return format;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IGendocDiagnostician diagnostician = (IGendocDiagnostician)GendocServices.getDefault().getService(IGendocDiagnostician.class);
                String message = "The format " + ext + " is not supported";
                diagnostician.addDiagnostic((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gendoc.tags.handlers", 0, message, null));
                return FileFormat.valueOf(ext);
            }
        }
    }
}

