/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.process;

import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.gendoc.process.IProcess;
import org.eclipse.gendoc.process.impl.ProcessesExtensionPoint;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IProgressMonitorService;
import org.eclipse.gendoc.services.exception.GenDocException;

public abstract class AbstractProcess
implements IExecutableExtension,
IProcess {
    private IProgressMonitor progressMonitor;
    private String label;

    public String getLabel() {
        return this.label;
    }

    public IProgressMonitor getMonitor() {
        return this.progressMonitor;
    }

    @Override
    public final void run() throws GenDocException {
        IProgressMonitorService progressMonitorService = (IProgressMonitorService)GendocServices.getDefault().getService(IProgressMonitorService.class);
        this.progressMonitor = SubMonitor.convert((IProgressMonitor)progressMonitorService.subMonitor(1, this.getLabel()), (int)this.getTotalWork());
        this.preRun();
        this.doRun();
        this.postRun();
        this.progressMonitor.done();
    }

    protected void postRun() {
    }

    protected void preRun() {
    }

    @Override
    public final void run(Semaphore s) throws GenDocException {
        try {
            this.run();
        }
        finally {
            s.release();
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        String labelAttribute;
        this.label = labelAttribute = config.getAttribute(ProcessesExtensionPoint.PROCESS_LABEL);
    }

    protected abstract void doRun() throws GenDocException;

    protected abstract int getTotalWork();

    protected boolean isCanceled() {
        return this.progressMonitor.isCanceled();
    }

    protected void worked(int work) {
        this.progressMonitor.worked(work);
    }
}

