/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.acceleo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.generation.strategy.PreviewStrategy;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.acceleo.model.mtl.resource.AcceleoResourceFactoryRegistry;
import org.eclipse.acceleo.parser.AcceleoParser;
import org.eclipse.acceleo.parser.AcceleoSourceBuffer;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gendoc.script.acceleo.GendocResourceFactory;
import org.eclipse.gendoc.script.acceleo.Messages;
import org.eclipse.gendoc.script.acceleo.ServicesExtension;
import org.eclipse.gendoc.script.acceleo.exception.AcceleoParsingException;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.GenerationException;
import org.eclipse.gendoc.services.exception.ParsingException;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.ExpressionsPackage;

public class Generator {
    private static String tempDir = System.getProperty("java.io.tmpdir");
    public static String templateNames = "aTemplate";
    private Module module;
    private final EObject model;
    private ResourceSet resourceSet;

    public Generator(EObject model, String script) throws IOException, ParsingException {
        this(model, script, null);
    }

    public Generator(EObject model, String script, List<URI> otherDependencies) throws IOException, ParsingException {
        String moduleName = String.valueOf(tempDir) + templateNames + ".emtl";
        this.resourceSet = new ResourceSetImpl();
        this.registerResourceFactories(this.resourceSet);
        this.registerPackages(this.resourceSet);
        this.model = model;
        AcceleoParser parser = new AcceleoParser();
        StringBuffer textBuffer = new StringBuffer(script);
        Resource r = this.resourceSet.createResource(URI.createFileURI((String)moduleName));
        AcceleoSourceBuffer source = new AcceleoSourceBuffer(textBuffer);
        LinkedList<URI> resources = new LinkedList<URI>(ServicesExtension.getInstance().getResources());
        if (otherDependencies != null) {
            resources.addAll(otherDependencies);
        }
        parser.parse(source, r, resources);
        if (!source.getProblems().getList().isEmpty()) {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log(String.valueOf(source.getProblems().toString()) + ":\n" + source.getBuffer().toString(), 4);
            throw new AcceleoParsingException(source.getProblems().toString());
        }
        if (r.getContents().size() > 0) {
            this.module = (Module)r.getContents().get(0);
        }
    }

    private void registerResourceFactories(ResourceSet r) {
        r.setResourceFactoryRegistry((Resource.Factory.Registry)new AcceleoResourceFactoryRegistry(r.getResourceFactoryRegistry()));
        r.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        r.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        r.getResourceFactoryRegistry().getProtocolToFactoryMap().put(Messages.GendocResourceFactory_BUNDLE_URI_SCHEME, new GendocResourceFactory());
    }

    private void registerPackages(ResourceSet r) {
        r.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        r.getPackageRegistry().put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
        r.getPackageRegistry().put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
        r.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore", (Object)this.getOCLStdLibPackage());
    }

    public Module getModule() {
        return this.module;
    }

    protected URI createTemplateURI(String entry) {
        return URI.createFileURI((String)URI.decode((String)entry));
    }

    private EPackage getOCLStdLibPackage() {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();
        EcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();
        return (EPackage)EcoreUtil.getRootContainer((EObject)((EObject)environment.getOCLStandardLibrary().getBag()));
    }

    public String doGenerate(Monitor monitor) throws IOException, GenerationException {
        Map<String, String> result;
        File targetFolder = new File(tempDir);
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        if ((result = this.doGenerate(templateNames, new ArrayList(), targetFolder, monitor)).size() > 1) {
            throw new GenerationException("More than one file has been generated after template execution.");
        }
        if (result.size() == 1) {
            return result.values().toArray(new String[0])[0];
        }
        throw new GenerationException("No file has been generated after template execution.");
    }

    public Map<String, String> doGenerate(String templateName, List<? extends Object> arguments, File generationRoot, Monitor monitor) {
        AcceleoService service = new AcceleoService((IAcceleoGenerationStrategy)new PreviewStrategy());
        Template template = this.findTemplate(templateName, arguments.size() + 1);
        HashMap<String, String> previewResult = new HashMap<String, String>();
        EClassifier argumentType = (EClassifier)((Variable)template.getParameter().get(0)).getType();
        if (argumentType.isInstance((Object)this.model)) {
            ArrayList<? extends Object> actualArguments = new ArrayList<Object>();
            actualArguments.add(this.model);
            actualArguments.addAll(arguments);
            previewResult.putAll(service.doGenerateTemplate(template, actualArguments, generationRoot, monitor));
        }
        service.dispose();
        return previewResult;
    }

    private Template findTemplate(String templateName, int argumentCount) {
        for (ModuleElement element : this.module.getOwnedModuleElement()) {
            Template template;
            if (!(element instanceof Template) || (template = (Template)element).getVisibility() != VisibilityKind.PUBLIC || !templateName.equals(template.getName()) || template.getParameter().size() != argumentCount) continue;
            return template;
        }
        throw new AcceleoEvaluationException(AcceleoEngineMessages.getString((String)"AcceleoService.UndefinedTemplate", (Object[])new Object[]{templateName, this.module.getName()}));
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }
}

