/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.odt;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Path;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.ZipDocument;
import org.eclipse.gendoc.documents.AdditionalResourceService;
import org.eclipse.gendoc.documents.FileRunnable;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.documents.IImageService;
import org.eclipse.gendoc.documents.ResourceRunnable;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.exception.AdditionalResourceException;
import org.eclipse.gendoc.services.odt.ODTImageService;
import org.eclipse.gendoc.services.utils.DefaultImageExtensionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODTAdditionalResourceService
extends AdditionalResourceService {
    private static final String MANIFEST_XML = "manifest.xml";
    private static final String META_INF = "META-INF";
    ODTImageService imageHandler = new ODTImageService();

    public void addAdditionalResourcesToDocument() throws AdditionalResourceException {
        String pictureLoc = this.getResourceFolder();
        File pictureDir = new File(pictureLoc);
        if (!pictureDir.exists()) {
            pictureDir.mkdir();
        }
        this.addImagesResourcesToDocument(pictureLoc);
        if (pictureDir.listFiles().length > 0) {
            this.addPicturesToManifest(pictureDir.listFiles());
        }
    }

    private void addPicturesToManifest(File[] files) throws AdditionalResourceException {
        File f = this.getMetaInfFile();
        if (f != null) {
            try {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    StringBuffer relsContent = new StringBuffer(this.readFileContent(f));
                    Pattern p = Pattern.compile("</manifest:manifest>");
                    Matcher m = p.matcher(relsContent);
                    if (m.find()) {
                        int index = m.start();
                        relsContent.insert(index, this.newManifestEntry(file));
                        this.writeFileContent(f, relsContent);
                    }
                    ++n2;
                }
            }
            catch (IOException e) {
                throw new AdditionalResourceException((Throwable)e);
            }
        } else {
            ILogger logger = (ILogger)GendocServices.getDefault().getService(ILogger.class);
            logger.log("Error during additional resources addition, the manifest.xml file cannot be found in META-INF", 16);
        }
    }

    private String newManifestEntry(File file) {
        return "<manifest:file-entry manifest:media-type=\"image/" + file.getName().substring(file.getName().lastIndexOf(".")) + "\" manifest:full-path=\"Pictures/" + file.getName() + "\" />";
    }

    public String addRunnableResourceToDocument(String mediaLoc, String diagramKey) throws AdditionalResourceException {
        if (this.runnableMap.get(diagramKey) == null) {
            throw new AdditionalResourceException("Image with id '" + diagramKey + "' cannot be found.");
        }
        ResourceRunnable runnable = (ResourceRunnable)this.runnableMap.get(diagramKey);
        String extension = this.getFileExtensionFromRunnable(runnable);
        runnable.run(diagramKey, this.getResourceFolder());
        return String.valueOf(this.getResourceFolder()) + this.SEPARATOR + diagramKey + "." + extension;
    }

    private String getFileExtensionFromRunnable(ResourceRunnable runnable) {
        if (runnable instanceof FileRunnable) {
            return ((FileRunnable)runnable).getFileExtension();
        }
        return DefaultImageExtensionUtils.getDefaultImageExtension();
    }

    private void addImagesResourcesToDocument(String pictureLoc) throws AdditionalResourceException {
        int notGeneratedImages = 0;
        for (String imageKey : this.imagesMap.keySet()) {
            File imageFile = new File((String)this.imagesMap.get(imageKey));
            String imageLink = String.valueOf(imageKey) + "." + Path.fromOSString((String)imageFile.getAbsolutePath()).getFileExtension();
            try {
                this.copyImage(imageFile, String.valueOf(pictureLoc) + this.SEPARATOR + imageLink);
            }
            catch (IOException e) {
                throw new AdditionalResourceException("File '" + imageFile.getAbsolutePath() + "'cannot be copied.", (Throwable)e);
            }
            if (imageFile.exists()) continue;
            ++notGeneratedImages;
        }
        if (notGeneratedImages == 1) {
            throw new AdditionalResourceException("An image cannot be generated and has been replaced by a red cross. TIP: Check attribute 'filePath' or 'object' of the <image> tag.");
        }
        if (notGeneratedImages > 1) {
            throw new AdditionalResourceException(String.valueOf(notGeneratedImages) + " images cannot be generated and have been replaced by a red cross. TIP: Check attribute 'filePath' or 'object' of the <image> tag.");
        }
    }

    public IImageService getImageService() {
        return new ODTImageService();
    }

    protected String getRelativeResourceFolder() {
        return "Pictures";
    }

    public String includeFile(String filePath) {
        return null;
    }

    public File getMetaInfFile() {
        File unzipLoc;
        String mediaLoc;
        File metainfDir;
        IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        Document document = documentService.getDocument();
        if (document instanceof ZipDocument && (metainfDir = new File(mediaLoc = String.valueOf((unzipLoc = ((ZipDocument)document).getUnzipLocationDocumentFile()).getAbsolutePath()) + this.SEPARATOR + META_INF)).listFiles().length > 0) {
            File[] fileArray = metainfDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().equals(MANIFEST_XML)) {
                    return file;
                }
                ++n2;
            }
        }
        return null;
    }

    public void includeExtensions(Set<String> fileExt) {
    }
}

