/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.html.files;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.gendoc.bundle.acceleo.html.files.HtmlStripTagVisitor;
import org.eclipse.gendoc.bundle.acceleo.html.files.HtmlToTextVisitor;
import org.eclipse.gendoc.bundle.acceleo.html.files.HtmlUtils;
import org.eclipse.gendoc.bundle.acceleo.html.files.TextToHtmlBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class HtmlService {
    private static XPath XPATH = XPathFactory.newInstance().newXPath();
    private static NullOutputStream NULL_OUTPUT_STREAM = new NullOutputStream();

    public static boolean isHtml(String input) {
        return HtmlService.isHtml(HtmlService.parseHtml(input));
    }

    public static String stripHtmlTags(String input) {
        Document doc = HtmlService.parseHtml(input);
        if (!HtmlService.isHtml(doc)) {
            return input;
        }
        HtmlStripTagVisitor visitor = new HtmlStripTagVisitor();
        HtmlUtils.visit(HtmlService.getBodyElement(doc), visitor);
        return visitor.toString();
    }

    public static String htmlToText(String input) {
        Document doc = HtmlService.parseHtml(input);
        if (!HtmlService.isHtml(doc)) {
            return input;
        }
        HtmlToTextVisitor visitor = new HtmlToTextVisitor();
        HtmlUtils.visit(HtmlService.getBodyElement(doc), visitor);
        return visitor.toString();
    }

    public static String textToHtml(String input) {
        Document doc = HtmlService.parseHtml(input);
        if (HtmlService.isHtml(doc)) {
            return input;
        }
        TextToHtmlBuilder htmlBuilder = new TextToHtmlBuilder();
        htmlBuilder.addText(input);
        return htmlBuilder.toString();
    }

    private static Tidy initParser() {
        Tidy t = new Tidy();
        Properties oProps = new Properties();
        oProps.setProperty("new-blocklevel-tags", "hhh");
        t.setMakeClean(true);
        t.setXmlOut(true);
        t.setQuiet(true);
        t.setRawOut(true);
        t.setOnlyErrors(false);
        t.setShowWarnings(false);
        return t;
    }

    private static Element getBodyElement(Document doc) {
        try {
            return (Element)XPATH.evaluate("/html/body", doc, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            return null;
        }
    }

    public static Document parseHtml(String input) {
        Tidy t = HtmlService.initParser();
        Document doc = t.parseDOM((InputStream)new ByteArrayInputStream(input.getBytes()), (OutputStream)NULL_OUTPUT_STREAM);
        return doc;
    }

    private static boolean isHtml(Document doc) {
        Element root = HtmlService.getBodyElement(doc);
        if (root == null) {
            return false;
        }
        NodeList nl = root.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (!(nl.item(i) instanceof Text)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void main(String[] args) {
        String txt = "The operational support functionality of the digital business systems is a common platform that can support the operatrional support needs of the network and operational domains for a service provider.\nA base set of functions with base interfaces is used to build the main functions of the OSS, but not all.\n\na) *Service and Resource Life Cycle Management Function*";
        System.out.println(HtmlService.textToHtml(txt));
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

