/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.pptx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.openoffice.OpenOfficeDocument;
import org.eclipse.gendoc.document.parser.pptx.PPTXDocument;
import org.eclipse.gendoc.document.parser.pptx.PPTXHelper;
import org.eclipse.gendoc.document.parser.pptx.PPTXParser;
import org.eclipse.gendoc.document.parser.pptx.PPTXRef;
import org.eclipse.gendoc.document.parser.pptx.XPathPptxUtils;
import org.eclipse.gendoc.documents.IDocumentManager;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.pptx.PPTXDocumentService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PPTXFlattenProcess
extends AbstractProcess {
    protected void doRun() throws GenDocException {
        IDocumentService docService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        if (!(docService instanceof PPTXDocumentService)) {
            return;
        }
        IDocumentManager documentManager = (IDocumentManager)GendocServices.getDefault().getService(IDocumentManager.class);
        Document document = documentManager.getDocTemplate();
        document.jumpToStart();
        PPTXParser parser = (PPTXParser)document.getXMLParser();
        Element gendocExt = (Element)parser.getDocument().getDocumentElement().appendChild(parser.getDocument().createElementNS("http://gendoc.eclipse.org/main", "gendoc:flatSlide"));
        gendocExt.setAttribute("xmlns:gendoc", "http://gendoc.eclipse.org/main");
        do {
            Node item;
            if (!"p:sldId".equals(parser.getCurrentNode().getNodeName()) || (item = parser.getCurrentNode().getAttributes().getNamedItem("r:id")) == null) continue;
            String relId = item.getNodeValue();
            try {
                XMLParser slideParser = parser.loadExplicitPartDocument("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide", relId);
                this.createSlideFlattenStructure((OpenOfficeDocument)document, slideParser, gendocExt);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } while (document.next());
    }

    protected void createSlideFlattenStructure(OpenOfficeDocument document, XMLParser parser, Element ownerEl) {
        org.w3c.dom.Document doc = ownerEl.getOwnerDocument();
        PPTXRef slideRef = new PPTXRef(document.getRelativePath(parser), XPathPptxUtils.INSTANCE.getNodeXPath(doc.getDocumentElement()));
        StringBuffer paragRefs = new StringBuffer();
        Element startSlide = (Element)ownerEl.appendChild(doc.createElement("gendoc:ref"));
        startSlide.setAttribute("type", PPTXHelper.GENDOC_REF_TYPE.startSlide.name());
        startSlide.setAttribute("ref", slideRef.toString());
        try {
            NodeList parasNodeList = XPathPptxUtils.INSTANCE.evaluateNodes((Node)parser.getDocument(), "//a:p");
            ArrayList<Node> paras = new ArrayList<Node>();
            int i = 0;
            while (i < parasNodeList.getLength()) {
                paras.add(parasNodeList.item(i));
                ++i;
            }
            Collections.sort(paras, new TextBoxNodeComparator((PPTXDocument)document, parser));
            i = 0;
            while (i < paras.size()) {
                Element n = (Element)paras.get(i);
                String xpathToEl = XPathPptxUtils.INSTANCE.getNodeXPath(n);
                n = (Element)doc.importNode(n, true);
                String ref = new PPTXRef(xpathToEl).toString();
                n.setAttributeNS("http://gendoc.eclipse.org/main", "gendoc:ref", ref);
                if (paragRefs.length() != 0) {
                    paragRefs.append(",");
                }
                paragRefs.append(ref);
                ownerEl.appendChild(n);
                ++i;
            }
        }
        catch (XPathExpressionException parasNodeList) {
            // empty catch block
        }
        Element endSlide = (Element)ownerEl.appendChild(doc.createElement("gendoc:ref"));
        endSlide.setAttribute("type", PPTXHelper.GENDOC_REF_TYPE.endSlide.name());
        endSlide.setAttribute("ref", slideRef.toString());
        startSlide.setAttribute("paras", paragRefs.toString());
    }

    protected int getTotalWork() {
        return 1;
    }

    private static class TextBoxNodeComparator
    implements Comparator<Node> {
        private PPTXDocument pptxDocument;
        private XMLParser slideParser;

        public TextBoxNodeComparator(PPTXDocument doc, XMLParser slideParser) {
            this.slideParser = slideParser;
            this.pptxDocument = doc;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(Node o1, Node o2) {
            long x2;
            long x1;
            block7: {
                Node xfrm2;
                Node xfrm1;
                block6: {
                    block5: {
                        try {
                            xfrm1 = this.getXFrameNode(o1);
                            xfrm2 = this.getXFrameNode(o2);
                            if (xfrm1 != null || xfrm2 == null) break block5;
                            return Integer.MAX_VALUE;
                        }
                        catch (XPathExpressionException e) {
                            return 0;
                        }
                    }
                    if (xfrm2 != null || xfrm1 == null) break block6;
                    return Integer.MIN_VALUE;
                }
                long y1 = XPathPptxUtils.INSTANCE.evaluateNumber(xfrm1, "./a:off/@y", Integer.MAX_VALUE);
                long y2 = XPathPptxUtils.INSTANCE.evaluateNumber(xfrm2, "./a:off/@y", Integer.MAX_VALUE);
                if (Math.abs(y1 - y2) >= 100L) return (int)(y1 - y2);
                x1 = XPathPptxUtils.INSTANCE.evaluateNumber(xfrm1, "./a:off/@x", Integer.MAX_VALUE);
                if (Math.abs(x1 - (x2 = (long)XPathPptxUtils.INSTANCE.evaluateNumber(xfrm2, "./a:off/@x", Integer.MAX_VALUE))) >= 100L) break block7;
                return 0;
            }
            return (int)(x1 - x2);
        }

        private Node getXFrameNode(Node par) throws XPathExpressionException {
            Element xfrm = (Element)XPathPptxUtils.INSTANCE.evaluateNode(par, "./ancestor::p:sp/p:spPr/a:xfrm");
            if (xfrm == null) {
                Node phNode = XPathPptxUtils.INSTANCE.evaluateNode(par, "./ancestor::p:sp/p:nvSpPr/p:nvPr/p:ph");
                if (phNode == null) {
                    return null;
                }
                String idx = XPathPptxUtils.INSTANCE.evaluateText(phNode, "./@idx");
                String type = XPathPptxUtils.INSTANCE.evaluateText(phNode, "./@type");
                String relsPath = this.pptxDocument.getRelativePath(this.slideParser);
                relsPath = String.valueOf(relsPath.replace("/slides/", "/slides/_rels/")) + ".rels";
                XMLParser slideRelsPath = this.pptxDocument.getSubdocument(relsPath);
                String layoutFile = XPathPptxUtils.INSTANCE.evaluateText((Node)slideRelsPath.getDocument(), "//rel:Relationship[@Type='http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideLayout']/@Target");
                XMLParser slideLayoutParser = this.pptxDocument.getSubdocument(layoutFile = "/ppt/slideLayouts/" + layoutFile.substring(layoutFile.lastIndexOf(47) + 1));
                xfrm = (Element)XPathPptxUtils.INSTANCE.evaluateNode((Node)slideLayoutParser.getDocument(), "//p:sp[p:nvSpPr/p:nvPr/p:ph[@idx='" + idx + "']]/p:spPr/a:xfrm");
                if (xfrm == null) {
                    xfrm = (Element)XPathPptxUtils.INSTANCE.evaluateNode((Node)slideLayoutParser.getDocument(), "//p:sp[p:nvSpPr/p:nvPr/p:ph[@type='" + type + "']]/p:spPr/a:xfrm");
                }
            }
            return xfrm;
        }
    }
}

