/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.html.files;

import org.eclipse.gendoc.bundle.acceleo.html.files.IHtmlVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class HtmlUtils {
    public static void visit(Node node, IHtmlVisitor visitor) {
        if (node instanceof Document) {
            boolean visitChildren = visitor.visitDocument((Document)node);
            if (visitChildren) {
                HtmlUtils.visitChildren(node, visitor);
            }
            visitor.visitDocumentAfter((Document)node);
        } else if (node instanceof Element) {
            boolean visitChildren = visitor.visitElement((Element)node);
            if (visitChildren) {
                HtmlUtils.visitChildren(node, visitor);
            }
            visitor.visitElementAfter((Element)node);
        } else if (node instanceof Text) {
            visitor.visitText((Text)node);
        } else {
            HtmlUtils.visitChildren(node, visitor);
        }
    }

    private static void visitChildren(Node node, IHtmlVisitor visitor) {
        NodeList nl = node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            HtmlUtils.visit(n, visitor);
            ++i;
        }
    }
}

