/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.papyrus.service;

import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gendoc.bundle.acceleo.papyrus.service.PapyrusModelLoaderService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.IService;
import org.eclipse.gendoc.services.exception.ModelNotFoundException;
import org.eclipse.gendoc.tags.handlers.IEMFModelLoaderService;
import org.eclipse.gendoc.tags.handlers.impl.context.ContextService;
import org.eclipse.gendoc.tags.handlers.impl.context.EMFModelLoaderService;

public class PapyrusContextService
extends ContextService {
    public void setModel(String modelPath) throws ModelNotFoundException {
        EMFModelLoaderService loader;
        if (this.isPapyrusModel(modelPath = this.normalizePath(modelPath)) && !((loader = (EMFModelLoaderService)GendocServices.getDefault().getService(IEMFModelLoaderService.class)) instanceof PapyrusModelLoaderService)) {
            PapyrusModelLoaderService emfService = new PapyrusModelLoaderService(this.getDiURI(modelPath));
            emfService.setServiceId("EMFModelLoaderService");
            GendocServices.getDefault().setService(IEMFModelLoaderService.class, (IService)emfService);
        }
        modelPath = URI.createURI((String)modelPath, (boolean)true).toString();
        super.setModel(modelPath);
    }

    protected boolean isPapyrusModel(String modelPath) {
        return this.exists(this.getDiURI(modelPath));
    }

    public URI getModelURI(String modelPath) {
        URI modelUri = null;
        try {
            modelUri = URI.createURI((String)modelPath);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (!this.isValid(modelUri)) {
            modelUri = URI.createFileURI((String)modelPath);
        }
        return modelUri;
    }

    private URI getDiURI(String modelPath) {
        URI diUri = this.getModelURI(modelPath).trimFileExtension().appendFileExtension("di");
        return diUri;
    }

    private boolean exists(URI uri) {
        if (uri.isFile()) {
            return new File(uri.toFileString()).exists();
        }
        if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && uri.isPlatformResource()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).exists();
        }
        return false;
    }
}

