/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.helper;

public class UnitsHelper {
    public static final double DXA_TO_POINTS = 0.05;
    public static final double POINTS_TO_DXA = 20.0;
    public static final double INCHES_TO_POINTS = 72.0;
    public static final double POINTS_TO_INCHES = 0.013888888888888888;
    public static final double CM_TO_POINTS = 182.88;
    public static final double POINTS_TO_CM = 0.0054680664916885394;
    public static final double POINTS_TO_EMU = 12700.0;
    public static final double EMU_TO_POINTS = 7.874015748031496E-5;

    public static final double convert(Unit from, double val, Unit to) {
        double points = val * from.cte;
        return points / to.cte;
    }

    public static final double convertToPixels(Unit from, double val, int dpi) {
        double points = val * from.cte;
        return points * (double)dpi / 72.0;
    }

    public static final double convertFromPixels(double val, int dpi, Unit to) {
        double points = val * 72.0 / (double)dpi;
        return points / to.cte;
    }

    public static enum Unit {
        DXA(0.05),
        INCH(72.0),
        CM(182.88),
        POINT(1.0),
        EMU(7.874015748031496E-5);

        private double cte;

        private Unit(double cte) {
            this.cte = cte;
        }
    }
}

