/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.preferences;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.text.ParseException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gendoc.preferences.IGendocConfiguration;
import org.eclipse.gendoc.preferences.internal.GendocConfiguration;
import org.eclipse.gendoc.preferences.internal.GendocPreferenceUtils;

public class GendocNature
implements IProjectNature {
    public static final String ID = "org.eclipse.gendoc.preferences.GenDocNature";
    private IProject project;
    private IGendocConfiguration gendocConfiguration;

    public void configure() throws CoreException {
        IFile file = this.project.getFile(".gendoc");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GendocPreferenceUtils.marshall(this.gendocConfiguration, out);
            if (file.exists()) {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (TransformerException e) {
            throw new CoreException(ValidationStatus.error((String)"Can not create Gendoc configuration.", (Throwable)e));
        }
    }

    public void deconfigure() throws CoreException {
        IFile file = this.project.getFile(".gendoc");
        if (file.exists()) {
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
        if (project != null) {
            this.gendocConfiguration = new GendocConfiguration(project);
            try {
                this.load();
            }
            catch (Exception exception) {}
        }
    }

    public IGendocConfiguration getGendocConfiguration() {
        return this.gendocConfiguration;
    }

    public void save() throws TransformerException, CoreException {
        IFile file = this.project.getFile(".gendoc");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GendocPreferenceUtils.marshall(this.gendocConfiguration, out);
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), 1, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), 1, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void load() throws ParseException, CoreException {
        IFile file = this.project.getFile(".gendoc");
        if (file.exists()) {
            this.gendocConfiguration = GendocPreferenceUtils.unmarshall(this.getProject(), file.getContents());
        }
    }
}

