/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.pptx;

import java.util.ArrayList;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.helper.XMLHelper;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractStepProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.pptx.PPTXDocumentService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PPTXTextRunProcess
extends AbstractStepProcess {
    protected void doRun() throws GenDocException {
        IDocumentService docService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        if (!(docService instanceof PPTXDocumentService)) {
            return;
        }
        super.doRun();
    }

    /*
     * WARNING - void declaration
     */
    protected void step(Document document) throws GenDocException {
        Node currentNode = document.getXMLParser().getCurrentNode();
        ArrayList<Element> nodesToDelete = new ArrayList<Element>();
        if (currentNode.getNodeName().equals("a:p")) {
            void var8_9;
            nodesToDelete.clear();
            Element el = (Element)currentNode;
            NodeList nl = el.getChildNodes();
            Element lastText = null;
            String lastRunProps = null;
            boolean bl = false;
            while (var8_9 < nl.getLength()) {
                if (nl.item((int)var8_9) instanceof Element) {
                    Element elem = (Element)nl.item((int)var8_9);
                    if (elem.getNodeName().equals("a:r")) {
                        Element text = (Element)elem.getElementsByTagName("a:t").item(0);
                        NodeList nl2 = elem.getElementsByTagName("a:rPr");
                        Element rPr = (Element)(nl2.getLength() > 0 ? nl2.item(0) : null);
                        String rPrTxt = "";
                        if (rPr != null) {
                            rPr.removeAttribute("lang");
                            rPr.removeAttribute("dirty");
                            rPr.removeAttribute("err");
                            rPrTxt = XMLHelper.asText((Node)rPr, (boolean)false).trim();
                        }
                        if (lastText == null) {
                            lastRunProps = rPrTxt;
                            lastText = text;
                        } else if (rPrTxt.equals(lastRunProps)) {
                            lastText.setTextContent(String.valueOf(lastText.getTextContent()) + text.getTextContent());
                            nodesToDelete.add(elem);
                        }
                    } else {
                        lastText = null;
                        lastRunProps = null;
                    }
                }
                ++var8_9;
            }
            for (Node node : nodesToDelete) {
                node.getParentNode().removeChild(node);
            }
        }
    }
}

