/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.openoffice;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.openoffice.OpenOfficeDocument;
import org.eclipse.gendoc.document.parser.documents.openoffice.OpenOfficeXPathUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class OpenOfficeParser
extends XMLParser {
    private OpenOfficeDocument openOfficeDocument;
    private XMLParser relationships;
    private int relationshipsNextId;
    private HashMap<String, XMLParser> partsDocuments;

    public OpenOfficeParser(OpenOfficeDocument document, File f) {
        super(f);
        this.openOfficeDocument = document;
        this.parse();
    }

    public OpenOfficeParser(OpenOfficeDocument document, File f, Document.CONFIGURATION conf) {
        super(f, conf);
        this.openOfficeDocument = document;
        this.parse();
    }

    protected abstract OpenOfficeXPathUtils getXPathUtils();

    public OpenOfficeDocument getOpenOfficeDocument() {
        return this.openOfficeDocument;
    }

    public String getRelationshipsPath() {
        return String.valueOf(this.getPartParentRelativePath()) + "/" + "_rels" + "/" + this.getXmlFile().getName() + ".rels";
    }

    public String getPartParentRelativePath() {
        try {
            return this.getXmlFile().getParentFile().getAbsolutePath().replace(this.getOpenOfficeDocument().getUnzipLocationDocumentFile().getCanonicalPath(), "").replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPartRelativePath() {
        try {
            return this.getXmlFile().getAbsolutePath().replace(this.getOpenOfficeDocument().getUnzipLocationDocumentFile().getCanonicalPath(), "").replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void parse() {
        String relpath = String.valueOf(this.getPartRelativePath().replace(this.getXmlFile().getName(), "")) + "_rels/" + this.getXmlFile().getName() + ".rels";
        this.relationships = this.getOpenOfficeDocument().getSubdocument(relpath);
        if (this.relationships != null) {
            this.relationshipsNextId = this.getNextRelationId();
        }
        this.partsDocuments = new HashMap();
    }

    public XMLParser loadExplicitPartDocument(String rel, String relId) throws IOException {
        return this.loadPartDocument(String.valueOf(relId) + ":" + rel, "//rel:Relationship[@Type='" + rel + "' and @Id='" + relId + "']/@Target");
    }

    public XMLParser loadImplicitPartDocument(String rel) throws IOException {
        return this.loadPartDocument(rel, "//rel:Relationship[@Type='" + rel + "']/@Target");
    }

    private XMLParser loadPartDocument(String key, String xpath) throws IOException {
        XMLParser parser = this.partsDocuments.get(key);
        if (parser == null && this.relationships != null) {
            NodeList nl;
            block6: {
                try {
                    nl = this.getXPathUtils().evaluateNodes(this.relationships.getDocument(), xpath);
                    if (nl.getLength() != 0) break block6;
                    return null;
                }
                catch (XPathExpressionException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            String target = ((Attr)nl.item(0)).getValue();
            File f = new File(this.getOpenOfficeDocument().getUnzipLocationDocumentFile(), target.replace("/", File.separator));
            if (!target.startsWith("/")) {
                f = new File(this.getXmlFile().getParentFile(), target).getCanonicalFile();
            }
            String relpath = f.getAbsolutePath().replace(this.getOpenOfficeDocument().getUnzipLocationDocumentFile().getCanonicalPath(), "");
            parser = this.getOpenOfficeDocument().getSubdocument(relpath);
            if (parser != null) {
                this.partsDocuments.put(key, parser);
            }
        }
        return parser;
    }

    public String addRelationship(String relationshipType, String target) throws IOException {
        try {
            if (this.relationships == null) {
                this.createRelationshipPart();
            }
            Element relationshipsEl = (Element)this.getXPathUtils().evaluateNode(this.relationships.getDocument(), "/rel:Relationships");
            Element rel = (Element)relationshipsEl.appendChild(this.relationships.getDocument().createElementNS("http://schemas.openxmlformats.org/package/2006/relationships", "rel:Relationship"));
            String id = "rId" + this.relationshipsNextId;
            rel.setAttribute("Id", id);
            rel.setAttribute("Type", relationshipType);
            String relTarget = new Path(target).makeRelativeTo((IPath)new Path(this.getPartParentRelativePath())).toString();
            rel.setAttribute("Target", relTarget);
            ++this.relationshipsNextId;
            return id;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void createRelationshipPart() throws IOException {
        this.relationships = this.getOpenOfficeDocument().createSubdocument(this.getRelationshipsPath(), "<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\"/>");
        ++this.relationshipsNextId;
    }

    public int getNextRelationId() {
        try {
            List<String> values = this.getXPathUtils().evaluateValues(this.relationships.getDocument(), "/rel:Relationships/rel:Relationship/@Id[starts-with(.,'rId')]");
            int nextId = 1;
            int i = 0;
            while (i < values.size()) {
                String last = values.get(i).substring(3);
                try {
                    nextId = Math.max(nextId, Integer.valueOf(last));
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
            return nextId + 1;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

